/* $Id: glue-gui-gtk.c,v 1.41 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <glib.h>

#if defined(DARWIN)
#include <sys/types.h>
#endif

#include "glue-gui-gtk.h"
#include "glue-io.h"
#include "glue-log.h"
#include "glue-main.h"

static GMainContext *main_context = NULL;
static GPollFD fds_gpoll[FD_SETSIZE];
static gint max_priority;
static int fds_length = 0;
static char gui_fd_registered[FD_SETSIZE];

static void
gui_gtk_io(int fd, void *s)
{
	gui_gtk_flush();
}

static void
gui_gtk_time(void *s)
{
	gui_gtk_flush();
}

static void
gui_gtk_reg(int fd)
{
	io_register(fd, (void *) 1, gui_gtk_io);
}

static void
gui_gtk_prepare_event(void)
{
	int ret;
	gint timeout;
	unsigned long long t;
	unsigned int i;
	unsigned int j;

	ret =  g_main_context_acquire(main_context);
	assert(ret == TRUE);

	g_main_context_prepare(main_context, &max_priority);

	fds_length = g_main_context_query(main_context,
			max_priority, &timeout, fds_gpoll, FD_SETSIZE);

	time_call_delete(gui_gtk_time, (void *) 1);

	if (0 <= timeout) {
		t = time_virt() + timeout * TIME_HZ / 1000;
	} else {
		t = -1ULL;
	}

	time_call_at(t, gui_gtk_time, (void *) 1);

	for (i = 0; i < FD_SETSIZE; i++) {
		for (j = 0; ; j++) {
			if (j == fds_length) {
				/* Not found. */
				if (gui_fd_registered[i]) {
					io_unregister(i);
					gui_fd_registered[i] = 0;
				}
				break;
			}
			if (fds_gpoll[j].fd == i
			 && (fds_gpoll[j].events & G_IO_IN)) {
				/* Found. */
				if (! gui_fd_registered[i]) {
					gui_gtk_reg(i);
					gui_fd_registered[i] = 1;
				}
				break;
			}
		}
	}

	g_main_context_release(main_context);
}

static int
gui_gtk_handle_event(void)
{
	unsigned int i;
	int ret;

	ret =  g_main_context_acquire(main_context);
	assert(ret == TRUE);

	for (i = 0; i < fds_length; i++) {
		fds_gpoll[i].revents = G_IO_IN;
	}

	if (g_main_context_check(main_context, max_priority,
			fds_gpoll, fds_length)) {
		g_main_context_dispatch(main_context);
		ret = 1;
	} else {
		ret = 0;
	}

	g_main_context_release(main_context);

	return ret;
}

void
gui_gtk_flush(void)
{
	static int running = 0;
	int more;

	if (running) {
		return;
	}
	running = 1;

	more = gui_gtk_handle_event();
	do {
		gdk_display_flush(gdk_display_get_default());
		gui_gtk_prepare_event();
		more = gui_gtk_handle_event();
	} while (more);
	gdk_display_flush(gdk_display_get_default());
	gui_gtk_prepare_event();

	running = 0;
}

void
gui_gtk_init(void)
{
	main_context = g_main_context_default();

	time_call_at(-1ULL, gui_gtk_time, (void *) 1);

	gui_gtk_prepare_event();
}

void
gui_gtk_exit(void)
{
	(void) gui_gtk_handle_event();

	time_call_delete(gui_gtk_time, (void *) 1);
}
