#!/usr/bin/python
# -*- coding: utf-8; Mode: Python; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2010 Canonical Ltd.
# Written by Michael Terry <michael.terry@canonical.com>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import os
import gettext
import subprocess

DOMAIN = 'fastboot-config'
UIDIR = '/usr/share/fastboot-config/firstboot'
LOCALEDIR = '/usr/share/locale'

accepted = False

class FirstBoot():
    pages = []
    page = 0

    def __init__(self):
        self.builder = gtk.Builder()

        self.builder.set_translation_domain(DOMAIN)
        self.builder.add_from_file(UIDIR + '/welcome.ui')
        self.builder.add_from_file(UIDIR + '/frame.ui')
        self.builder.connect_signals(self)

        notebook = self.builder.get_object('steps')
        notebook.append_page(self.builder.get_object('omskWelcome'))
        notebook.set_current_page(0)
        self.page_switched()

        self.frame = self.builder.get_object('live_installer')
        self.frame.show()

    def page_switched(self):
        notebook = self.builder.get_object('steps')
        next = self.builder.get_object('next')
        #back = self.builder.get_object('back')
        windows = self.builder.get_object('windows')
        step_label = self.builder.get_object('step_label')
        isFirstPage = notebook.get_current_page() == 0
        isLastPage = notebook.get_current_page() == notebook.get_n_pages() - 1
        next.set_use_stock(True)
        next.set_label('gtk-ok')
        if not isFirstPage:
            step_text = _('Step ${INDEX} of ${TOTAL}')
            step_text = step_text.replace('${INDEX}', str(notebook.get_current_page() + 1))
            step_text = step_text.replace('${TOTAL}', str(notebook.get_n_pages()))
            step_label.set_label(step_text)
        #back.set_sensitive(not isFirstPage)
        windows.set_visible(isFirstPage)
        step_label.set_visible(not isFirstPage)

    #def on_back_clicked(self, *args):
    #    notebook = self.builder.get_object('steps')
    #    notebook.prev_page()
    #    self.page_switched()

    def on_next_clicked(self, *args):
        global accepted
        notebook = self.builder.get_object('steps')
        if notebook.get_current_page() == notebook.get_n_pages() - 1:
            accepted = True
            self.frame.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
            gtk.main_quit()
        else:
            notebook.next_page()
        self.page_switched()

    def on_windows_clicked(self, *args):
        controls = self.builder.get_object('navigation_control')
        controls.set_sensitive(False)
        os.system('sudo winboot-reboot')

    def on_live_installer_delete_event(self, *args):
        gtk.main_quit()

gettext.bindtextdomain(DOMAIN, LOCALEDIR)
gettext.textdomain(DOMAIN)
gettext.install(DOMAIN, LOCALEDIR, unicode=1)

fb = FirstBoot()
gtk.main()
os.system('sudo start plymouth')

if accepted:
    # Drop admin privileges from first user
    pwline = subprocess.Popen(["getent", "passwd", "1000"], stdout=subprocess.PIPE).communicate()[0].strip()
    if pwline:
        linuser = pwline.split(':')[0]
        os.system("gpasswd -d %s admin" % linuser) # drop from admin group
        os.system("usermod -p '*' %s" % linuser) # delete any password

    # Don't run again
    os.system('mkdir -p /var/lib/omsk')
    os.system('touch /var/lib/omsk/firstboot-ran')
