/* e-book-backend-android-factory.c - Android contact backend factory.
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authors:
 *      Renato Araujo Oliveira Filho <renato@canonical.com>
 *
 */

#include <libebackend/e-data-server-module.h>
#include <libedata-book/e-book-backend-factory.h>
#include "e-book-backend-android.h"


E_BOOK_BACKEND_FACTORY_SIMPLE (android, Android, e_book_backend_android_new)

static GType android_type;

void eds_module_initialize (GTypeModule *module)
{
    android_type = _android_factory_get_type (module);
}

void eds_module_shutdown (void)
{
}

void eds_module_list_types (const GType **types, gint *num_types)
{
    *types     = &android_type;
    *num_types = 1;
}
