from setuptools import setup, find_packages


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
ENVISAGE = etsdep('enthought.envisage', '2.0.1b1', '3.0')
IO = etsdep('enthought.io', '2.0.1b1', '3.0')
PYFACE_DOCK = etsdep('enthought.pyface[dock]', '2.0.1b1', '3.0')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.1b1', '3.0')
TRAITSUIWX = etsdep('enthought.traits.ui.wx', '2.0.1b1', '3.0')
UTIL = etsdep('enthought.util', '2.0.1b2', '3.0')


setup(
    author = 'Enthought, Inc',
    author_email = 'info@enthought.com',
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        ],
    description = 'Envisage GUI developer tools',
    extras_require = {
        'plugin': [
            ENVISAGE,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            ],
        },
    include_package_data = True,
    install_requires = [
        IO,
        PYFACE_DOCK,
        TRAITS_UI,
        TRAITSUIWX,
        UTIL,
        ],
    license = 'BSD',
    name = 'enthought.developer',
    namespace_packages = [
        "enthought",
        ],
    packages = find_packages(exclude=['docs']),
    tests_require = [
        'nose >= 0.9',
        ],
    test_suite = 'nose.collector',
    url = 'http://code.enthought.com/ets',
    version = '2.0.1b1',
    zip_safe = False,
    )

