/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _FORBIDDEN_OPERATION_LISTENER_H_
#define _FORBIDDEN_OPERATION_LISTENER_H_

#include <wx/event.h>
#include <wx/arrstr.h>

enum OperationCode
{
    OP_NULL,
    OP_IP_DNS,
    OP_TURN_ON_WIRELESS,
    OP_WINDOWS_FIRE_WALL,
    OP_FILE_SHARING,
    OP_INTERNET_SHARING,
    OP_IMPORT_SCHOOL_SETTING,
    OP_WRITE_FILE,
};

enum NetworkOperationResult
{
    OPERATION_SUCCESS,
    OPERATION_FAILED,
    OPERATION_DENINED
};

WX_DEFINE_ARRAY_INT(OperationCode, OperationCodeArray);

// declaration of class OperationEvent

const unsigned long ID_OPERATION_PROVIDER = wxID_HIGHEST + 0x0270;

BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(wxEVT_FORBIDDEN_OPERATION, -1)
END_DECLARE_EVENT_TYPES()

class OperationEvent : public wxEvent
{
public:
    OperationEvent(OperationCode opCode = OP_NULL);
    ~OperationEvent();
    virtual wxEvent* Clone() const;

    OperationCode GetOperationCode() const;
    wxString GetDescription() const;

private:
    const OperationCode m_opCode;
};

typedef void (wxEvtHandler::*wxOperationEventFunction)(const OperationEvent&);

#define EVT_OPERATION_FORBIDDEN(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_FORBIDDEN_OPERATION, id, -1, \
        (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
        wxStaticCastEvent( wxOperationEventFunction, & fn ), (wxObject *) NULL ),

// declaration of class ForbiddenOperationListener

class ForbiddenOperationListener : public wxEvtHandler
{
public:
    virtual ~ForbiddenOperationListener();

    void AppendOperation(OperationCode opCode);
    wxArrayString SubmitAppending();

    static ForbiddenOperationListener* GetInstance();
    static wxString GetDescription(OperationCode opCode);

private:
    OperationCodeArray m_array;
    static ForbiddenOperationListener* ms_pInstance;

    ForbiddenOperationListener();
    void OnOperationForbidden(const OperationEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _FORBIDDEN_OPERATION_LISTENER_H_
