/*
 * Device Control Service  -- Plugins
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_PLUGIN_H
#define DCS_PLUGIN_H

#include "DCSCommon.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Function pointer to dispatch event.
 */
typedef void (*DCS_DispatchEvent)(int moduleId, int eventId, PVOID pData, size_t dataLen);

/** Aggregate of interface exposed to plugins by DCS. */
typedef struct DCS_Funcs_S {
	UINT version;					/**< Version of DCS */
	DCS_DispatchEvent dispatchEvent;/**< Function to dispatch events */
} DCS_Funcs;

/** Aggregate of parameters for DP_HandleRequest. */
typedef struct DCS_RequestData_S {
	int			cliId;			/**< The client process ID */
	int			funcId;			/**< The requested function ID */
	DCS_UserID	userId;			/**< Requestor's user ID */
	PVOID		pParams;		/**< Pointer to parameters */
	size_t		paramsLen;		/**< Size of parameters */
	PVOID		pReturnData;	/**< Pointer to memory to store return data */
	size_t		pReturnDataLen;	/**< Pointer to available memory size for
								  	 return data.  It will be updated to
									 actual return data size on function
									 return, or change to \c (size_t)-1
									 to indicate insufficient memory
									 space. */
} DCS_RequestData;

/**
 * Gets the module ID.
 */
DCSAPI int DP_GetModuleID();
/**
 * Gets the description of the module.
 */
DCSAPI const char *DP_GetDescription();
/**
 * Initializes the module and passes the host function pointers.
 *
 * @param pFuncs	pointer to the DCS function interface
 */
DCSAPI int DP_Initialize(DCS_Funcs *pFuncs);
/**
 * Uninitializes the module and cleans up.
 */
DCSAPI int DP_Uninitialize();
/**
 * Handles the function request.
 *
 * @param pRequest	pointer to request data
 */
DCSAPI DCS_Return_Code DP_HandleRequest(DCS_RequestData *pRequest);
/**
 * Destroys data related to a client.
 * DCS will call this function when DCS detects that a client exits.
 *
 * @param cliId	the client process ID
 */
DCSAPI int DP_DestroyClient(int cliId);

#ifdef __cplusplus
}
#endif

#endif /* DCS_PLUGIN_H */
