/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "WirelessScanner.h"
#include <wx/utils.h>
#if defined(__UNIX__)
#include <linux/types.h>
#include <sys/socket.h>
#include <linux/wireless.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#endif
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <wx/msgdlg.h>
#include "wlan.h"
#include "KeyDialog.h"
#include "ENMUtil.h"
#include <string>
#include "DataCenter.h"
#include "DataThread.h"
#include <wx/event.h>
using namespace std;
#define BUFFERSIZE 1024
#define ORDERBUFSIZE 128
const wxString g_path = ENMUtil::GetCurrentUserAppDataFolder();
BEGIN_EVENT_TABLE(WirelessScanner, wxEvtHandler)
    EVT_SCAN(ID_SCAN_OVER, WirelessScanner::ScanOver)
END_EVENT_TABLE()
WirelessScanner::WirelessScanner()
{
    memset(name, 0, IFNAMSIZ);
    m_pThread = NULL;
    m_scanThread = NULL;
    m_pAPList = new AccessPointList();
}

WirelessScanner::~WirelessScanner()
{
    if ( m_pAPList != NULL )
    {
        delete m_pAPList;
        m_pAPList = NULL;
    }
}
#if defined(__UNIX__)
int WirelessScanner::ScanWireless()
{
    m_scanThread = new ScanAPThread();
	if ( m_scanThread->Create() == wxTHREAD_NO_ERROR )
	{
		if ( m_scanThread->Run() != wxTHREAD_NO_ERROR )
		{
		    printf("cannot run thread\n");
        }
	}
	else
	{
	    printf("cannot create thread\n");
    }
    return 1;
}
void WirelessScanner::ScanOver(ScanEvent& event)
{
    ParseFile(m_pAPList);
}

void WirelessScanner::ParseFile(AccessPointList* pList)
{
    ifstream in;
    string sPath = "/tmp/scanresult.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[BUFFERSIZE];
    APStatus ap;
    memset(&ap, '\0', sizeof(APStatus));
    vector<APStatus> APVec;
//    wxString content;
    wxString MAC;
    wxString Essid;
    wxString Protocol;
    wxString tempChannel;
    int channel;
    wxString key;
    wxString tempQual;
    int qual;
    wxString auth;
//    bool IfEncrypt = false;
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxString content = wxString::FromUTF8(cFileBuf);
        if ((int) content.find(wxT("Address:")) > 0)
        {
            MAC = content.Mid(content.find(wxT(":")) + 2, 18);
            const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(MAC);
            const char* tmp_str = (const char*) tmp_buf;
            //printf("tmp_str is %s\n", tmp_str);
//            const char* tmp_str = MAC.fn_str();
            StringToMacAddress((unsigned char*)ap.macAddress, tmp_str, 17);
//            memset(&(ap.macAddress), '\0', 32);
//            memcpy(&(ap.macAddress), tmp_str, 17);
            //printf("here is %s\n", ap.macAddress);
        }
        else if ((int) content.find(wxT("ESSID:")) > 0)
        {
            Essid = content.Mid(content.find(wxT("ESSID:")) + 7, content.Len() - content.find(wxT(":")) - 3);
            wmemset(ap.name, 0, AP_SSID_MAX_LENGTH);
            if (Essid.Contains(wxT("<hidden>")) || Essid.IsEmpty())
            {
                const char* tmp_str = "notshow";
                mbstowcs(ap.name, tmp_str, strlen(tmp_str));
            }
            else
            {
                string sName = ENMUtil::WxStringToString(Essid);
                mbstowcs(ap.name, sName.c_str(), sName.length());
                ap.ssid.length = (ENMUtil::WxStringToString(Essid)).length();
                memset(ap.ssid.ucSsid, '\0', AP_SSID_MAX_LENGTH);
                strncpy((char*)ap.ssid.ucSsid, ENMUtil::WxStringToString(Essid).c_str(), AP_SSID_MAX_LENGTH);
            }
        }
        else if ((int) content.find(wxT("Protocol:")) > 0)
        {
            Protocol = content.Mid(content.find(wxT("Protocol:")) + 9);
            if (Protocol.Contains(wxT("bg")))
            {
                ap.type = WLAN_802_11_G;
            }
            else if (Protocol.Contains(wxT("b")))
            {
                ap.type = WLAN_802_11_B;
            }
            else if (Protocol.Contains(wxT("n")))
            {
                ap.type = WLAN_802_11_N;
            }
            else if (Protocol.Contains(wxT("g")))
            {
                ap.type = WLAN_802_11_G;
            }
            else
            {
                ap.type = WLAN_UNKNOWN;
            }
            //printf("type %d\n", ap.type);
        }
        else if ((int) content.find(wxT("Channel ")) > 0)
        {
            tempChannel = content.Mid(content.find(wxT("Channel ")) + 8, (content.find(wxT(")")) - content.find(wxT("Channel ")) - 8));
            channel = atoi(tempChannel.fn_str());
            ap.channel = channel;
            //printf("channel %d\n", ap.channel);
        }
        else if ((int) content.find(wxT("Encryption key:")) > 0)
        {
            ap.auth = WLAN_AUTH_UNKNOWN;
            key = content.Mid(content.find(wxT("Encryption key:")) + 15);
            if (key.Contains(wxT("off")))
            {
                ap.auth = WLAN_AUTH_OPEN_NONE;
            }
        }
        else if ((int) content.find(wxT("Quality=")) > 0)
        {
            tempQual = content.Mid(content.find(wxT("Quality=")) + 8, (content.find(wxT("/")) - content.find(wxT("Quality=")) - 8));
            qual = atoi(tempQual.fn_str());
            ap.signalQuality = qual;
            //printf("signalQuality %d\n", ap.signalQuality);
        }
        else if ((int) content.find(wxT("IE: ")) > 0)
        {
            auth = content.Mid(content.find(wxT("IE: ")) + 4, 3);
//            if (IfEncrypt)
//            {
            if (auth.Contains(wxT("WEP")))
            {
                ap.auth = WLAN_AUTH_OPEN_WEP;
            }
            else if (auth.Contains(wxT("WPA")))
            {
                ap.auth = WLAN_AUTH_WPAPSK_TKIP;
            }
            else
            {
                ap.auth = WLAN_AUTH_UNKNOWN;
            }
//                IfEncrypt = false;
//            }
            //printf("auth %d\n", ap.auth);

        }
        else if ((int) content.find(wxT("Extra:")) > 0)
        {
            if (wcscmp(ap.name, wxT("notshow")))
            {
                APVec.push_back(ap);
            }
        }
        else
        {
            //do nothing
        }
    }
    if (!APVec.empty())
    {
//        pList->apList = new APStatus[APVec.size()];
        int k = 0;
        for (vector<APStatus>::iterator it = APVec.begin(); it != APVec.end(); ++it)
        {
            pList->apList[k] = *it;
            k++;
        }
        pList->nCount = k;
    }
    in.close();
}

void WirelessScanner::GetInterface()
{
	int iRC;
	int iSkfd;
	struct iwreq wrq;
	if ((iSkfd = OpenSockets()) < 0)
	{
		perror("socket");
	}
	else
	{
		char cBuffer[BUFFERSIZE];

//		struct ifconf ifc;
		struct ifreq* ifr;
		int	i;
		ifc.ifc_len = sizeof(cBuffer);
		ifc.ifc_buf = cBuffer;
		if(ioctl(iSkfd, SIOCGIFCONF, &ifc) < 0)
		{

			//printf("ioctl error");
		}
		ifr = ifc.ifc_req;
        //printf("total ifc is %d\n", i = ifc.ifc_len / sizeof(struct ifreq));
		for(i = ifc.ifc_len / sizeof(struct ifreq); --i >= 0; ifr++)
		{

			iRC = GetExt(iSkfd, ifr->ifr_name, SIOCGIWNAME, &wrq);
			//printf("iRC is %d on %s\n", iRC, ifr->ifr_name);
			if (iRC == 0)
			{
				memcpy(name, ifr->ifr_name, IFNAMSIZ);
				//printf("get name by original method--->%s\n", name);
				break;
			}

		}
	}
	close(iSkfd);
}

void WirelessScanner::GetIfname()
{
    wxShell(wxT("ifconfig > /tmp/ifconf.txt"));
    wxShell(wxT("exit 0"));
    ParseConfFile();
}

void WirelessScanner::ParseConfFile()
{
    ifstream in;
    int iSkfd;
	struct iwreq wrq;
//    struct ifreq* ifr;
	if ((iSkfd = OpenSockets()) < 0)
	{
		perror("socket");
	}
	string sPath = "/tmp/ifconf.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[BUFFERSIZE];
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        memset(name, 0, IFNAMSIZ);
        if (cFileBuf[0] != ' ')
        {
            int i = 0;
            while (cFileBuf[i] != ' ' &&  cFileBuf[i] != '\t' &&  cFileBuf[i] != '\n' &&  cFileBuf[i] != '\0')
            {
                name[i] = cFileBuf[i];
                i++;
            }
            if (name[0] != '0')
            {
                strncpy(wrq.ifr_name, name, IFNAMSIZ);
                int j = ioctl(iSkfd, SIOCGIWNAME, &wrq);
                if (0 == j)
                {
                    break;
                }
            }
        }
    }
    close(iSkfd);
    in.close();
}

WlanResult WirelessScanner::ConnectWlanNetwork(const APStatus& ap, const wxString key,const wxString usingAdpterName)
{
    if ( usingAdpterName.IsEmpty() )
    {
        return WLAN_NO_INTERFACE;
    }
    DataCenter::GetInstance()->CloseWlanConnection();
    char cFirOrder[ORDERBUFSIZE];
    const char * name = ENMUtil::WxStringToString(usingAdpterName).c_str();
//    sprintf(cFirOrder, "ifconfig %s 127.0.0.1", name);
//    system(cFirOrder);
    switch(ap.auth)
    {

        case WLAN_AUTH_WPAPSK_TKIP:
        {

            const char* cKey = ENMUtil::WxStringToString(key).c_str();
            sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ap.ssid.ucSsid, cKey);
            system(cFirOrder);
            sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf", name);
//            system(cFirOrder);
            wxExecute(wxString::FromUTF8(cFirOrder), wxEXEC_ASYNC);
        }
        break;
        case WLAN_AUTH_OPEN_WEP:
        {
            const char* cKey = ENMUtil::WxStringToString(key).c_str();
            sprintf(cFirOrder, "iwconfig %s essid %s", name, ap.ssid.ucSsid);
            system(cFirOrder);
            sprintf(cFirOrder, "iwconfig %s key %s", name, cKey);
            system(cFirOrder);
            AllocateIP();
        }
        break;
        default:
        {
            sprintf(cFirOrder, "iwconfig %s essid %s", name, ap.ssid.ucSsid);
            system(cFirOrder);
            AllocateIP();
        }
        break;
    }
//    sprintf(cFirOrder, "iwconfig %s essid %s", usingAdpterName, ap.ssid.ucSsid);
//    wxShell(wxString::FromUTF8(cFirOrder));
//    wxShell(wxT("exit 0"));
    return WLAN_SUCCESS;
}


SearchThread* WirelessScanner::CreateSearchThread()
{
//    if( m_pThread != NULL)
//        delete m_pThread;

    m_pThread = new SearchThread();

	if ( m_pThread->Create(30000000) != wxTHREAD_NO_ERROR )
	{
//		int m = 0;
	}
	return m_pThread;
}

void WirelessScanner::AllocateIP()
{
    DCS_AllocateDhIP();
//    SearchThread*  thread = CreateSearchThread();
//    if ( thread->Run() != wxTHREAD_NO_ERROR )
//	{
//		int n = 0;
//	}
}

void WirelessScanner::GetConnect(APStatus* ap)
{
//    char cFirOrder[ORDERBUFSIZE];
//
//    wxString key = wxT("");
//    if (ap->auth == WLAN_AUTH_WPAPSK_TKIP)
//    {
//        KeyDialog* dlg = new KeyDialog(NULL);
//        if (dlg->ShowModal() == wxID_OK)
//        {
//            key = dlg->GetKey();
//        }
//        else
//        {
//            return;
//        }
//        const wxWX2MBbuf tempKey = wxConvCurrent->cWX2MB(key);
//        const char* cKey = (const char*) tempKey;
////        //printf("cKey is %s\n", cKey);
//        sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ap->ssid.ucSsid, cKey);
////        //printf("cFirOrder is %s\n", cFirOrder);
//        wxShell(wxString::FromUTF8(cFirOrder));
//        wxShell(wxT("exit 0"));
////        //printf("name is %s\n", name);
//        sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf", name);
////        //printf("cFirOrder is %s\n", cFirOrder);
//        wxExecute(wxString::FromUTF8(cFirOrder), wxEXEC_ASYNC);
//        wxShell(wxT("exit 0"));
//
////        sprintf(cFirOrder, "dhclient %s", name);
////        //printf("cFirOrder is %s\n", cFirOrder);
//    }
//    else if (ap->auth == WLAN_SECURITY_WEP)
//    {
//        KeyDialog* dlg = new KeyDialog(NULL);
//        if (dlg->ShowModal() == wxID_OK)
//        {
//            key = dlg->GetKey();
//        }
//        else
//        {
//            return;
//        }
//        const wxWX2MBbuf tempKey = wxConvCurrent->cWX2MB(key);
//        const char* cKey = (const char*) tempKey;
////        //printf("cKey is %s\n", cKey);
//        sprintf(cFirOrder, "iwconfig %s essid %s", name, ap->ssid.ucSsid);
////        //printf("cFirOrder is %s\n", cFirOrder);
//        wxShell(wxString::FromUTF8(cFirOrder));
//        wxShell(wxT("exit 0"));
//        sprintf(cFirOrder, "iwconfig %s key %s", name, cKey);
////        //printf("cFirOrder is %s\n", cFirOrder);
//        wxShell(wxString::FromUTF8(cFirOrder));
//        wxShell(wxT("exit 0"));
//    }
//    else
//    {
//        sprintf(cFirOrder, "iwconfig %s essid %s", name, ap->ssid.ucSsid);
////        //printf("cFirOrder is %s\n", cFirOrder);
//        wxShell(wxString::FromUTF8(cFirOrder));
//        wxShell(wxT("exit 0"));
//
////        //printf("look, shell is ok\n");
////        sprintf(cFirOrder, "dhclient %s", name);
////        wxShell(wxString::FromUTF8(cFirOrder));
//    }
}

bool WirelessScanner::IfConnect()
{
    struct sockaddr_in *addr;
    struct ifreq ifr;
    char* address;
    int sockfd;
    if (name == NULL)
    {
        return false;
    }
    sockfd = socket(PF_INET,SOCK_DGRAM,0);
    strncpy(ifr.ifr_name,name,IFNAMSIZ);

    if(ioctl(sockfd,SIOCGIFADDR,&ifr) == -1)
    {
        perror("ioctl error");
        close(sockfd);
        return false;
    }
    else
    {
    	close(sockfd);
        addr = (struct sockaddr_in *)&(ifr.ifr_addr);
        address = inet_ntoa(addr->sin_addr);
        if (address == NULL)
        {
            return false;
        }
        else
        {
//            //printf("address is %s\n", address);
            if (!strcmp(address, "127.0.0.1"))
            {
//                //printf("loopback\n");
                return false;
            }
            else
            {
//                //printf("normal\n");
                return true;
            }
        }
    }

}

int WirelessScanner::OpenSockets()
{
	static const int families[] = {
		AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
	};
	unsigned int i;
	int	sock;

	for(i = 0; i < sizeof(families)/sizeof(int); ++i)
	{
		sock = socket(families[i], SOCK_DGRAM, 0);
		if(sock >= 0)
        return sock;
	}

	return -1;
}

int WirelessScanner::GetExt(int	iSkfd, char* ifname, int request, struct iwreq* pwrq)
{
	strncpy(pwrq->ifr_name, ifname, IFNAMSIZ);
	return(ioctl(iSkfd, request, pwrq));
}

bool WirelessScanner::UpdateCurrentAP(APStatus& apStatus)
{
    //printf("name is %s\n", apStatus.ssid.ucSsid);
    ScanWireless();
    if ( m_pAPList == NULL )
    {
        return false;
    }
    for (int i = 0 ; i < m_pAPList->nCount ; i ++)
    {
        if (m_pAPList->apList[i].ssid == apStatus.ssid)
        {
            apStatus = m_pAPList->apList[i];
            return true;
        }
    }
    return false;
}

#endif
