/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ProxySettings.h"
#include <wx/string.h>
#include "ENMApp.h"
#include <wx/msgdlg.h>
#include "ENMUtil.h"

const long ProxySettings::ID_TCPROXY = wxNewId();
const long ProxySettings::ID_TCPORT = wxNewId();
const long ProxySettings::ID_BUTTONCANCEL = wxNewId();
const long ProxySettings::ID_BUTTONOK = wxNewId();

BEGIN_EVENT_TABLE(ProxySettings, wxDialog)
    EVT_INIT_DIALOG(ProxySettings::OnInit)
    EVT_BUTTON(ID_BUTTONCANCEL, ProxySettings::OnButtonCancelClick)
    EVT_BUTTON(ID_BUTTONOK, ProxySettings::OnButtonOKClick)
END_EVENT_TABLE()

ProxySettings::ProxySettings(wxWindow* parent)
        : wxDialog(parent, wxID_ANY, _("Proxy Settings"))
{
    int dialogWidth = 400;
    int dialogHeight = 130;
    int margin = 10;
	SetClientSize(wxSize(dialogWidth, dialogHeight));

    wxSize boxSize(dialogWidth - margin * 2, 65);
    m_StProxyServer = new wxStaticBox(this, wxID_ANY, _("Proxy Server"), wxPoint(margin, margin), boxSize);

    int x = margin * 2;
    int y = margin * 3 + 5;
	m_StProxy = new wxStaticText(this, wxID_ANY, _("Address:"), wxPoint(x, y + 2), wxSize(80,24));
	x += margin + 80;
	m_TcProxy = new wxTextCtrl(this, ID_TCPROXY, wxEmptyString, wxPoint(x, y), wxSize(160,24));

    x += margin + 160;
	m_StPort = new wxStaticText(this, wxID_ANY, _("Port:"), wxPoint(x, y + 2), wxSize(40, 24));
	x += margin + 40;
	m_TcPort = new wxTextCtrl(this, ID_TCPORT, wxEmptyString, wxPoint(x, y), wxSize(50,24));

    wxSize buttonSize(80, 30);
	x = dialogWidth - (buttonSize.GetWidth() + margin) * 2;
	y = dialogHeight - buttonSize.GetHeight() - margin;

#if defined(__UNIX__)
	m_BtnCancel = new wxButton(this, ID_BUTTONCANCEL, _("Cancel"), wxPoint(x, y), buttonSize);
	x += buttonSize.GetWidth() + margin;
	m_BtnOK = new wxButton(this, ID_BUTTONOK, _("OK"), wxPoint(x, y), buttonSize);
#endif
    m_BtnOK->SetDefault();
}

ProxySettings::~ProxySettings()
{
}

void ProxySettings::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_TcProxy->SetFocus();
}

void ProxySettings::OnButtonCancelClick(wxCommandEvent& event)
{
    m_TcProxy->SetValue(_T(""));
    m_TcPort->SetValue(_T(""));
    Close();
}

void ProxySettings::OnButtonOKClick(wxCommandEvent& event)
{
    if ( m_TcProxy->IsEmpty() )
    {
        wxMessageDialog msg(this, _("Proxy cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcProxy->SetFocus();
        return;
    }
    if ( !m_TcProxy->GetValue().IsAscii() )
    {
        wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcProxy->SetFocus();
        return;
    }
    if (m_TcPort->IsEmpty())
    {
        wxMessageDialog msg(this, _("Port field cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcPort->SetFocus();
        return;
    }
    if ( !ENMUtil::IsOnlyNumber(m_TcPort->GetValue()) )
    {
        wxMessageDialog msg(this, _("Only numbers allowed in the Port field!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcPort->SetFocus();
        return;
    }
    EndModal(wxID_OK);
}

