/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ProfileGeneralSettings.h"
#include <wx/msgdlg.h>
#include <wx/sizer.h>
#include <wx/file.h>
#include "ENMApp.h"
#include "ENMUtil.h"
#include "ProfileManagerDlg.h"

const long ProfileGeneralSettings::ID_NAMETEXTCTRL = wxNewId();
const long ProfileGeneralSettings::ID_CONTYPECOMBOBOX = wxNewId();
const long ProfileGeneralSettings::ID_NAMECOMBOBOX = wxNewId();

const wxString ProfileGeneralSettings::STR_WIZARD_BACK(_("< &Back"));
const wxString ProfileGeneralSettings::STR_WIZARD_NEXT(_("&Next >"));
const wxString ProfileGeneralSettings::STR_WIZARD_FINISH(_("&Finish"));

BEGIN_EVENT_TABLE(ProfileGeneralSettings, wxWizard)
    EVT_COMBOBOX(ID_CONTYPECOMBOBOX, ProfileGeneralSettings::OnProfileTypeSelected)
    EVT_WIZARD_PAGE_CHANGING(wxID_ANY, ProfileGeneralSettings::OnWizardChanging)
    EVT_WIZARD_FINISHED(wxID_ANY, ProfileGeneralSettings::OnWizardFinished)
    EVT_WIZARD_CANCEL(wxID_ANY, ProfileGeneralSettings::OnWizardCancel)
END_EVENT_TABLE()

ProfileGeneralSettings::ProfileGeneralSettings(wxWindow* parent)
        : wxWizard(parent, wxID_ANY, _("New Network Profile"), wxBitmap(), wxDefaultPosition, wxDEFAULT_DIALOG_STYLE)
{
	SetClientSize(wxSize(530,340));
    // a wizard page may be either an object of predefined class
    m_pagestep1 = new wxWizardPageSimple(this);
    int width = 530, height = 300;
    int margin = 10;
    m_pagestep1->SetSize(width, height);
    wxSizer* pSizer = GetPageAreaSizer();
    pSizer->SetMinSize(width, height);
    SetBorder(0);
    pSizer->Add(m_pagestep1);

    wxBitmap bmpTitle(::wxGetApp().strImagePath + _T("step1.png"), wxBITMAP_TYPE_PNG);
	m_sbPic = new wxStaticBitmap(m_pagestep1, wxID_ANY, bmpTitle, wxPoint(0, 0), wxDefaultSize);
	m_lineSt1 = new wxStaticLine(m_pagestep1, wxID_ANY, wxPoint(0, bmpTitle.GetHeight()), wxSize(width, 1), wxLI_HORIZONTAL);

	m_textGs = new wxStaticText(m_pagestep1, wxID_ANY, _("General Settings"), wxPoint(5, 5));
	wxFont m_textGsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textGs->SetFont(m_textGsFont);
	m_textDes1 = new wxStaticText(m_pagestep1, wxID_ANY, _("Input the network profile name and select network connection type"), wxPoint(margin,30), wxSize(width - margin * 2,35));

    int x = margin;
    int y = bmpTitle.GetHeight() + margin;
    int h = 26;
    wxSize labelSize(200, 20);

	m_textPn = new wxStaticText(m_pagestep1, wxID_ANY, _("Profile Name:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_tcName = new wxTextCtrl(m_pagestep1, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(255, h));
	m_tcName->SetMaxLength(32);
    m_cbbName = new wxBitmapComboBox(m_pagestep1, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(width - 38 - margin, y), wxSize(50, 24), 0, NULL, wxCB_READONLY);
    static const size_t PROFILE_ICON_COUNT = 8;
    for ( size_t i = 0; i < PROFILE_ICON_COUNT; i++ )
    {
        wxString strIconFileName = wxString::Format(_T("pficon_%d.png"), i);
        m_cbbName->Append(_T(""), wxBitmap(::wxGetApp().strImagePath + strIconFileName, wxBITMAP_TYPE_PNG));
    }
    m_cbbName->SetPopupMaxHeight(110);
    m_cbbName->SetSelection(0);

	x = margin;
	y += margin + h;
	m_textConType = new wxStaticText(m_pagestep1, wxID_ANY, _("Network Connection Type:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_cbbConType = new wxComboBox(m_pagestep1, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin + 12, h), 0, NULL, wxCB_READONLY);
	m_cbbConType->Append(_("Wireless LAN"));
	m_cbbConType->Append(_("Wired LAN"));
	m_cbbConType->SetValue(_("Wireless LAN"));

    m_pagestep2 = new ProfileWirelessSettings(this);
    m_pagestep3 = new ProfileOtherSettings(this);
    wxWizardPageSimple::Chain(m_pagestep1, m_pagestep2);
    wxWizardPageSimple::Chain(m_pagestep2, m_pagestep3);
}

ProfileGeneralSettings::~ProfileGeneralSettings()
{
}

bool ProfileGeneralSettings::ShowWizard()
{
    return wxWizard::RunWizard(m_pagestep1);
}

wxWizardPage* ProfileGeneralSettings::GetFirstPage() const
{
    return m_pagestep1;
}

ProfileList_t ProfileGeneralSettings::GetProfile() const
{
    return m_profileInfo;
}

void ProfileGeneralSettings::OnWizardChanging(wxWizardEvent& event)
{
    wxString strProfileName = m_tcName->GetValue();
    strProfileName = strProfileName.Trim(true);
    strProfileName = strProfileName.Trim(false);
    m_tcName->SetValue(strProfileName);
    if ( this->m_tcName->GetValue() == _T("") )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    ProfileManagerDlg* pDialog = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
    if ( pDialog->IsProfileExist(strProfileName) )
    {
        wxMessageDialog msg(this, _("A profile with the name you specified already exists.\nPlease specify a different name!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    int check = ENMUtil::CheckValide(m_tcName->GetValue());
    if ( check == ENMUtil::CHECK_ILLEGAL )
    {
        wxMessageDialog msg(this, _("Profile name cannot contain any of the following characters\n \\ / : * ? \" < > |"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }
    else if ( check == ENMUtil::CHECK_EMPTY )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        m_tcName->SetFocus();
        return;
    }

    if ( event.GetPage() == m_pagestep2 )
    {
        if ( event.GetDirection() )
        {
            if ( m_pagestep2->m_bNameChange )
            {
                wxString strEssidName = m_pagestep2->m_tcWNName->GetValue();
                strEssidName = strEssidName.Trim(true);
                strEssidName = strEssidName.Trim(false);
                m_pagestep2->m_tcWNName->SetValue(strEssidName);
                if (m_pagestep2->m_tcWNName->GetValue() == _T(""))
                {
                    wxMessageDialog msg(this, _("SSID cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
                if ( !strEssidName.IsAscii() )
                {
                    wxMessageDialog msg(this, _("Invalid SSID!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
                if (ENMUtil::CheckValide(m_pagestep2->m_tcWNName->GetValue()))
                {
                    wxMessageDialog msg(this, _("SSID cannot contain any of the following characters\n \\ / : * ? \" < > |"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    m_pagestep2->m_tcWNName->SetFocus();
                    return;
                }
            }

            wxString currentText = m_pagestep2->m_cbbSt->GetValue();
            if ( currentText == _T("WEP") )
            {
                wxString strWepKey = m_pagestep2->m_tcKey->GetValue();
                if ( strWepKey.IsEmpty() )
                {
                    wxMessageDialog msg(this, _("WEP key cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
                if ( !ENMUtil::IsHexNumber(strWepKey) )
                {
                    wxMessageDialog msg(this, _("WEP key must be hexadecimal. \n(Must contain only numbers 0-9 and letters a-f)"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
            }

            if ( currentText == _T("WPA-PSK TKIP") || currentText == _T("WPA-PSK AES") || currentText == _T("WPA2-PSK TKIP") || currentText == _T("WPA2-PSK AES") )
            {
                wxString strWpaKey = m_pagestep2->m_tcKey->GetValue();
                if ( strWpaKey.IsEmpty() )
                {
                    wxMessageDialog msg(this, _("WPA key cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
                if ( !strWpaKey.IsAscii() )
                {
                    wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
                if ( strWpaKey.Length() < 8 )
                {
                    wxMessageDialog msg(this, _("WPA key must be at least 8 characters."), wxEmptyString, wxOK | wxICON_INFORMATION);
                    msg.ShowModal();
                    event.Veto();
                    return;
                }
            }
            wxString strKey = m_pagestep2->m_tcKey->GetValue();
            wxString strConfirmKey = m_pagestep2->m_tcConfirmKey->GetValue();
            if ( strKey.Cmp(strConfirmKey) != 0 )
            {
                wxMessageDialog msg(this, _("The network keys you typed do not match."), wxEmptyString, wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                event.Veto();
                return;
            }
        }
    }
    //1st
    m_profileInfo.sProfileName = strProfileName;
    if ( ENMUtil::IsAdministrator() )
    {
        m_profileInfo.sPermission = _T("admin");
    }
    else
    {
        m_profileInfo.sPermission = _T("user");
    }
    m_profileInfo.sProfileIcon = wxString::Format(_T("%d"), m_cbbName->GetSelection());
    if( !m_cbbConType->GetValue().Cmp(_("Wireless LAN")) )
    {
        m_profileInfo.stGenernalSet.ConnecType = _T("wireless");
    }
    else
    {
        m_profileInfo.stGenernalSet.ConnecType = _T("lan");
    }

    //2nd
    m_profileInfo.stWirelessSet.SSID = m_pagestep2->m_tcWNName->GetValue();
    switch( m_pagestep2->m_cbbWt->GetSelection() )
    {
        case 0:
            m_profileInfo.stWirelessSet.WirelessType = _T("Automatic");
            break;
        case 1:
            m_profileInfo.stWirelessSet.WirelessType = _T("802.11b");
            break;
        case 2:
            m_profileInfo.stWirelessSet.WirelessType = _T("802.11g");
            break;
        case 3:
            m_profileInfo.stWirelessSet.WirelessType = _T("802.11n");
            break;
        default:
            m_profileInfo.stWirelessSet.WirelessType = _T("802.11b");
            break;
    }

    switch( m_pagestep2->m_cbbSt->GetSelection() )
    {
        case 0:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("open-none");
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	case 1:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("open-wep");
		m_profileInfo.stWirelessSet.stWEPSecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = m_pagestep2->m_cbbIndex->GetValue();
		break;
	case 2:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("wpa-psk-tkip");
		m_profileInfo.stWirelessSet.stWPASecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	case 3:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("wpa-psk-aes");
		m_profileInfo.stWirelessSet.stWPASecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	case 4:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("wpa2-psk-tkip");
		m_profileInfo.stWirelessSet.stWPASecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	case 5:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("wpa2-psk-aes");
		m_profileInfo.stWirelessSet.stWPASecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	case 6:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("unknown");
		m_profileInfo.stWirelessSet.stWPASecurity.value = m_pagestep2->m_tcKey->GetValue();
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
		break;
	default:
		m_profileInfo.stWirelessSet.WlanSecurity = _T("unknown");
		m_profileInfo.stWirelessSet.stWPASecurity.value = _T("");
		m_profileInfo.stWirelessSet.stWEPSecurity.keyIndex = _T("0");
		break;
    }

    //3th
    if ( event.GetPage() == m_pagestep3 && !m_pagestep3->ValidateHomepage() )
    {
        wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        event.Veto();
        return;
    }
    m_profileInfo.stOtherSet = m_pagestep3->GetProfileOtherSetting();
    if ( m_profileInfo.stOtherSet.Homepage.IsEmpty() )
    {
        m_profileInfo.stOtherSet.Homepage = _T("about:blank");
    }

    m_pagestep2->m_bNameChange = true;
}

void ProfileGeneralSettings::OnWizardFinished(wxWizardEvent& event)
{

}

void ProfileGeneralSettings::OnWizardCancel(wxWizardEvent& event)
{
    wxMessageDialog dialog(this, _("Are you sure you want to cancel the operation?"), wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dialog.ShowModal() != wxID_YES )
    {
        event.Veto();
    }
}

void ProfileGeneralSettings::OnProfileTypeSelected(wxCommandEvent& event)
{
    wxString currentText = m_cbbConType->GetValue();
    currentText = currentText.Trim(true);
    currentText = currentText.Trim(false);
    if (currentText.Cmp(_("Wireless LAN")) == 0)
    {
        wxWizardPageSimple::Chain(m_pagestep1, m_pagestep2);
        wxWizardPageSimple::Chain(m_pagestep2, m_pagestep3);
        m_pagestep3->SetProfileType(ADAPTER_WIREDLESS);
    }
    else
    {
        wxWizardPageSimple::Chain(m_pagestep1, m_pagestep3);
        m_pagestep3->SetProfileType(ADAPTER_WIRED);
    }
}
