/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_EDITOR_H_
#define _PROFILE_EDITOR_H_

#include <wx/object.h>
#include <wx/xml/xml.h>
#include "Profile.h"

class ProfileEditor : public wxObject
{
public:
	ProfileEditor();
	virtual ~ProfileEditor();

    bool ReadProfile(ProfileList_t& profile, const wxString& fileName);
    bool WriteProfile(ProfileList_t& profile, const wxString& fileName, int priority = -1);
    bool DeleteProfile(const wxString& fileName);

private:
    bool GetProfileGeneralSettings(GenernalSettings_t& st, const wxXmlNode* pNode);
    bool GetProfileWirelessSettings(WirelessSettings_t& st, const wxXmlNode* pNode);
	bool GetProfileOtherSettings(OtherSettings_t& st, const wxXmlNode* pNode);

	wxXmlNode* CreateNode(const GenernalSettings_t& st);
	wxXmlNode* CreateNode(const WirelessSettings_t& st);
	wxXmlNode* CreateNode(const OtherSettings_t& st);

	bool GetProfileNetworkSecurity(NetworkSecuritySet_t& st, const wxXmlNode* pNode);
	bool GetProfileIPDnsSettings(IPDNSSet_t& st, const wxXmlNode* pNode);
	bool GetProfileProxySettings(ProxySet_t& st, const wxXmlNode* pNode);
	bool GetProfileAutoRunApp(vector<wxString>& arr, const wxXmlNode* pNode);

    wxString EncryptString(const wxString& str);
    wxString DecryptString(const wxString& str, bool compatible = false);
    void EncryptProfile(ProfileList_t& profile);
    void DecryptProfile(ProfileList_t& profile, bool compatible = false);
	unsigned short EncodeWChar(const unsigned short number, const unsigned short mask);
	unsigned char EncodeChar(const unsigned char c);
	unsigned short DecodeWChar(const wxString& str, size_t index);
	unsigned char DecodeChar(const wxString& str, size_t index);
};

#endif // _PROFILE_EDITOR_H_
