/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _NETWORK_MANAGER_DIALOG_H_
#define _NETWORK_MANAGER_DIALOG_H_

#include <wx/wx.h>
#include <wx/bmpcbox.h>

#include "Profile.h"
#include "ViewAPNeighborsDlg.h"
#include "WlanScanner.h"
#include "DataCenter.h"
#include "wlanacmevent.h"
#include "ProfileEvent.h"
#include "SwitchAdapterEvent.h"
#include "SchoolSettingImporter.h"
#include "WirelessEvent.h"
#include <vector>
#include "MeshNotifyBalloon.h"
using namespace std;
class NetworkManagerDlg: public wxFrame
{
    public:
        void UI_UpdateNetworkMode(NETWORK_MODE networkMode);
        void UI_UpdateNetworkStatusInfo(const NETWORK_MODE& networkMode, const UI_NETWORK_STATUS_INFO& statusInfo);
        NetworkManagerDlg(wxWindow* parent,wxWindowID id = -1);
        virtual ~NetworkManagerDlg();
        virtual bool Destroy();
        virtual bool Show(bool show = true);
        bool IsApplyingProfile() const;
        void ShowApplyingProcessDialog(const wxString& profileName = wxEmptyString, bool show = true);
        wxMenuItem* m_menuMeshDC;
        bool IsProfileAcceptable(const ProfileList_t& profile);
        void SetNetworkProfile_NN();
    protected:
        wxString wxOldIP;
        void SetNetworkProfile();

        void SetComboxCurrentProfileName();
        void OnActivate(wxActivateEvent& event);

    private:
        void SetWirelessSwitch();
        void ImportSchoolSetting(wxCommandEvent& event);
        void ConnectProfile(wxCommandEvent& event);
        void Exit(wxCommandEvent& event);
        void MenuScanNw(wxCommandEvent& event);
        void MenuViewNghbr(wxCommandEvent& event);
        void MenuProfileMgr(wxCommandEvent& event);
        void MenuCtrlWrls(wxCommandEvent& event);
        void MenuHelpContent(wxCommandEvent& event);
        void MenuAbout(wxCommandEvent& event);
        void MenuMeshConf(wxCommandEvent& event);

        void OnButtonCtrlCnctClick(wxCommandEvent& event);
        void OnButtonScanNwClick(wxCommandEvent& event);
        void OnButtonViewNghbrClick(wxCommandEvent& event);
        void OnButtonPrflMgrClick(wxCommandEvent& event);
        void OnButtonCtrlWrlsClick(wxCommandEvent& event);
        void Onm_cmbSwitchPrflSelect(wxCommandEvent& event);
        void OnConnectProfile();

        void OnWlanAcmEvent(WlanAcmEvent& event);
        void OnProfileChangedEvent(ProfileEvent& event);
        void OnSwitchAdapterEvent(SwitchAdapterEvent& event);
        void OnWirelessNetworkChanged(const WirelessSwitchEvent& event);
        void OnTimer(wxTimerEvent& event);

        void RefreshProfileName();
        void EnableSQInfo(bool enable);
        void EnableScanNTandViewNb(bool enable);
        void CloseNotification(wxTimerEvent & event);

        static const long ID_CMBSWITCHPRFL;
        static const long ID_BTNSCANNW;
        static const long ID_BTNVIEWNGHBR;
        static const long ID_BTNPRFLMGR;
        static const long ID_BTNCTRLCONNECT;
        static const long ID_BTNCTRLWRLS;
        static const long ID_IMPORT;
        static const long ID_EXIT;
        static const long ID_CNCTPRFL;
        static const long ID_SCANNW;
        static const long ID_VIEWNGHBR;
        static const long ID_PRFLMGR;
        static const long ID_MDC;
        static const long ID_CTRLWRLS;
        static const long ID_HLPCONT;
        static const long ID_ABOUT;
        static const long ID_MESHCONFIGURATION;
        static const int ID_TIMER_PROFILE;
        static const int ID_TIMER_WIRELESS;
        static const int ID_TIMER_MESH;


        wxMenuBar* m_mbFile;
        wxStaticBox* m_stbNwInfo;
        wxBitmapComboBox* m_cmbSwitchPrfl;
        wxStaticBitmap* m_stcPrflBmp;
        wxStaticBitmap *m_NwInfoBmp;

        GaugeDialog* m_pGaugeDialog;
        wxGauge* m_gueSQ;
        wxBitmap *m_bmpPrfl;
        wxPanel* m_pnlRight;
        wxPanel* m_pnlLeft;

        wxStaticText* m_stcNpTitle;
        wxStaticText* m_stcCurrentPfle;
        wxStaticText* m_stcSQTitle;
        wxStaticText* m_stcSQVal;
        wxStaticText* m_stcStatusTitle;
        wxStaticText* m_stcStatus;
        wxStaticText* m_stcTypeTitle;
        wxStaticText* m_stcType;
        wxStaticText* m_stcIPAddrTitle;
        wxStaticText* m_stcIPAddr;

        wxMenuItem* m_menuCtrlWrls;
        wxMenuItem* m_menuCnctPrfl;
        wxMenuItem* m_menuImpSetting;
        wxMenuItem* m_menuScanNW;
        wxMenuItem* m_menuPrflMgr;
        wxMenuItem* m_menuAboutContent;
        wxMenuItem* m_menuViewNghbr;
        wxMenuItem* m_menuHelpContent;
        wxMenuItem* m_menuExitDlg;
//        wxMenuItem* m_menuMeshDC;

        wxButton* m_btnCtrlConnect;
        wxButton* m_btnCtrlWireless;

        vector<ProfileList_t> m_profileVector;
        wxTimer m_timerProfile;
        wxTimer m_timerWireless;


        #if defined(__UNIX__)
        wxStaticBitmap* m_bmpScanNetwork;
        wxStaticBitmap* m_bmpViewNeighbor;
        wxStaticBitmap* m_bmpProfileManager;

        wxButton* m_btnScanNetwork;
        wxButton* m_btnViewNeighbor;
        wxButton* m_btnProfileManager;

        wxStaticText* ScanNtBtnText;
        wxStaticText* NeightorText;
        wxStaticText* PrflMgrText;
        #endif

        ViewAPNeighborsDlg* viewAPNeighborsDlg;
//        SchoolSettingImporter m_importer;

        MeshNotifyBalloon* m_notificationDlg;
        wxTimer* m_notificationtimer;

        bool m_isApplyingProfile;
        bool bConnectFinish;
        int m_iSelectedToApply;

        DECLARE_EVENT_TABLE()
};

#endif // _NETWORK_MANAGER_DIALOG_H_
