/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "EditProfileDialog.h"
#include <wx/string.h>
#include <wx/file.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "ENMUtil.h"
#include "PolicyManager.h"
#include "ProfileManagementControl.h"
#include "ProfileManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "NetSecrityDlg.h"
#include "AutoRunSettings.h"
#include "IPSettings.h"
#include "ProxySettings.h"

const long EditProfileDialog::ID_OKBUTTON = wxNewId();
const long EditProfileDialog::ID_CANCLEBUTTON = wxNewId();
const long EditProfileDialog::ID_NAMETEXTCTRL = wxNewId();
const long EditProfileDialog::ID_NAMECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_CONTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_GENERALPANEL = wxNewId();
const long EditProfileDialog::ID_SSIDTEXTCTRL = wxNewId();
const long EditProfileDialog::ID_SCANBUTTON = wxNewId();
const long EditProfileDialog::ID_WIRELESSTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_SECRITYTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_WIRELESSPANEL = wxNewId();
const long EditProfileDialog::ID_NETWORKSECRITYCHECKBOX = wxNewId();
const long EditProfileDialog::ID_APPCHECKBOX = wxNewId();
const long EditProfileDialog::ID_DEFAULTCHECKBOX = wxNewId();
const long EditProfileDialog::ID_NSBUTTON = wxNewId();
const long EditProfileDialog::ID_APPBUTTON = wxNewId();
const long EditProfileDialog::ID_DEFAULTBUTTON = wxNewId();
const long EditProfileDialog::ID_PROXYBUTTON = wxNewId();
const long EditProfileDialog::ID_HOMEPAGECHECKBOX = wxNewId();
const long EditProfileDialog::ID_PROXYCHECKBOX = wxNewId();
const long EditProfileDialog::ID_HOMEPAGETEXTCTRL = wxNewId();
const long EditProfileDialog::ID_OTHERSPANEL = wxNewId();
const long EditProfileDialog::ID_EDITNOTEBOOK = wxNewId();
const long EditProfileDialog::ID_EDITPANEL = wxNewId();
const long EditProfileDialog::ID_KEYTEXTCTRL = wxNewId();
const long EditProfileDialog::ID_CONFIRM_KEYTEXTCTRL = wxNewId();

BEGIN_EVENT_TABLE(EditProfileDialog, wxDialog)
	EVT_BUTTON(ID_OKBUTTON, EditProfileDialog::Onm_buttonOKClick)
	EVT_BUTTON(ID_CANCLEBUTTON, EditProfileDialog::Onm_buttonCancelClick)
	EVT_COMBOBOX(ID_SECRITYTYPECOMBOBOX, EditProfileDialog::Onm_cbbSecTypeSelect)
	EVT_CHECKBOX(ID_NETWORKSECRITYCHECKBOX, EditProfileDialog::Onm_cbNetworkSecrityClick)
	EVT_CHECKBOX(ID_APPCHECKBOX, EditProfileDialog::Onm_cbAppClick)
	EVT_CHECKBOX(ID_DEFAULTCHECKBOX, EditProfileDialog::Onm_cbDefaultClick)
	EVT_CHECKBOX(ID_HOMEPAGECHECKBOX, EditProfileDialog::Onm_cbHomePageClick)
	EVT_CHECKBOX(ID_PROXYCHECKBOX, EditProfileDialog::Onm_cbProxyClick)
	EVT_BUTTON(ID_NSBUTTON, EditProfileDialog::Onm_buttonNsClick)
	EVT_BUTTON(ID_APPBUTTON, EditProfileDialog::Onm_buttonAppClick)
	EVT_BUTTON(ID_DEFAULTBUTTON, EditProfileDialog::Onm_buttonDefaultClick)
	EVT_BUTTON(ID_PROXYBUTTON, EditProfileDialog::Onm_buttonProxyClick)
    EVT_BUTTON(ID_SCANBUTTON, EditProfileDialog::Onm_buttonSnClick)
	EVT_INIT_DIALOG(EditProfileDialog::OnInit)
	EVT_CLOSE(EditProfileDialog::BeforeClose)
END_EVENT_TABLE()

EditProfileDialog::EditProfileDialog(wxWindow* parent, const ProfileList_t& profile, bool create)
{
	m_profile = profile;
	m_strOldName = m_profile.sProfileName;
	m_isForCreate = create;
	m_isExit = false;
	Create(parent, wxID_ANY, _("Edit Network Profile"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
    int width = 530, height = 290;
    int margin = 10;
    int h = 26;
    wxSize btnSize(90, 30);
    wxSize labelSize(210, 20);
	SetClientSize(wxSize(width + margin * 2, height + btnSize.GetHeight() + margin * 3));

	m_nbEdit = new wxNotebook(this, ID_EDITNOTEBOOK, wxPoint(margin, margin), wxSize(width, height));

	int x = this->GetSize().GetWidth() - (btnSize.GetWidth() + margin) * 2;
	int y = this->GetSize().GetHeight() - btnSize.GetHeight() - margin;
	m_buttonCancel = new wxButton(this, ID_CANCLEBUTTON, _("&Cancel"), wxPoint(x, y), btnSize);
	x += btnSize.GetWidth() + margin;
	m_buttonOK = new wxButton(this, ID_OKBUTTON, _("&OK"), wxPoint(x, y), btnSize);

	m_generalPanel = new wxPanel(m_nbEdit, ID_GENERALPANEL);
	x = margin;
	y = margin;
   	m_labelName = new wxStaticText(m_generalPanel, wxID_ANY, _("Profile Name:"), wxPoint(x, y + 3), labelSize);
   	x += labelSize.GetWidth() + margin;
	m_textName = new wxTextCtrl(m_generalPanel, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(220, h));
	m_textName->SetMaxLength(32);
	m_cbName = new wxBitmapComboBox(m_generalPanel, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(width - 50 - margin, y), wxSize(50, h), 0, 0, wxCB_READONLY);
    m_cbName->SetPopupMaxHeight(110);
    static const size_t PROFILE_ICON_COUNT = 8;
    for ( size_t i = 0; i < PROFILE_ICON_COUNT; i++ )
    {
        wxString strIconFileName = wxString::Format(_T("pficon_%d.png"), i);
        m_cbName->Append(_T(""), wxBitmap(::wxGetApp().strImagePath + strIconFileName, wxBITMAP_TYPE_PNG));
    }

	x = margin;
	y += margin + h;
	m_labelConType = new wxStaticText(m_generalPanel, wxID_ANY, _("Network Connection Type:"), wxPoint(x, y + 3), labelSize);
    x += labelSize.GetWidth() + margin;
	m_cbConType = new wxComboBox(m_generalPanel, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin, h), 0, 0, wxCB_READONLY);
	m_cbConType->Append(_("Wireless LAN"));
	m_cbConType->Append(_("Wired LAN"));

	m_wirelessPanel = new wxPanel(m_nbEdit, ID_WIRELESSPANEL);
    int vm = 6;
    x = margin, y = margin;
	m_labelWirelessName = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Wireless Network Name (SSID):"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_textSSID = new wxTextCtrl(m_wirelessPanel, ID_SSIDTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin, h));
	m_textSSID->SetMaxLength(32);

    y += vm + h;
	m_buttonScan = new wxButton(m_wirelessPanel, ID_SCANBUTTON, _("Scan for Networks"), wxPoint(290, y), wxSize(210, 28));

    x = margin;
    y += vm + 28;
	m_textWirelessType = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Wireless Type:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_cbbWirelessType = new wxComboBox(m_wirelessPanel, ID_WIRELESSTYPECOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(140, h), 0, 0, wxCB_READONLY);
	m_cbbWirelessType->Append(_("Automatic"));
	m_cbbWirelessType->Append(_T("802.11b"));
	m_cbbWirelessType->Append(_T("802.11g"));
	m_cbbWirelessType->Append(_T("802.11n"));

    x = margin;
    y += vm + h;
	m_textSecType = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Security Type:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_cbbSecType = new wxComboBox(m_wirelessPanel, ID_SECRITYTYPECOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(140, h), 0, 0, wxCB_READONLY);
	m_cbbSecType->Append(_("NONE"));
	m_cbbSecType->Append(_T("WEP"));
	m_cbbSecType->Append(_T("WPA-PSK TKIP"));
	m_cbbSecType->Append(_T("WPA-PSK AES"));
	m_cbbSecType->Append(_T("WPA2-PSK TKIP"));
	m_cbbSecType->Append(_T("WPA2-PSK AES"));
	m_cbbSecType->Append(_("UNKNOWN"));

    x = margin;
    y += vm + h;
    m_textKey = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Key:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
    m_tcKey = new wxTextCtrl(m_wirelessPanel, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin, h), wxTE_PASSWORD);
    m_tcKey->Enable(false);

    x = margin;
    y += vm + h;
    m_textConfirmKey = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Confirm Key:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
    m_tcConfirmKey = new wxTextCtrl(m_wirelessPanel, ID_CONFIRM_KEYTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin, h), wxTE_PASSWORD);
    m_tcConfirmKey->Enable(false);
    m_tcKey->SetMaxLength(63);
    m_tcConfirmKey->SetMaxLength(63);

    x = margin;
    y += vm + h;
    m_textKeyIdx = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Key Index:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_cbbIndex = new wxComboBox(m_wirelessPanel, wxID_ANY, wxEmptyString, wxPoint(x, y), wxSize(60, h), 0, 0, wxCB_READONLY);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_cbbIndex->Enable(false);

    y += vm + h;
    m_textTip = new wxStaticText(m_wirelessPanel, wxID_ANY, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin, 30));

	m_othersPanel = new wxPanel(m_nbEdit, ID_OTHERSPANEL);
	labelSize.SetWidth(270);
    btnSize.SetWidth(140);
    btnSize.SetHeight(28);
    int e = (btnSize.GetHeight() - labelSize.GetHeight()) / 2;
	x = margin;
	y = margin;
	m_cbNetworkSecrity = new wxCheckBox(m_othersPanel, ID_NETWORKSECRITYCHECKBOX, _("Network Security"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_cbNetworkSecrity->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonNs = new wxButton(m_othersPanel, ID_NSBUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonNs->Enable(false);

    x = margin;
    y += btnSize.GetHeight() + margin;
	m_cbApp = new wxCheckBox(m_othersPanel, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_cbApp->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonApp = new wxButton(m_othersPanel, ID_APPBUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonApp->Enable(false);

    x = margin;
    y += btnSize.GetHeight() + margin;
	m_cbDefault = new wxCheckBox(m_othersPanel, ID_DEFAULTCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_cbDefault->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonDefault = new wxButton(m_othersPanel, ID_DEFAULTBUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonDefault->Enable(false);

    x = 5;
    y += btnSize.GetHeight() + margin;

	m_stcBox = new wxStaticBox(m_othersPanel, wxID_ANY, _("Customize Firefox Browser"), wxPoint(x, y), wxSize(width - 15, 102));

    x = margin;
    y += margin * 2 + 5;
	m_cbHomepage = new wxCheckBox(m_othersPanel, ID_HOMEPAGECHECKBOX, _("Overwrite homepage"), wxPoint(x, y + 3), labelSize, wxALIGN_CENTER_VERTICAL);
	m_cbHomepage->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_textHomepage = new wxTextCtrl(m_othersPanel, ID_HOMEPAGETEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - margin * 2, 26));
	m_textHomepage->SetEditable(false);
    m_textHomepage->Enable(false);

    x = margin;
    y += 26 + margin;
	m_cbProxy = new wxCheckBox(m_othersPanel, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(x, y + e), labelSize, wxALIGN_CENTER_VERTICAL);
	m_cbProxy->SetValue(false);
	x += labelSize.GetWidth() + margin;
	m_buttonProxy = new wxButton(m_othersPanel, ID_PROXYBUTTON, _("Settings"), wxPoint(x, y), btnSize);
	m_buttonProxy->Enable(false);

	m_nbEdit->AddPage(m_generalPanel, _("General Settings"), false);
	m_nbEdit->AddPage(m_wirelessPanel, _("Wireless Settings"), false);
	m_nbEdit->AddPage(m_othersPanel, _("Other"), false);

	m_textName->SetValue(m_profile.sProfileName);
    m_textName->SetFocus();
	long nSelection = 0;
	m_profile.sProfileIcon.ToLong(&nSelection);
	m_cbName->SetSelection(nSelection);
	if ( m_profile.stGenernalSet.ConnecType == _T("wireless") )
	{
	    m_cbConType->SetValue(_("Wireless LAN"));
    }
    else
    {
        m_cbConType->SetValue(_("Wired LAN"));
        m_nbEdit->RemovePage(1);
        m_cbNetworkSecrity->Enable(false);
        m_buttonNs->Enable(false);
    }
    m_cbConType->Enable(false);

    m_textSSID->SetValue(m_profile.stWirelessSet.SSID);

    if ( !m_profile.stWirelessSet.WirelessType.IsEmpty() )
    {
        if ( m_profile.stWirelessSet.WirelessType == _T("802.11b") )
        {
            m_cbbWirelessType->SetSelection(1);
        }
        else if ( m_profile.stWirelessSet.WirelessType == _T("802.11g") )
        {
            m_cbbWirelessType->SetSelection(2);
        }
        else if ( m_profile.stWirelessSet.WirelessType == _T("802.11n") )
        {
            m_cbbWirelessType->SetSelection(3);
        }
        else
        {
            m_cbbWirelessType->SetSelection(0);
        }
    }

    if (!m_profile.stWirelessSet.WlanSecurity.empty())
    {
        UpdateSecurityUI(m_profile.stWirelessSet);
    }

    if ( m_profile.stOtherSet.NetworkSecurity == _T("1") )
    {
        m_cbNetworkSecrity->SetValue(true);
        m_buttonNs->Enable(true);
        m_securitySet = m_profile.stOtherSet.stNetSecurity;
//        m_strForbidShareFileAndPrint = m_profile.stOtherSet.stNetSecurity.sForbidShareFileAndPrint;
//        m_strForbidShareInternet = m_profile.stOtherSet.stNetSecurity.sForbidShareInternet;
//        m_strStartWindowFirewall = m_profile.stOtherSet.stNetSecurity.sStartWindowFirewall;
    }

    if ( m_profile.stOtherSet.AutoRunAppFlag == _T("1") )
    {
        m_cbApp->SetValue(true);
        m_buttonApp->Enable(true);
        m_vAutoRunApp = m_profile.stOtherSet.AutoRunApp;
    }

    if ( m_profile.stOtherSet.IPDNSFlag == _T("1") )
    {
        m_cbDefault->SetValue(true);
        m_buttonDefault->Enable(true);
        m_ipSet = m_profile.stOtherSet.stIPDNSSet;
//        m_strIP = m_profile.stOtherSet.stIPDNSSet.IPvalue;
//        m_strSubMask = m_profile.stOtherSet.stIPDNSSet.SubnetAddress;
//        m_strGateWayAddr = m_profile.stOtherSet.stIPDNSSet.NetGateway;
//        m_strDNS = m_profile.stOtherSet.stIPDNSSet.DNSvalue;
    }

    if ( m_profile.stOtherSet.IsHomepage == _T("1") )
    {
        m_cbHomepage->SetValue(true);
//        m_buttonBrowser->Enable(true);
        m_textHomepage->Enable(true);
        m_textHomepage->SetEditable(true);
        m_textHomepage->SetValue(m_profile.stOtherSet.Homepage);
    }

    if ( m_profile.stOtherSet.ProxyFlag == _T("1") )
    {
        m_cbProxy->SetValue(true);
        m_buttonProxy->Enable(true);
        m_strProxy = m_profile.stOtherSet.stProxySet.Proxy;
        m_strPort = m_profile.stOtherSet.stProxySet.Port;
    }

    if ( create )
    {
        m_textName->Enable(false);
        m_textSSID->Enable(false);
        m_cbbSecType->Enable(false);
        m_cbbWirelessType->Enable(false);
        m_tcKey->Enable(false);
        m_tcConfirmKey->Enable(false);
        m_cbbIndex->Enable(false);
        m_buttonScan->Enable(false);
    }

    Centre();
}

EditProfileDialog::~EditProfileDialog()
{
}

ProfileList_t EditProfileDialog::GetProfile() const
{
    return m_profile;
}

void EditProfileDialog::OnInit(wxInitDialogEvent& event)
{
    if ( !m_isForCreate )
    {
        NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
        m_buttonScan->Enable( networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT );
        if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
        {
            if(::wxGetApp().m_bMeshServer_Ra0)
            {
                m_buttonScan->Enable(true);
            }
        }


        ProfileList_t cp = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
        bool isCurrent = m_profile.sProfileName.Cmp(cp.sProfileName) == 0 && m_profile.sPermission.Cmp(cp.sPermission) == 0 ;
        m_textName->Enable(!isCurrent);
        if ( isCurrent )
        {
            m_cbName->SetFocus();
        }
    }
}

void EditProfileDialog::Onm_buttonOKClick(wxCommandEvent& event)
{
    wxString strNewName = m_textName->GetValue();
    strNewName = strNewName.Trim(false).Trim(true);
    if ( strNewName.Length() == 0 )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_textName->SetFocus();
        return;
    }
    if ( ENMUtil::CheckValide(strNewName) == ENMUtil::CHECK_ILLEGAL )
    {
        wxMessageDialog msg(this, _("Profile name cannot contain any of the following characters\n \\ / : * ? \" < > |"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_textName->SetFocus();
        return;
    }

    if ( !m_isForCreate )
    {
        string strEnterProfile = ENMUtil::WxStringToString(strNewName);
        ENMUtil::StringToLowerCase(strEnterProfile);
        ProfileManagerDlg* pDialog = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
        if ( pDialog->IsProfileExist(strNewName, m_strOldName) )
        {
            wxMessageDialog msg(this, _("A profile with the name you specified already exists.\nPlease specify a different name!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textName->SetFocus();
            return;
        }
    }

    if ( m_cbConType->GetValue().Cmp(_("Wireless LAN")) == 0 )
    {
        if ( ENMUtil::CheckValide(m_textSSID->GetValue()) == ENMUtil::CHECK_EMPTY )
        {
            wxMessageDialog msg(this, _("SSID cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        if ( !m_textSSID->GetValue().IsAscii() )
        {
            wxMessageDialog msg(this, _("Invalid SSID!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        if ( ENMUtil::CheckValide(m_textSSID->GetValue()) == ENMUtil::CHECK_ILLEGAL )
        {
            wxMessageDialog msg(this, _("SSID cannot contain any of the following characters\n \\ / : * % ? \" < > |"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        wxString currentText = m_cbbSecType->GetValue();
        wxString strKey = m_tcKey->GetValue();
        wxString strConfirmKey = m_tcConfirmKey->GetValue();
        if ( currentText.Cmp(_T("WEP")) == 0 )
        {
            if ( strKey.IsEmpty() )
            {
                wxMessageDialog msg(this, _("WEP key cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
            if ( !ENMUtil::IsHexNumber(strKey) )
            {
                wxMessageDialog msg(this, _("WEP key must be hexadecimal. \n(Must contain only numbers 0-9 and letters a-f)"), wxEmptyString, wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
        }
        if ( currentText == _T("WPA-PSK TKIP") || currentText == _T("WPA-PSK AES")
				|| currentText == _T("WPA2-PSK TKIP") || currentText == _T("WPA2-PSK AES") )
        {
            if ( strKey.IsEmpty() )
            {
                wxMessageDialog msg(this, _("WPA key cannot be empty!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
            if ( !strKey.IsAscii() )
            {
                wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
			if ( strKey.Length() < 8 )
			{
				wxMessageDialog msg(this, _("WPA key must be at least 8 characters."), wxEmptyString, wxOK | wxICON_INFORMATION);
				msg.ShowModal();
				return;
			}
        }
        if ( strKey.Cmp(strConfirmKey) != 0 )
        {
            wxMessageDialog msg(this, _("The network keys you typed do not match."), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            return;
        }
    }

    wxString strHomepage = m_textHomepage->GetValue();
    strHomepage = strHomepage.Trim(true);
    strHomepage = strHomepage.Trim(false);
    if ( m_cbHomepage->IsChecked() && strHomepage.Length() > 0 && !strHomepage.IsAscii() )
    {
        wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_textHomepage->SetFocus();
//        m_textHomepage->SetSelection(-1, -1);
        return;
    }

    wxString strProfileName = m_textName->GetValue();
    strProfileName = strProfileName.Trim(true).Trim(false);
    m_textName->SetValue(strProfileName);
    m_profile.sProfileName = strProfileName;
    m_profile.sProfileIcon = wxString::Format(_T("%d"), m_cbName->GetSelection());
    if( !(m_cbConType->GetValue().Cmp(_("Wireless LAN"))) )
    {
        m_profile.stGenernalSet.ConnecType = _T("wireless");
    }
    else
    {
        m_profile.stGenernalSet.ConnecType = _T("lan");
    }

    //2nd
    wxString strEssidName = m_textSSID->GetValue();
    strEssidName = strEssidName.Trim(true);
    strEssidName = strEssidName.Trim(false);
    m_profile.stWirelessSet.SSID = strEssidName;
    if ( !m_cbbWirelessType->GetValue().Cmp(_("Automatic")) )
    {
        m_profile.stWirelessSet.WirelessType  = _T("Automatic");
    }
    else if (!m_cbbWirelessType->GetValue().Cmp(_T("802.11b")))
    {
        m_profile.stWirelessSet.WirelessType  = _T("802.11b");
    }
    else if (!m_cbbWirelessType->GetValue().Cmp(_T("802.11g")))
    {
        m_profile.stWirelessSet.WirelessType  = _T("802.11g");
    }
    else
    {
        m_profile.stWirelessSet.WirelessType  = _T("802.11n");
    }
    switch( m_cbbSecType->GetSelection() )
    {
    case 0:
        m_profile.stWirelessSet.WlanSecurity = _T("open-none");
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
        break;
    case 1:
        m_profile.stWirelessSet.WlanSecurity = _T("open-wep");
        m_profile.stWirelessSet.stWEPSecurity.value = m_tcKey->GetValue();
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = m_cbbIndex->GetValue();
        break;
    case 2:
        m_profile.stWirelessSet.WlanSecurity = _T("wpa-psk-tkip");
        m_profile.stWirelessSet.stWPASecurity.value = m_tcKey->GetValue();
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
        break;
    case 3:
        m_profile.stWirelessSet.WlanSecurity = _T("wpa-psk-aes");
        m_profile.stWirelessSet.stWPASecurity.value = m_tcKey->GetValue();
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
        break;
    case 4:
        m_profile.stWirelessSet.WlanSecurity = _T("wpa2-psk-tkip");
        m_profile.stWirelessSet.stWPASecurity.value = m_tcKey->GetValue();
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
        break;
    case 5:
        m_profile.stWirelessSet.WlanSecurity = _T("wpa2-psk-aes");
        m_profile.stWirelessSet.stWPASecurity.value = m_tcKey->GetValue();
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = _T("1");
        break;
    case 6:
        m_profile.stWirelessSet.WlanSecurity = _T("unknown");
        break;
    }

    //3th
    if( m_cbNetworkSecrity->IsChecked() )
    {
        m_profile.stOtherSet.NetworkSecurity = _T("1");
    }
    else
    {
        m_profile.stOtherSet.NetworkSecurity = _T("0");
    }

    if( m_cbApp->IsChecked() )
    {
        m_profile.stOtherSet.AutoRunAppFlag = _T("1");
    }
    else
    {
        m_profile.stOtherSet.AutoRunAppFlag = _T("0");
    }

    if( m_cbDefault->IsChecked() && ENMUtil::ValidateIPSettings(m_ipSet) )
    {
        m_profile.stOtherSet.IPDNSFlag = _T("1");
    }
    else
    {
        m_profile.stOtherSet.IPDNSFlag = _T("0");
    }

    if( m_cbHomepage->IsChecked() )
    {
        m_profile.stOtherSet.IsHomepage = _T("1");
        m_profile.stOtherSet.Homepage = strHomepage.Length() == 0 ? _T("about:blank") : strHomepage;
    }
    else
    {
        m_profile.stOtherSet.IsHomepage = _T("0");
    }

    if( m_cbProxy->IsChecked() )
    {
        m_profile.stOtherSet.ProxyFlag = _T("1");
    }
    else
    {
        m_profile.stOtherSet.ProxyFlag = _T("0");
    }

//    m_profile.stOtherSet.stNetSecurity.sForbidShareFileAndPrint = m_strForbidShareFileAndPrint;
//    m_profile.stOtherSet.stNetSecurity.sForbidShareInternet = m_strForbidShareInternet;
//    m_profile.stOtherSet.stNetSecurity.sStartWindowFirewall = m_strStartWindowFirewall;
    m_profile.stOtherSet.stNetSecurity = m_securitySet;

//    m_profile.stOtherSet.stIPDNSSet.IPvalue = m_strIP;
//    m_profile.stOtherSet.stIPDNSSet.SubnetAddress = m_strSubMask;
//    m_profile.stOtherSet.stIPDNSSet.NetGateway = m_strGateWayAddr;
//    m_profile.stOtherSet.stIPDNSSet.DNSvalue = m_strDNS;
    m_profile.stOtherSet.stIPDNSSet = m_ipSet;

    m_profile.stOtherSet.stProxySet.Proxy = m_strProxy;
    m_profile.stOtherSet.stProxySet.Port = m_strPort;
    m_profile.stOtherSet.AutoRunApp = m_vAutoRunApp;

    EndModal(wxID_OK);
}


void EditProfileDialog::Onm_buttonCancelClick(wxCommandEvent& event)
{
    wxMessageDialog dialog(this, _("Are you sure you want to cancel the operation?"), wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dialog.ShowModal() == wxID_YES )
    {
        m_isExit = true;
        Close();
    }
}

void EditProfileDialog::Onm_cbbSecTypeSelect(wxCommandEvent& event)
{
    wxString currentText = m_cbbSecType->GetValue();
    UpdateSecurityUI(currentText);
}

void EditProfileDialog::Onm_cbNetworkSecrityClick(wxCommandEvent& event)
{
    if (m_cbNetworkSecrity->IsChecked())
    {
        m_buttonNs->Enable(true);
    }

    else
    {
        m_buttonNs->Enable(false);
    }
}

void EditProfileDialog::Onm_cbAppClick(wxCommandEvent& event)
{
    if (m_cbApp->IsChecked())
    {
        m_buttonApp->Enable(true);
    }

    else
    {
        m_buttonApp->Enable(false);
    }
}

void EditProfileDialog::Onm_cbDefaultClick(wxCommandEvent& event)
{
    if (m_cbDefault->IsChecked())
    {
        m_buttonDefault->Enable(true);
    }

    else
    {
        m_buttonDefault->Enable(false);
    }
}

void EditProfileDialog::Onm_cbProxyClick(wxCommandEvent& event)
{
    if (m_cbProxy->IsChecked())
    {
        m_buttonProxy->Enable(true);
    }

    else
    {
        m_buttonProxy->Enable(false);
    }
}

void EditProfileDialog::Onm_buttonNsClick(wxCommandEvent& event)
{
    NetSecrityDlg netSecrityDlg(this);
    netSecrityDlg.SetNetworkSecuritySetting(m_securitySet);
    if ( netSecrityDlg.ShowModal() == wxID_OK )
    {
        m_securitySet = netSecrityDlg.GetNetworkSecuritySetting();
    }
}

void EditProfileDialog::Onm_buttonAppClick(wxCommandEvent& event)
{
    wxArrayString as;
    for ( vector<wxString>::size_type i = 0; i < m_vAutoRunApp.size(); i++ )
    {
        as.Add(m_vAutoRunApp[i]);
    }
    AutoRunSettings autoRunDlg(this);
    autoRunDlg.SetApplications(as);
    if(autoRunDlg.ShowModal() == wxID_OK)
    {
        as.Empty();
        as = autoRunDlg.GetApplications();
        m_vAutoRunApp.clear();
        for( size_t i = 0; i < as.GetCount(); i++ )
        {
            wxString strAppName = as.Item(i);
            m_vAutoRunApp.push_back(strAppName);
        }
    }
}

void EditProfileDialog::Onm_buttonDefaultClick(wxCommandEvent& event)
{
    IPSettings ipDlg(this);
    ipDlg.SetIPSetting(m_ipSet);
    if(ipDlg.ShowModal() == wxID_OK)
    {
        m_ipSet = ipDlg.GetIPSetting();
    }
    else
    {
        ipDlg.SetIPSetting(m_ipSet);
    }
}

void EditProfileDialog::Onm_buttonProxyClick(wxCommandEvent& event)
{
    ProxySettings pxoxyDlg(this);
    if ( m_cbProxy->IsChecked() )
    {
        if ( m_strProxy.IsEmpty() )
        {
            pxoxyDlg.m_TcProxy->SetValue(m_profile.stOtherSet.stProxySet.Proxy);
        }
        else
        {
            pxoxyDlg.m_TcProxy->SetValue(m_strProxy);
        }

        if ( m_strPort.IsEmpty() )
        {
            pxoxyDlg.m_TcPort->SetValue(m_profile.stOtherSet.stProxySet.Port);
        }
        else
        {
            pxoxyDlg.m_TcPort->SetValue(m_strPort);
        }
    }

    if(pxoxyDlg.ShowModal() == wxID_OK)
    {
        m_strProxy = pxoxyDlg.m_TcProxy->GetValue();
        m_strPort = pxoxyDlg.m_TcPort->GetValue();
    }
    else
    {
        pxoxyDlg.m_TcProxy->SetValue(m_strProxy);
        pxoxyDlg.m_TcPort->SetValue(m_strPort);
    }
}

void EditProfileDialog::Onm_buttonSnClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    bool bFind =(DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_CONNECT) && (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_DISCONNECT);

    if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
    {
        if(::wxGetApp().m_bMeshServer_Ra0)
        {
            bFind =  false;
        }
    }
    if ( bFind )
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDialog == NULL )
        return;

    if ( pScanNetworkDialog->IsShown() )
        pScanNetworkDialog->CloseDialog(wxID_CANCEL);
    pScanNetworkDialog->SetDialogMode(false);
    APStatus ap;
    if ( pScanNetworkDialog->ShowModal() == wxID_OK && pScanNetworkDialog->GetSelectedNetwork(&ap) )
    {
        m_textSSID->SetValue(wxString::FromUTF8((const char*)ap.ssid.ucSsid, ap.ssid.length));

        switch ( ap.type )
        {
		case WLAN_802_11_B:
			m_cbbWirelessType->SetValue(_T("802.11b"));
			break;
		case WLAN_802_11_G:
			m_cbbWirelessType->SetValue(_T("802.11g"));
			break;
		case WLAN_802_11_N:
			m_cbbWirelessType->SetValue(_T("802.11n"));
			break;
		default:
			m_cbbWirelessType->SetValue(_("Automatic"));
			break;
        }

        switch ( ap.auth )
        {
		case WLAN_AUTH_OPEN_NONE:
			m_cbbSecType->SetSelection(0);
			break;
		case WLAN_AUTH_OPEN_WEP:
			m_cbbSecType->SetSelection(1);
			break;
		case WLAN_AUTH_WPAPSK_TKIP:
			m_cbbSecType->SetSelection(2);
			break;
		case WLAN_AUTH_WPAPSK_AES:
			m_cbbSecType->SetSelection(3);
			break;
		case WLAN_AUTH_WPA2PSK_TKIP:
			m_cbbSecType->SetSelection(4);
			break;
		case WLAN_AUTH_WPA2PSK_AES:
			m_cbbSecType->SetSelection(5);
			break;
		case WLAN_AUTH_UNKNOWN:
			m_cbbSecType->SetSelection(6);
			break;
        }
        bool isEncrypted = ap.auth != WLAN_AUTH_OPEN_NONE;
        bool isForWep = ENCRYPT(ap.auth) == ENCRYPT_WEP;
		m_tcKey->SetValue(_T(""));
		m_tcConfirmKey->SetValue(_T(""));
		m_tcKey->Enable(isEncrypted);
		m_tcConfirmKey->Enable(isEncrypted);
		m_cbbIndex->SetValue(_T("1"));
		m_cbbIndex->Enable(isForWep);
//        wxString currentText = m_cbbSecType->GetValue();
//        UpdateSecurityUI(currentText);
    }
}

void EditProfileDialog::Onm_cbHomePageClick(wxCommandEvent& event)
{
    m_textHomepage->Enable(m_cbHomepage->IsChecked());
    m_textHomepage->SetEditable(m_cbHomepage->IsChecked());
}

void EditProfileDialog::BeforeClose(wxCloseEvent& event)
{
    if ( !m_isExit )
    {
        wxMessageDialog dialog(this, _("Are you sure you want to cancel the operation?"), wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
        if ( dialog.ShowModal() == wxID_YES )
        {
            m_isExit = true;
            event.Skip();
        }
    }
    else
    {
        event.Skip();
    }
}

void EditProfileDialog::UpdateSecurityUI(const WirelessSettings_t& set)
{
	if ( set.WlanSecurity == _T("open-none") )
	{
		m_cbbSecType->SetSelection(0);
		m_textTip->SetLabel(_T(""));
		m_cbbIndex->Enable(false);
	}
	else if ( set.WlanSecurity == _T("open-wep") )
	{
		m_cbbSecType->SetSelection(1);
		m_sWepKey = set.stWEPSecurity.value;
		m_tcKey->Enable(true);
		m_tcConfirmKey->Enable(true);
		m_cbbIndex->Enable(true);
		wxString strWepKey = set.stWEPSecurity.value;
		m_tcKey->SetValue(strWepKey);
		m_tcConfirmKey->SetValue(strWepKey);
		m_cbbIndex->SetValue(set.stWEPSecurity.keyIndex);
		m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
	}
	else if ( set.WlanSecurity == _T("wpa-psk-tkip") || set.WlanSecurity == _T("wpa-psk-aes")
			|| set.WlanSecurity == _T("wpa2-psk-tkip") || set.WlanSecurity == _T("wpa2-psk-aes") )
	{
		m_cbbSecType->SetSelection(2);
		if ( set.WlanSecurity == _T("wpa-psk-tkip") )
		{
			m_cbbSecType->SetSelection(2);
		}
		else if ( set.WlanSecurity == _T("wpa-psk-aes") )
		{
			m_cbbSecType->SetSelection(3);
		}
		else if ( set.WlanSecurity == _T("wpa2-psk-tkip") )
		{
			m_cbbSecType->SetSelection(4);
		}
		else if ( set.WlanSecurity == _T("wpa2-psk-aes") )
		{
			m_cbbSecType->SetSelection(5);
		}
		m_sWpaKey = set.stWPASecurity.value;
		m_tcKey->Enable(true);
		m_tcConfirmKey->Enable(true);
		m_cbbIndex->Enable(false);
		wxString strWpaKey = set.stWPASecurity.value;
		m_tcKey->SetValue(strWpaKey);
		m_tcConfirmKey->SetValue(strWpaKey);
		m_textTip->SetLabel(_T(""));
	}
	else
	{
		m_cbbSecType->SetSelection(6);
		m_textTip->SetLabel(_T(""));
		m_cbbIndex->Enable(false);
	}
}

void EditProfileDialog::UpdateSecurityUI(const wxString& strType)
{
    if (strType == _T("WPA-PSK TKIP") || strType == _T("WPA-PSK AES")
			|| strType == _T("WPA2-PSK TKIP") || strType == _T("WPA2-PSK AES") )
    {
        m_tcKey->Enable(true);
        m_tcConfirmKey->Enable(true);
        wxString strWpaKey = m_profile.stWirelessSet.stWPASecurity.value;
        m_tcKey->SetValue(strWpaKey);
        m_tcConfirmKey->SetValue(strWpaKey);
        m_cbbIndex->Enable(false);
        m_textTip->SetLabel(_T(""));
    }
    if ( strType == _T("WEP") )
    {
        m_tcKey->Enable(true);
        m_tcConfirmKey->Enable(true);
        wxString strWepKey = m_profile.stWirelessSet.stWEPSecurity.value;
        m_tcKey->SetValue(strWepKey);
        m_tcConfirmKey->SetValue(strWepKey);
        m_cbbIndex->Enable(true);
        m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
    }
    if ( strType == _("NONE") || strType== _("UNKNOWN") )
    {
        m_tcKey->Enable(false);
        m_tcConfirmKey->Enable(false);
        m_tcKey->SetValue(_T(""));
        m_tcConfirmKey->SetValue(_T(""));
        m_cbbIndex->Enable(false);
        m_textTip->SetLabel(_T(""));
    }
}
