# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.core import config, config_upgrader
import os

class TestConfigUpgrader(ElisaTestCase):

    data_dir = 'data'
    
    def _upgrade(self, old_conf_file, default_conf_file, version):
        data_dir = os.path.join(self.tests_dir, self.data_dir)
        
        old_conf_file = os.path.join(data_dir, old_conf_file)
        old_config = config.Config(old_conf_file)

        default_conf_file = os.path.join(data_dir, default_conf_file)
        default = open(default_conf_file).read()
        upgrader = config_upgrader.ConfigUpgrader(old_config, default)
        cfg = upgrader.update_for(version)

        cfg_version = cfg.get_option('version', section='general',
                                     default='0.1.7')
        version_str = '.'.join([str(i) for i in version])        
        self.assertEquals(cfg_version, version_str)
        return cfg

    def _assert_0_1_7(self, cfg):
        pass

    def _assert_0_3_1(self, cfg):
        pass

    def _assert_0_3_2(self, cfg):
        media_providers = cfg.get_option('media_providers')
        for path in ['base:local_media', 'coherence_plugin:upnp_media',
                     'media_good:gnomevfs_media', 'media_bad:ipod_media',
                     'media_good:elisa_media', 'audiocd:audiocd_media']:
            self.failIf(path not in media_providers,
                        '%s not in media_providers %r' % (path,
                                                          media_providers) )

        for path in ['media_good:amazon_covers', 'media_good:taglib_metadata',
                     'media_good:cover_cache', 'media_good:gst_metadata',
                     'media_good:cover_in_dir']:
            self.failIf(path not in cfg.get_option('metadata_providers'))

        for path in ['base:audio_activity', 'base:video_activity',
                     'base:image_activity', 'base:config_activity',
                     'base:service_activity']:
            self.failIf(path not in cfg.get_option('menu_activities',
                                                   section='base:main_menu_activity'))
        
        self.assertEqual(cfg.get_option('input_providers', section='backend1'),
                         ['input_good:lirc_input'])
        self.assertEqual(cfg.get_option('input_providers', section='frontend1'),
                         ['pigment:pigment_input'])
        self.assertEqual(cfg.get_option('service_providers'),
                         ['hal:hal_service',
                          'coherence_plugin:coherence_service'])
        self.assertEqual(cfg.get_option('service_activities', 
                                        section='base:service_activity'),
                         ['service:about_activity'])

    def _assert_0_3_3(self, cfg):
        media_providers = ['daap:daap_media', 'youtube:youtube_media',
                           'shoutcast:shoutcast_media', 'fspot:fspot_media',
                           'coherence:upnp_media', 'ipod:ipod_media',
                           'base:local_media', 'media_db:elisa_media',
                           'gvfs:gnomevfs_media', 'audiocd:audiocd_media',
                           'flickr:flickr_media', 'stage6:stage_media']
        cfg_media_providers = cfg.get_option('media_providers', default=[])
        for path in media_providers:
            self.failIf(path not in cfg_media_providers,
                        '%r not in media_providers %r' % (path,
                                                          cfg_media_providers))

        metadata_providers = ['gstreamer:gst_metadata_client',
                              'album_art:cover_in_dir', 'amazon:amazon_covers']
        for path in metadata_providers:
            self.failIf(path not in cfg.get_option('metadata_providers',
                                                   default=[]))
            
        service_providers = ['gnome:gnome_screensaver_service',
                             'hal:hal_service',
                             'coherence:coherence_service']
        cfg_service_providers = cfg.get_option('service_providers',
                                               default=[])
        for path in service_providers:
            self.failIf(path not in cfg_service_providers,
                        "%r not in service_providers %r" % (path,
                                                            cfg_service_providers))

        self.assertEqual(cfg.get_option('service_activities', 
                                        section='base:service_activity'),
                         ['service:about_activity'])

        themes = ['raval:tango_theme', 'raval:poblenou_theme',
                  'raval:chris_theme']
        cfg_themes = cfg.get_option('themes',
                                    section='theme_switcher:theme_switcher_activity',
                                    default=[])
        for path in themes:
            self.failIf(path not in cfg_themes,
                        "%r not in themes %r" % (path, cfg_themes))
            
        # check backend
        self.assertEqual(cfg.get_option('activity', section='backend1'),
                         'raval:elisa_activity')
        self.assertEqual(cfg.get_option('mvc_mappings', section='backend1'),
                         'raval:data/raval_mvc_mappings.conf')
        self.assertEqual(cfg.get_option('input_providers', section='backend1'),
                         ['lirc:lirc_input'])

        # check frontend
        self.assertEqual(cfg.get_option('theme', section='frontend1'),
                         'raval:tango_theme')
        self.assertEqual(cfg.get_option('input_providers', section='frontend1'),
                         ['pigment:pigment_input'])


        removed_sections = ['base:main_menu_activity',
                            'base:player_controller',
                            'poblenou:elisa_controller',
                            'base:audio_activity', 'base:video_activity',
                            'base:image_activity', 'elisa_view']
        for section_name in removed_sections:
            self.failIf(cfg.get_section(section_name))

    def _assert_0_3_4(self, cfg):

        media_providers = cfg.get_option('media_providers', default=[])
        self.failIf('stage6:stage_media' in media_providers)

        metadata_providers = ['media_db:db_metadata',]
        for path in metadata_providers:
            self.failIf(path not in cfg.get_option('metadata_providers',
                                                   default=[]))
            
        service_providers = ['media_db:media_scanner',
                             'osso:osso_service']
        cfg_service_providers = cfg.get_option('service_providers',
                                               default=[])
        for path in service_providers:
            self.failIf(path not in cfg_service_providers,
                        "%r not in service_providers %r" % (path,
                                                            cfg_service_providers))
        self.failIf('updater:updater_service' in cfg_service_providers,
                    "elisa updater service should be disabled for 0.3.4 release")

        removed_sections = ['media_scanner',]
        for section_name in removed_sections:
            self.failIf(cfg.get_section(section_name))

        show_fps = cfg.get_option('show_fps', section='pigment:pigment_context')
        if show_fps is not None:
            self.assertEqual(show_fps, '0')

    def _assert_0_3_5(self, cfg):
        removed_sections = ['base:player_controller',
                            'poblenou:player_view']
        for section_name in removed_sections:
            self.failIf(cfg.get_section(section_name))

    def _assert_0_3_6(self, cfg):
        pass

    def test_upgrades(self):
        to_check = []
        upgrader = config_upgrader.ConfigUpgrader(None, None)
        for versions, call in upgrader.releases:
            version = versions[0]
            version_tuple = tuple(version.split('.'))
            assert_method = getattr(self,
                                    '_assert_%s' % '_'.join(version_tuple))
            to_check.append((version_tuple, assert_method))

        for item in to_check:
            idx = to_check.index(item)
            version_tuple, do_assert = item
            for up_version_tuple, up_do_assert in to_check[idx+1:]:
                old_conf = 'elisa_%s.conf' % '_'.join(version_tuple)
                new_conf = 'elisa_%s.conf' % '_'.join(up_version_tuple)
                cfg = self._upgrade(old_conf, new_conf, up_version_tuple)
                up_do_assert(cfg)
