# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
Models specific to the Flickr plugin.
"""

from elisa.core.components.model import Model

class FlickrPhotoModel(Model):

    """
    A Flickr photo model contains metadata associated to a photo.

    @ivar flickr_id:   the id of the photo
    @type flickr_id:   C{unicode}
    @ivar owner:       the id of the owner of the photo
    @type owner:       C{unicode}
    @ivar secret:      the shared secret
    @type secret:      C{unicode}
    @ivar farm:        the Flickr server farm on which the photo is stored
    @type farm:        C{int}
    @ivar server:      the Flickr server on which the photo is stored
    @type server:      C{int}
    @ivar title:       the title associated to the photo
    @type title:       C{unicode}
    @ivar description: a description of the photo
    @type description: C{unicode}
    @ivar ispublic:    whether the photo is visible by anyone
    @type ispublic:    C{bool}
    @ivar isfriend:    whether the photo is visible by the owner's friends
    @type isfriend:    C{bool}
    @ivar isfamily:    whether the photo is visible by the owner's family
    @type isfamily:    C{bool}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(FlickrPhotoModel, self).__init__()
        self.flickr_id = None
        self.owner = None
        self.secret = None
        self.farm = None
        self.server = None
        self.title = None
        self.description = None
        self.ispublic = None
        self.isfriend = None
        self.isfamily = None


class FlickrTagModel(Model):

    """
    A Flickr tag model contains information associated to a tag.

    @ivar label: the label of the tag
    @type label: C{unicode}
    @ivar score: a numerical score associated to the tag
    @type score: C{int}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(FlickrTagModel, self).__init__()
        self.label = None
        self.score = None


class FlickrResponseModel(Model):

    """
    A generic model containing a representation of the XML response returned by
    the Flickr API.
    """

    pass
