import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-lirc',
    version='0.0.1', 
    description='Acces Elisa with a remote control',
    license='GPL3', 
    author='Benjamin Kampmann',
    author_email='big.master.ben@web.de',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    cmdclass=cmdclass,
    entry_points="""
    [elisa.core.components.input_provider]
    LircInput = elisa.plugins.lirc.lirc_input:LircInput
    """)
