# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
A simple import and initialize test for the base messages.
"""

from elisa.plugins.base.messages import network

from twisted.trial.unittest import TestCase

class MessageMixin(object):

    module = None

    def test_import_and_initialize(self):
        models = filter(lambda x: x.endswith('Message'), dir(self.module))
        for model_name in models:
            model_class = getattr(self.module, model_name)
            obj = model_class()


class TestNetworkMessages(TestCase, MessageMixin):

    module = network

    def test_uid_through_model(self):
        """
        test that the uid system works for the network service appeared messages
        """
        class TestModel(object):
            pass

        my_model = TestModel()
        my_model.uid = 'test'

        msg = network.NetworkServiceAppearedMessage(my_model)
        self.assertEquals(msg.uid, 'test')

    def test_uid_on_disapperead(self):
        """
        test that the uid is set on the disappeared messages
        """
        msg = network.NetworkServiceDisappearedMessage(uid='pocahontas')
        self.assertEquals(msg.uid, 'pocahontas')


