# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pgm
from elisa.plugins.pigment.widgets.list import List


class ListHorizontal(List):

    def visible_range_size__set(self, visible_range_size):
        self._item_width = 1.0/visible_range_size
        self._item_height = 1.0
        super(ListHorizontal, self).visible_range_size__set(visible_range_size)

    visible_range_size = property(List.visible_range_size__get,
                                  visible_range_size__set)

    def compute_x(self, index):
        return index*self._item_width

    def _layout_widget(self, widget, position):
        widget.x = self.compute_x(position)
        widget.opacity = self.compute_opacity(position)

    def _prepare_widget(self, widget):
        widget.size = (self._item_width, self._item_height)

    def _prepare_selector(self):
        if self._selector != None:
            self._selector.y = 0.0
            self._selector.size = (self._item_width, self._item_height)

    def _actual_layout_selector(self, selector, selected_item_index):
        selector.x = self.compute_x(selected_item_index)

    # Signals support methods

    def do_key_press_event(self, viewport, event, widget):
        if event.keyval == pgm.keysyms.Left:
            if self.selected_item_index > 0:
                self.selected_item_index -= 1
        elif event.keyval == pgm.keysyms.Right:
            if self.selected_item_index < (len(self.model) - 1):
                self.selected_item_index += 1
        elif event.keyval == pgm.keysyms.Home:
            self.selected_item_index = 0
        elif event.keyval == pgm.keysyms.End:
            self.selected_item_index = len(self.model) - 1
        elif event.keyval == pgm.keysyms.Page_Up:
            self.selected_item_index -= (self.visible_range_size - 1)
        elif event.keyval == pgm.keysyms.Page_Down:
            self.selected_item_index += (self.visible_range_size - 1)

    def do_drag_motion(self, x, y, z, button, time, pressure):
        time_since_last = time - self._last_drag_motion
        if time_since_last > self.drag_motion_resolution:
            self._last_drag_motion = time
        else:
            return True

        absolute_item_width = self._item_width*self.absolute_width
        motion = (x-self._initial[0])/absolute_item_width
        self.visible_range_start -= motion

        time_delta = time - self._initial[2]
        if time_delta != 0:
            self.speed = motion/time_delta*1000.0

        self._initial = (x, y, time)
        self._drag_accum += abs(motion)

        return True

if __name__ == "__main__":
    import logging
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    list = ListHorizontal.demo()
    list.size = (3.0, 0.3)
    try:
        __IPYTHON__
    except NameError:
        pgm.main()

