# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.button import Button
from elisa.plugins.pigment.widgets.const import *
import pgm

class TestButton(unittest.TestCase):

    def test_simple(self):
        button = Button()

    def test_image(self):
        button = Button()
        img_file = resource_filename('elisa.plugins.pigment.widgets', 'data/yes.png')
        button.image = img_file

        self.assertEqual(img_file, button.image)

        img_file = resource_filename('elisa.plugins.pigment.widgets', 'data/non-existent.png')
        def set_image():
            button.image = img_file

        self.assertRaises(AssertionError, set_image)

    def test_label(self):
        button = Button()

        self.assertEqual(button.label, '')

        button.label = "ciao"
        self.assertEqual(button.label, 'ciao')

    def test_states(self):
        for focus_on_click in [True, False]:
            button = Button()
            button.focous_on_click = focus_on_click

            self.assertEqual(button.state, STATE_NORMAL)

            button.emit('pressed', 0, 0, 0, pgm.BUTTON_LEFT, 0, 0)
            self.assertEqual(button.state, STATE_ACTIVE)

            prev_state = button.state
            button.emit('released', 0, 0, 0, pgm.BUTTON_LEFT, 0)
            if not button.focus_on_click:
                self.assertEqual(button.state, STATE_NORMAL)
            else:
                self.assertEqual(button.state, prev_state)


