# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import gobject
import pgm

class Node(gobject.GObject):

    def __init__(self):
        super(Node, self).__init__()
        self._parent = None

        self._relative_visible = False
        self.absolute_visible = self._relative_visible
        self._relative_x = 0.0
        self._relative_y = 0.0
        self._relative_z = 0.0
        self._relative_width = 1.0
        self._relative_height = 1.0
        self._relative_opacity = 255
        self.absolute_opacity = self._relative_opacity

    def parent__set(self, parent):
        self._parent = parent

        if parent != None:
            # compute relative properties so that the node does not move when
            # reparented
            self._relative_width = self.absolute_width/self._parent.absolute_width
            self._relative_height = self.absolute_height/self._parent.absolute_height
            self._relative_x = (self.absolute_x-self._parent.absolute_x)/ \
                                self._parent.absolute_width
            self._relative_y = (self.absolute_y-self._parent.absolute_y)/ \
                                self._parent.absolute_height
            self._relative_z = self.absolute_z-self._parent.absolute_z

            # update absolute properties using current relative values
            self.update_absolute_visible()
        else:
            self.absolute_visible = self._relative_visible

    def parent__get(self):
        return self._parent

    parent = property(parent__get, parent__set)

    def x__get(self):
        if self._parent == None:
            return self.absolute_x
        else:
            return self._relative_x

    def x__set(self, value):
        if self._parent == None:
            self.update_absolute_x(value)
        else:
            self._relative_x = value
            self.update_absolute_x()

    x = property(x__get, x__set)

    def update_absolute_x(self, value=None):
        if value != None:
            self.absolute_x = value
        else:
            self.absolute_x = self._parent.absolute_x + \
                              self._relative_x * self._parent.absolute_width

    def y__get(self):
        if self._parent == None:
            return self.absolute_y
        else:
            return self._relative_y

    def y__set(self, value):
        if self._parent == None:
            self.update_absolute_y(value)
        else:
            self._relative_y = value
            self.update_absolute_y()

    y = property(y__get, y__set)

    def update_absolute_y(self, value=None):
        if value != None:
            self.absolute_y = value
        else:
            self.absolute_y = self._parent.absolute_y + \
                              self._relative_y*self._parent.absolute_height

    # FIXME: write tests for z property
    def z__get(self):
        if self._parent == None:
            return self.absolute_z
        else:
            return self._relative_z

    def z__set(self, value):
        if self._parent == None:
            self.update_absolute_z(value)
        else:
            self._relative_z = value
            self.update_absolute_z()

    z = property(z__get, z__set)

    def update_absolute_z(self, value=None):
        if value != None:
            self.absolute_z = value
        else:
            self.absolute_z = self._parent.absolute_z + self._relative_z

    # Position property

    def position__get(self):
        if self._parent == None:
            return self.absolute_position
        else:
            return (self._relative_x, self._relative_y, self._relative_z)

    def position__set(self, position):
        if self._parent == None:
            self.update_absolute_position(position)
        else:
            self._relative_x = position[0]
            self._relative_y = position[1]
            self._relative_z = position[2]
            self.update_absolute_position()

    position = property(position__get, position__set)

    def update_absolute_position(self, value=None):
        if value != None:
            self.absolute_position = value
        else:
            parent_position = self._parent.absolute_position
            parent_size = self._parent.absolute_size
            self.absolute_position = (
                        parent_position[0] + self._relative_x * parent_size[0],
                        parent_position[1] + self._relative_y * parent_size[1],
                        parent_position[2] + self._relative_z)

    # Width property

    def width__get(self):
        if self._parent == None:
            return self.absolute_width
        else:
            return self._relative_width

    def width__set(self, value):
        if self._parent == None:
            self.update_absolute_width(value)
        else:
            self._relative_width = value
            self.update_absolute_width()

    width = property(width__get, width__set)

    def update_absolute_width(self, value=None):
        if value != None:
            self.absolute_width = value
        else:
            self.absolute_width = self._relative_width*self._parent.absolute_width

        # FIXME: write tests before uncommenting
        #self.update_absolute_x()

    def height__get(self):
        if self._parent == None:
            return self.absolute_height
        else:
            return self._relative_height

    def height__set(self, value):
        if self._parent == None:
            self.update_absolute_height(value)
        else:
            self._relative_height = value
            self.update_absolute_height()

    height = property(height__get, height__set)

    def update_absolute_height(self, value=None):
        if value != None:
            self.absolute_height = value
        else:
            self.absolute_height = self._relative_height*self._parent.absolute_height

        # FIXME: write tests before uncommenting
        #self.update_absolute_y()

    # Size property

    def size__get(self):
        if self._parent == None:
            return self.absolute_size
        else:
            return self._relative_width, self._relative_height

    def size__set(self, size):
        if self._parent == None:
            self.update_absolute_size(size)
        else:
            self._relative_width = size[0]
            self._relative_height = size[1]
            self.update_absolute_size()

    size = property(size__get, size__set)

    def update_absolute_size(self, value=None):
        if value != None:
            self.absolute_size = value
        else:
            parent_size = self._parent.absolute_size
            self.absolute_size = (self._relative_width * parent_size[0],
                                  self._relative_height * parent_size[1])

    # Visible

    def visible__get(self):
        if self._parent == None:
            return self.absolute_visible
        else:
            return self._relative_visible

    def visible__set(self, value):
        if self._parent == None:
            self._relative_visible = value
            self.update_absolute_visible(value)
        else:
            self._relative_visible = value
            self.update_absolute_visible()

    visible = property(visible__get, visible__set)

    def update_absolute_visible(self, value=None):
        if value != None:
            self.absolute_visible = value
        else:
            self.absolute_visible = self._relative_visible and \
                                    self._parent.absolute_visible

     # FIXME: write tests for opacity
    def opacity__get(self):
        if self._parent == None:
            return self.absolute_opacity
        else:
            return self._relative_opacity

    def opacity__set(self, value):
        if self._parent == None:
            self._relative_opacity = value
            self.update_absolute_opacity(value)
        else:
            self._relative_opacity = value
            self.update_absolute_opacity()

    opacity = property(opacity__get, opacity__set)

    def update_absolute_opacity(self, value=None):
        if value != None:
            self.absolute_opacity = value
        else:
            self.absolute_opacity = \
                    int(self._relative_opacity*self._parent.absolute_opacity/255.0)

    def clean(self):
        pass