# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Guido Amoruso <guidonte@fluendo.com>


from elisa.core import common

from elisa.core.media_uri import MediaUri
from elisa.plugins.base.models.media import PlayableModel

from elisa.plugins.poblesec.actions import Action
from elisa.plugins.poblesec.actions import PlayAllAction, ShuffleAction
from elisa.plugins.poblesec.actions import AddToFavoritesAction, AddToPlaylistAction
from elisa.plugins.poblesec.actions import ViewSlideshowAction

from elisa.plugins.favorites.models import FavoritesItem
from elisa.plugins.database.models import Image

from twisted.internet import defer

import datetime
import os.path


class ArtistPlayAllAction(PlayAllAction):
    pass

class AlbumPlayAllAction(PlayAllAction):
    pass

class TrackPlayAllAction(PlayAllAction):

    def run(self):
        track = self.controller.track
        if track is not None:
            # Enqueue all the media after 'track' and play
            tracks = self.controller.tracks
            index = tracks.index(track)
            self.play(tracks[index:])
            return defer.succeed(None)
        else:
            dfr = super(TrackPlayAllAction, self).run()

        return dfr


class ArtistShuffleAction(ArtistPlayAllAction, ShuffleAction):
    pass

class AlbumShuffleAction(AlbumPlayAllAction, ShuffleAction):
    pass

class TrackShuffleAction(TrackPlayAllAction, ShuffleAction):
    pass


class AlbumAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.artist:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.artist.name,
                                                    FavoritesItem.foreign_class == u'Artist')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting an AlbumsController
            if self.controller.artist:
                favorite.foreign_id = self.controller.artist.name
                favorite.foreign_class = u'Artist'
                favorite.title = self.controller.artist.name
                self.store(favorite)

class TrackAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.album:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.album.name,
                                                    FavoritesItem.foreign_class == u'MusicAlbum')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
            elif self.controller.track:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.track.file_path,
                                                    FavoritesItem.foreign_class == u'MusicTrack')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting a TracksController
            if self.controller.album:
                favorite.foreign_id = self.controller.album.name
                favorite.foreign_class = u'MusicAlbum'
                favorite.title = self.controller.album.name
                self.store(favorite)
            elif self.controller.track:
                favorite.foreign_id = self.controller.track.file_path
                favorite.foreign_class = u'MusicTrack'
                favorite.title = self.controller.track.title
                self.store(favorite)

class PhotoAddToFavoritesAction(AddToFavoritesAction):

    def run(self):
        if self.toggled:
            if self.controller.album:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.album.name,
                                                    FavoritesItem.foreign_class == u'PhotoAlbum')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
            elif self.controller.photo:
                dfr = common.application.store.find(FavoritesItem,
                                                    FavoritesItem.foreign_id == self.controller.photo.file_path,
                                                    FavoritesItem.foreign_class == u'Image')
                dfr.addCallback(lambda rs: rs.one())
                dfr.addCallback(self.remove)
        else:
            favorite = FavoritesItem()
            favorite.added_time = datetime.datetime.now()

            # expecting a TracksController
            if self.controller.album:
                favorite.foreign_id = self.controller.album.name
                favorite.foreign_class = u'PhotoAlbum'
                favorite.title = self.controller.album.name
                self.store(favorite)
            elif self.controller.photo:
                favorite.foreign_id = self.controller.photo.file_path
                favorite.foreign_class = u'Image'
                # FIXME: find a better title
                favorite.title = os.path.basename(self.controller.photo.file_path)
                self.store(favorite)


class ArtistAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()

class AlbumAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()

class TrackAddToPlaylistAction(AddToPlaylistAction):

    def run(self):
        raise NotImplementedError()


class ViewPhotoAlbumSlideshowAction(ViewSlideshowAction):

    def order_photos(self, rs):
        # copied and pasted the ordering from database.PhotosController
        rs.order_by(Image.shot_time, Image.file_path)
        return rs.all()

    def get_items(self, item):
        dfr = common.application.store.find(Image, Image.album_name == item.name)
        dfr.addCallback(self.order_photos)
        return dfr

class ViewPhotoDateSlideshowAction(ViewSlideshowAction):

    def order_photos(self, rs):
        # copied and pasted the ordering from database.PhotosController
        rs.order_by(Image.shot_time)
        return rs.all()

    def run(self):
        dfr = common.application.store.find(Image, Image.shot_time != None)
        dfr.addCallback(self.order_photos)
        dfr.addCallback(self.play)
        return dfr
