# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampann <benjamin@fluendo.com>


from elisa.core.components.model import Model

"""
The Models containing the different results for a search request
"""

class MusicSearchResultModel(Model):
    """
    Contains the result of a music search (C{elisa://search/music}).

    @ivar   artists:    the artists found for that search
    @type   artists:    C{list} of
                        L{elisa.plugins.base.models.audio.ArtistModel}'s
    @ivar   albums:     the albums found for that search
    @type   albums:     C{list} of
                        L{elisa.plugins.base.models.audio.AlbumModel}'s
    @ivar   tracks:     the tracks found for that search
    @type   tracks:     C{list} of
                        L{elisa.plugins.base.models.audio.TrackModel}'s
    """
    # FIXME: do we want NotifyingLists here?
    def __init__(self):
        super(MusicSearchResultModel, self).__init__()
        self.artists = []
        self.albums = []
        self.tracks = []

class VideosSearchResultModel(Model):
    """
    Contains the result of a video search (C{elisa://search/videos}).

    @ivar   videos:     the videos found
    @type   videos:     C{list} of
                        L{elisa.plugins.base.models.video.VideoModel}'s
    """

    def __init__(self):
        super(VideosSearchResultModel, self).__init__()
        self.videos = []
        
