import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-poblesec',
    version='0.1',
    description='Poblesec frontend',
    license='GPL3', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.conf', 'theme/*.png', 'theme/*/*.png', 'tango/*.png', 'data/*.xml'],
                  'elisa.plugins.poblesec.i18n': ['*/LC_MESSAGES/*.po', '*.pot'],
                 },
    controller_mappings=[('/poblesec',
                          'elisa.plugins.poblesec.main:PoblesecController'),
                         ('/poblesec/browser',
                          'elisa.plugins.poblesec.poblesec_browser_controller:PoblesecBrowserController'),
                         ('/poblesec/video_player',
                          'elisa.plugins.poblesec.player_video:VideoPlayerController'),
                         ('/poblesec/music_player',
                          'elisa.plugins.poblesec.player_audio:AudioPlayerController'),
                         ('/poblesec/slideshow_player',
                          'elisa.plugins.poblesec.player_slideshow:SlideshowController'),
                         ('/poblesec/sections_menu',
                          'elisa.plugins.poblesec.sections_menu:SectionsMenuController'),
                         ('/poblesec/music_menu',
                          'elisa.plugins.poblesec.section:MusicHardwareListController'),
                         ('/poblesec/video_menu',
                          'elisa.plugins.poblesec.section:VideoHardwareListController'),
                         ('/poblesec/pictures_menu',
                          'elisa.plugins.poblesec.section:PicturesHardwareListController'),
                         ('/poblesec/settings_menu',
                          'elisa.plugins.poblesec.section:SectionMenuController'),

                         ('/poblesec/music/filesystem',
                          'elisa.plugins.poblesec.filesystem:FilesystemListSwitcherController'),
                         ('/poblesec/music/directory_list',
                          'elisa.plugins.poblesec.directory_settings:MediaDirectoryList'),
                         ('/poblesec/music/internet',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/music/network',
                          'elisa.plugins.poblesec.network:NetworkSharesList'),

                         ('/poblesec/video/filesystem',
                          'elisa.plugins.poblesec.filesystem:FilesystemListSwitcherController'),
                         ('/poblesec/video/directory_list',
                          'elisa.plugins.poblesec.directory_settings:MediaDirectoryList'),
                         ('/poblesec/video/internet',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/video/network',
                          'elisa.plugins.poblesec.network:NetworkSharesList'),

                         ('/poblesec/pictures/filesystem',
                          'elisa.plugins.poblesec.filesystem:FilesystemListSwitcherGridController'),
                         ('/poblesec/pictures/directory_list',
                          'elisa.plugins.poblesec.directory_settings:MediaDirectoryList'),
                         ('/poblesec/pictures/internet',
                          'elisa.plugins.poblesec.section:SectionMenuController'),
                         ('/poblesec/pictures/network',
                          'elisa.plugins.poblesec.network:NetworkSharesList'),

                         ('/poblesec/settings/directory_settings',
                          'elisa.plugins.poblesec.directory_settings:DirectorySettingsController'),
                         ('/poblesec/settings/directory_selection_settings',
                          'elisa.plugins.poblesec.directory_settings:DirectoryConfigureController'),
                         ('/poblesec/settings/login',
                          'elisa.plugins.poblesec.section:SectionMenuController'),

                         ('/poblesec/network',
                          'elisa.plugins.poblesec.network:NetworkListSwitcherController'),

                         ('/poblesec/popup',
                          'elisa.plugins.poblesec.popup:PopupController'),
                         ('/poblesec/search/.*',
                          'elisa.plugins.poblesec.search_controller:SearchController'),
                         ],
    decorator_mappings=[('/poblesec',
                         'elisa.plugins.poblesec.viewport_buttons:buttons_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.moblin:moblin_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.settings:settings_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.services:services_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.pictures:pictures_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.video:video_decorator'),
                        ('/poblesec/sections_menu',
                         'elisa.plugins.poblesec.music:music_decorator'),

                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.section:hardware_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:network_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:internet_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the database plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/music_menu',
                         'elisa.plugins.database.playlists_controller:music_playlists_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the favorites plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/music_menu',
                         'elisa.plugins.favorites.controller:music_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the database plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/music_menu',
                         'elisa.plugins.database.music_controller:music_lib_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:artists_decorator'),
                        ('/poblesec/music_menu',
                         'elisa.plugins.poblesec.music:albums_decorator'),

                        ('/poblesec/video_menu',
                         'elisa.plugins.poblesec.section:hardware_decorator'),
                        ('/poblesec/video_menu',
                         'elisa.plugins.poblesec.video:network_decorator'),
                        ('/poblesec/video_menu',
                         'elisa.plugins.poblesec.video:internet_decorator'),
                        ('/poblesec/video_menu',
                         'elisa.plugins.database.playlists_controller:video_playlists_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the favorites plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/video_menu',
                         'elisa.plugins.favorites.controller:videos_decorator'),
                        ('/poblesec/video_menu',
                         'elisa.plugins.database.video_controller:video_lib_decorator'),

                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.section:hardware_decorator'),
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.pictures:network_decorator'),
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.poblesec.pictures:internet_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the database plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.database.playlists_controller:pictures_playlists_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the favorites plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/pictures_menu',
                        'elisa.plugins.favorites.controller:pictures_decorator'),
                        # FIXME: the following decorator should not be here
                        # but in the database plugin ; this works around an
                        # ordering issue in the menus.
                        ('/poblesec/pictures_menu',
                         'elisa.plugins.database.photo_controller:photo_lib_decorator'),

                        # Disabled, as there are no login services
                        #('/poblesec/settings_menu',
                        # 'elisa.plugins.poblesec.settings:login_settings_decorator'),
                        ('/poblesec/settings_menu',
                         'elisa.plugins.poblesec.settings:directory_settings_decorator'),

                        # FIXME: the following decorators should not be here
                        # but in their respective plugins ; this works around
                        # an ordering issue.
                        ('/poblesec/search/music',
                         'elisa.plugins.yesfm.controllers:music_search_result_decorator'),
                        ('/poblesec/search/music',
                         'elisa.plugins.database.music_controller:music_search_result_decorator'),
                       ],
    cmdclass=cmdclass,
    distclass=Distribution)
