# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest

from elisa.plugins.pigment.widgets.size_enforcer import Square
from elisa.plugins.pigment.graph.group import Group

class TestSquareWithoutParent(unittest.TestCase):
    """
    Tests of a Square object in the case it does not belong to a parent Group.
    """

    def test_size_set(self):
        square = Square()

        square.size = (1.0, 1.0)
        self.assertIsSquare(square, 1.0)

        square.size = (2.0, 2.0)
        self.assertIsSquare(square, 2.0)

        # pass a non square size changing only one attribute
        # the attribute changed has priority (width)
        square.size = (1.5, 2.0)
        self.assertIsSquare(square, 1.5)

        # pass a non square size changing both attributes
        # the height has priority over the width
        square.size = (0.5, 2.5)
        self.assertIsSquare(square, 2.5)

        square.size = (3.0, 3.0)
        self.assertIsSquare(square, 3.0)

    def test_width_set(self):
        square = Square()

        square.width = 2.2
        self.assertIsSquare(square, 2.2)

        square.width = 3.1
        self.assertIsSquare(square, 3.1)

        # test width set to 0
        square.width = 0.0
        self.assertIsSquare(square, 0.0)

    def test_height_set(self):
        square = Square()

        square.height = 2.2
        self.assertIsSquare(square, 2.2)

        square.height = 3.1
        self.assertIsSquare(square, 3.1)

        # test height set to 0
        square.height = 0.0
        self.assertIsSquare(square, 0.0)

    def assertIsSquare(self, widget, size):
        self.assertEqual(widget.width, widget.height)
        self.assertEqual(widget.width, size)
        self.assertEqual(widget.height, size)



class TestSquareWithParent(unittest.TestCase):
    """
    Tests of a Square object in the case it belongs to a parent Group.
    """

    def test_size_set(self):
        parent = Group()
        parent.size = (3.0, 2.0)
        square = Square()
        parent.add(square)

        square.size = (1.0, 1.0)
        self.assertIsSquare(square)

        square.size = (0.5, 0.5)
        self.assertIsSquare(square)

        # pass a non square size changing only one attribute
        square.size = (0.2, 0.5)
        self.assertIsSquare(square)

        # pass a non square size changing both attributes
        square.size = (0.7, 0.3)
        self.assertIsSquare(square)

        square.size = (0.1, 0.1)
        self.assertIsSquare(square)

    def test_width_set(self):
        parent = Group()
        parent.size = (3.0, 2.0)
        square = Square()
        parent.add(square)

        square.width = 0.2
        self.assertIsSquare(square)

        square.width = 0.1
        self.assertIsSquare(square)

        # test width set to 0
        square.width = 0.0
        self.assertIsSquare(square)

    def test_height_set(self):
        parent = Group()
        parent.size = (3.0, 2.0)
        square = Square()
        parent.add(square)

        square.height = 0.2
        self.assertIsSquare(square)

        square.height = 0.1
        self.assertIsSquare(square)

        # test height set to 0
        square.height = 0.0
        self.assertIsSquare(square)

    def assertIsSquare(self, widget):
        self.assertEqual(widget.absolute_width, widget.absolute_height)
