# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pgm

from elisa.core import __version__
from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation

from elisa.plugins.pigment.pigment_controller import PigmentController
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.box import HBox, VBox, ALIGNMENT

from elisa.plugins.poblesec.link import Link


_ = install_translation('hp')


def about_main_menu_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/about"
    link.label = _("About")
    link.icon = "elisa.plugins.hp.about.menu_entry"
    controller.model.append(link)
    return defer.succeed(None)


class AboutBox(HBox):

    def __init__(self):
        super(AboutBox, self).__init__()

        self.spacing = 0.045

        # logo on the left handside
        self.logo = Image()
        self.pack_start(self.logo)
        self.logo.alignment = pgm.IMAGE_TOP
        self.logo.bg_a = 0
        self.logo.width = 0.211
        self.logo.visible = True

        # text column on the righthandside
        self._information = VBox()
        self._information.spacing = 0.0015
        self._information.alignment = ALIGNMENT.START
        self.pack_end(self._information, expand=True)
        self._information.visible = True

        self.title = Text()
        self._information.pack_start(self.title)
        self.title.height = 0.072
        self.title.bg_color = (0, 0, 0, 0)
        self.title.weight = pgm.TEXT_WEIGHT_BOLD
        self.title.font_family = "Liberation Sans"
        self.title.visible = True

        self.subtitle = Text()
        self._information.pack_start(self.subtitle)
        self.subtitle.height = 0.05
        self.subtitle.bg_color = (0, 0, 0, 0)
        self.subtitle.weight = pgm.TEXT_WEIGHT_BOLD
        self.subtitle.font_family = "Liberation Sans"
        self.subtitle.visible = True

        spacer = Image()
        self._information.pack_start(spacer)
        spacer.height = 0.03

        self.version = Text()
        self._information.pack_start(self.version)
        self.version.height = 0.05
        self.version.bg_color = (0, 0, 0, 0)
        self.version.fg_color = (153, 153, 153, 255)
        self.version.weight = pgm.TEXT_WEIGHT_BOLD
        self.version.font_family = "Liberation Sans"
        self.version.visible = True

        spacer = Image()
        self._information.pack_start(spacer)
        spacer.height = 0.13

        self.links_title = Text()
        self._information.pack_start(self.links_title)
        self.links_title.height = 0.05
        self.links_title.bg_color = (0, 0, 0, 0)
        self.links_title.fg_color = (153, 153, 153, 255)
        self.links_title.weight = pgm.TEXT_WEIGHT_BOLD
        self.links_title.font_family = "Liberation Sans"
        self.links_title.visible = True

        spacer = Image()
        self._information.pack_start(spacer)
        spacer.height = 0.03

    def insert_link(self, label):
        link = Text()
        self._information.pack_start(link)
        link.height = 0.05
        link.bg_color = (0, 0, 0, 0)
        link.fg_color = (153, 153, 153, 255)
        link.weight = pgm.TEXT_WEIGHT_BOLD
        link.font_family = "Liberation Sans"
        link.label = label
        link.visible = True

class AboutController(PigmentController):

    def initialize(self):
        dfr = super(AboutController, self).initialize()
        return dfr

    def set_frontend(self, frontend):
        super(AboutController, self).set_frontend(frontend)

        self._about_box = AboutBox()
        self.widget.add(self._about_box)
        width, height = 0.71, 0.758
        self._about_box.size = (width, height)
        self._about_box.position = (1.0-width, 1.0-height, 0.0)

        theme = self.frontend.get_theme()
        logo_path = theme.get_resource('elisa.plugins.hp.about.hp_logo')
        self._about_box.logo.set_from_file(logo_path)

        self._about_box.title.label = "HP MediaStyle"
        self._about_box.subtitle.label = _("Powered by Elisa")

        self._about_box.version.label = "version %s (GPL v3)" % __version__

        self._about_box.links_title.label = _("For more information please visit:")
        self._about_box.insert_link("http://hp.com")
        self._about_box.insert_link("http://elisa.fluendo.com")

        self._about_box.visible = True
