/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class CBClause
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int falsified;
    private boolean learnt;
    protected final int[] lits;
    protected final ILits voc;
    private double activity;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.CBClause");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static CBClause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt) {
        CBClause cBClause = new CBClause(iVecInt, iLits);
        cBClause.register();
        return cBClause;
    }

    public CBClause(IVecInt iVecInt, ILits iLits, boolean bl) {
        this.learnt = bl;
        this.lits = new int[iVecInt.size()];
        this.voc = iLits;
        iVecInt.moveTo(this.lits);
    }

    public CBClause(IVecInt iVecInt, ILits iLits) {
        this(iVecInt, iLits, false);
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.lits.length) {
            this.voc.watches(this.lits[n] ^ 1).remove(this);
            ++n;
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.undos(n).push(this);
        ++this.falsified;
        if (!$assertionsDisabled && this.falsified == this.lits.length) {
            throw new AssertionError();
        }
        if (this.falsified == this.lits.length - 1) {
            int n2 = 0;
            while (n2 < this.lits.length) {
                if (!this.voc.isFalsified(this.lits[n2])) {
                    return unitPropagationListener.enqueue(this.lits[n2], this);
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public boolean simplify() {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (this.voc.isSatisfied(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void undo(int n) {
        --this.falsified;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        if (!$assertionsDisabled && iVecInt.size() != 0) {
            throw new AssertionError();
        }
        int[] nArray = this.lits;
        int n2 = this.lits.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (!$assertionsDisabled && !this.voc.isFalsified(n4) && n4 != n) {
                throw new AssertionError();
            }
            if (this.voc.isFalsified(n4)) {
                iVecInt.push(n4 ^ 1);
            }
            ++n3;
        }
        if (!$assertionsDisabled && n != -1 && iVecInt.size() != this.lits.length - 1) {
            throw new AssertionError();
        }
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void incActivity(double d) {
        if (this.learnt) {
            this.activity += d;
        }
    }

    public double getActivity() {
        return this.activity;
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        int n;
        int[] nArray = this.lits;
        int n2 = this.lits.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            this.voc.watch(n ^ 1, this);
            ++n3;
        }
        if (this.learnt) {
            nArray = this.lits;
            n2 = this.lits.length;
            n3 = 0;
            while (n3 < n2) {
                n = nArray[n3];
                if (this.voc.isFalsified(n)) {
                    this.voc.undos(n ^ 1).push(this);
                    ++this.falsified;
                }
                ++n3;
            }
            if (!$assertionsDisabled && this.falsified != this.lits.length - 1) {
                throw new AssertionError();
            }
        }
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        if (!$assertionsDisabled && !this.voc.isUnassigned(this.lits[0])) {
            throw new AssertionError();
        }
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.lits.length) {
            stringBuffer.append(this.lits[n]);
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[n]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void forwardActivity(double d) {
        if (!this.learnt) {
            this.activity += d;
        }
    }
}

