/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _WLAN_ACM_EVENT_H
#define _WLAN_ACM_EVENT_H

#include <wx/event.h>

// messages id boundary
const unsigned int ID_WLAN_ACM_EVENT_LOWEST		= wxID_HIGHEST + 0x0020;
//const unsigned int ID_WLAN_MSM_EVENT_LOWEST		= wxID_HIGHEST + 0x0040;
//const unsigned int ID_WLAN_SEC_EVENT_LOWEST		= wxID_HIGHEST + 0x0060;
//const unsigned int ID_WLAN_IHV_EVENT_LOWEST		= wxID_HIGHEST + 0x0080;

// acm message id
const unsigned int ID_WLAN_ACM_INTERFACE        = ID_WLAN_ACM_EVENT_LOWEST + 1;
const unsigned int ID_WLAN_ACM_SCAN_COMPLETE    = ID_WLAN_ACM_EVENT_LOWEST + 2;
const unsigned int ID_WLAN_ACM_NETWORK          = ID_WLAN_ACM_EVENT_LOWEST + 3;
const unsigned int ID_WLAN_ACM_CONNECT          = ID_WLAN_ACM_EVENT_LOWEST + 4;

// event code boundary
const unsigned long WLAN_ACM_EVENT_CODE_LOWEST      = wxID_HIGHEST + 0x0100;

// acm event code
const unsigned long WLAN_ACM_EVENT_CONNECT_SUCCESS  = WLAN_ACM_EVENT_CODE_LOWEST + 1L;
const unsigned long WLAN_ACM_EVENT_CONNECT_FAILED   = WLAN_ACM_EVENT_CODE_LOWEST + 2L;
const unsigned long WLAN_ACM_EVENT_DISCONNECTED     = WLAN_ACM_EVENT_CODE_LOWEST + 3L;

// acm connection error code boundary
const unsigned long WLAN_ACM_ERROR_CODE_LOWEST      = wxID_HIGHEST + 0x0200;

// acm connection error code
const unsigned long WLAN_ACM_ERROR_SUCCESS              = WLAN_ACM_ERROR_CODE_LOWEST + 0L;
const unsigned long WLAN_ACM_ERROR_INVALID_HANDLE       = WLAN_ACM_ERROR_CODE_LOWEST + 1L;
const unsigned long WLAN_ACM_ERROR_INVALID_PROFILE      = WLAN_ACM_ERROR_CODE_LOWEST + 2L;
const unsigned long WLAN_ACM_ERROR_NO_INTERFACE         = WLAN_ACM_ERROR_CODE_LOWEST + 3L;
const unsigned long WLAN_ACM_ERROR_NOT_AUTHENTICATED    = WLAN_ACM_ERROR_CODE_LOWEST + 4L;
const unsigned long WLAN_ACM_ERROR_NO_RESPONSE          = WLAN_ACM_ERROR_CODE_LOWEST + 5L;
const unsigned long WLAN_ACM_ERROR_ADAPTER_ERROR        = WLAN_ACM_ERROR_CODE_LOWEST + 6L;
const unsigned long WLAN_ACM_ERROR_UNKNOWN              = WLAN_ACM_ERROR_CODE_LOWEST + 10L;

BEGIN_DECLARE_EVENT_TYPES()
DECLARE_EVENT_TYPE(EVT_WLAN_ACM, -1)
END_DECLARE_EVENT_TYPES()

class WlanAcmEvent : public wxEvent
{
    public:
        //ctor
        WlanAcmEvent(unsigned int id = 0, unsigned long code = 0, unsigned long error = WLAN_ACM_ERROR_SUCCESS);
        //dtor
        virtual ~WlanAcmEvent();
        //clone
        virtual wxEvent* Clone() const;
        //get event code
        virtual unsigned long GetEventCode() const;
        //get error code
        virtual unsigned long GetErrorCode() const;

    private:
        const int m_nCode;
        const unsigned long m_nError;
};

typedef void (wxEvtHandler::*wxWlanAcmEventFunction)(WlanAcmEvent&);

#define EVT_WLAN_ACM(id, fn) DECLARE_EVENT_TABLE_ENTRY( EVT_WLAN_ACM, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxWlanAcmEventFunction, & fn ), (wxObject *) NULL ),

#endif // _WLAN_ACM_EVENT_H
