/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WIRELESSSCANNER_H_INCLUDED
#define WIRELESSSCANNER_H_INCLUDED

#include "WlanScanner.h"
#if defined(__UNIX__)
#include <net/if.h>
#endif
#include <wx/timer.h>
#include "ScanEvent.h"
#include "ScanAPThread.h"
class SearchThread;
class WirelessScanner : public WlanScanner
{
    public:
        WirelessScanner();
        ~WirelessScanner();
        #if defined(__UNIX__)
        int ScanWireless();
        void GetInterface();
        int OpenSockets();
        int GetExt(int skfd,char* ifname,int request,struct iwreq* pwrq);
        void ParseFile(AccessPointList* pList);
        void ParseConfFile();
        void GetConnect(APStatus* ap);
        void GetIfname();
        void AllocateIP();
        bool IfConnect();
        struct ifconf ifc;
        char name[IFNAMSIZ];
        SearchThread *m_pThread;
        ScanAPThread* m_scanThread;
        bool UpdateCurrentAP(APStatus& apStatus);
        WlanResult ConnectWlanNetwork(const APStatus& ap, const wxString key = wxT(""),const wxString usingAdpterName = wxT(""));
        SearchThread* CreateSearchThread();
        AccessPointList* m_pAPList;
        void ScanOver(ScanEvent& event);
        #endif
        DECLARE_EVENT_TABLE()
};

#endif // WIRELESSSCANNER_H_INCLUDED
