/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "WirelessEvent.h"

DEFINE_EVENT_TYPE(wxEVT_WIRELESS)

WirelessSwitchEvent::WirelessSwitchEvent(unsigned long id)
        : wxEvent(id, wxEVT_WIRELESS)
{
    memset(&m_stOldSsid, 0, sizeof(WlanSsid));
    memset(&m_stNewSsid, 0, sizeof(WlanSsid));
}

WirelessSwitchEvent::WirelessSwitchEvent(const WirelessSwitchEvent& event)
        : wxEvent(event)
{
    memcpy(&m_stOldSsid, &event.m_stOldSsid, sizeof(WlanSsid));
    memcpy(&m_stNewSsid, &event.m_stNewSsid, sizeof(WlanSsid));
}

WirelessSwitchEvent::~WirelessSwitchEvent()
{
}

wxEvent* WirelessSwitchEvent::Clone() const
{
    return new WirelessSwitchEvent(*this);
}

void WirelessSwitchEvent::SetOldSsid(const WlanSsid& oldSsid)
{
    m_stOldSsid = oldSsid;
}

void WirelessSwitchEvent::SetNewSsid(const WlanSsid& newSsid)
{
    m_stNewSsid = newSsid;
}

WlanSsid WirelessSwitchEvent::GetOldSsid() const
{
    return m_stOldSsid;
}

WlanSsid WirelessSwitchEvent::GetNewSsid() const
{
    return m_stNewSsid;
}
