/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMApp.h"
#include "ViewAPNeighborsDlg.h"

#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/msgdlg.h>

#include "pic/neighbors.xpm"

#include "ENMUtil.h"
#include <fstream>
using namespace std;

const long ViewAPNeighborsDlg::ID_BUTTON_OKVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_LISTCTRL_VIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_BUTTON_REFRESHVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_BUTTON_CANCELVIEWAPNEIGHBORS = wxNewId();
const long ViewAPNeighborsDlg::ID_TIMER_VIEWNEIGHBOR = wxNewId();

const wxString g_path = ENMUtil::GetCurrentUserAppDataFolder();

BEGIN_EVENT_TABLE(ViewAPNeighborsDlg,wxDialog)
#if defined(__UNIX__)
    EVT_SCAN(ID_SCAN_OVER, ViewAPNeighborsDlg::ScanOver)
#endif
    EVT_BUTTON(ID_BUTTON_CANCELVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButtonCancelClick)
    EVT_BUTTON(ID_BUTTON_REFRESHVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButtonRefreshClick)
    EVT_BUTTON(ID_BUTTON_OKVIEWAPNEIGHBORS, ViewAPNeighborsDlg::OnButtonOKClick)
    EVT_INIT_DIALOG(ViewAPNeighborsDlg::OnInit)
    EVT_CLOSE(ViewAPNeighborsDlg::OnClose)
END_EVENT_TABLE()

ViewAPNeighborsDlg::ViewAPNeighborsDlg(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size)
        : wxDialog(), m_pGaugeDialog(NULL)
{
	Create(parent, wxID_ANY, _("Network Neighbors"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxCLOSE_BOX);

    int margin = 10;
	int width = 500, height = 380;
    SetClientSize(wxSize(width, height));

    wxBitmap image(::wxGetApp().strImagePath + _T("ViewNeighbors.png"), wxBITMAP_TYPE_PNG);
	wxSize btnSize(90, 30);
    wxSize listSize(width - margin * 2, height - image.GetHeight() - btnSize.GetHeight() - margin * 5);
    int x = margin, y = margin;
    m_bmpImage = new wxStaticBitmap(this, wxID_ANY, image, wxPoint(x, y), wxDefaultSize);
    x += image.GetWidth() + margin;
#if defined(__WXMSW__)
	new wxStaticText(this, wxID_ANY, _("View network neighbors here. Click \"Refresh\" to update network neighbors information..."), wxPoint(115,15), wxSize(379,45));
	new wxStaticText(this, wxID_ANY, _("Note: Neighbors can only be found when \"File and Printer Sharing\" service in Windows Firewall is enabled."), wxPoint(115,50), wxSize(379,45));
#endif
#if defined(__UNIX__)
	new wxStaticText(this, wxID_ANY, _("View network neighbors here. Click \"Refresh\" to update network neighbors information..."), wxPoint(x, y), wxSize(width - image.GetWidth() - 3 * margin, image.GetHeight()));
#endif
    x = margin;
    y = image.GetHeight() + margin * 2;
	m_listNeighbors = new wxListCtrl(this, ID_LISTCTRL_VIEWAPNEIGHBORS, wxPoint(x, y), listSize, wxLC_REPORT);
	x = 0;
	y += listSize.GetHeight() + margin;
	new wxStaticLine(this, wxID_ANY, wxPoint(x, y), wxSize(width,-1), wxLI_HORIZONTAL);

	x = margin;
	y += margin;
	m_btnRefresh = new wxButton(this, ID_BUTTON_REFRESHVIEWAPNEIGHBORS, _("&Refresh"), wxPoint(x, y), btnSize);

    x = width - (btnSize.GetWidth() + margin) * 2;
	m_btnCancel = new wxButton(this, ID_BUTTON_CANCELVIEWAPNEIGHBORS, _("&Cancel"), wxPoint(x, y), btnSize);
	x += btnSize.GetWidth() + margin;
	m_btnOk = new wxButton(this, ID_BUTTON_OKVIEWAPNEIGHBORS, _("&OK"), wxPoint(x, y), btnSize);

    wxIcon icon_neighbors(neighbors_xpm);
    SetIcon(icon_neighbors);

	wxListItem itemCol;
    itemCol.SetText(_("Hostname"));
    m_listNeighbors->InsertColumn(0, itemCol);
    m_listNeighbors->SetColumnWidth(0, listSize.GetWidth() / 2);
    itemCol.SetText(_("IP Address"));
    m_listNeighbors->InsertColumn(1, itemCol);
    m_listNeighbors->SetColumnWidth(1, listSize.GetWidth() / 2);

    m_iSearchCount = 1;
    m_apNeighborsInfo = NULL;
    m_pGaugeDialog = new GaugeDialog(this);
}

ViewAPNeighborsDlg::~ViewAPNeighborsDlg()
{
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}

void ViewAPNeighborsDlg::OnClose(wxCloseEvent& event)
{
//    if ( m_isSearching && event.CanVeto() )
//    {
//        event.Veto();
//    }
    m_iSearchCount++;
    event.Skip();
}

bool ViewAPNeighborsDlg::Show(bool show)
{
    if ( show )
    {
//        m_iSearchCount++;
    }
    else
    {
        m_pGaugeDialog->Show(false);
    }
    return wxDialog::Show(show);
}

void ViewAPNeighborsDlg::OnInit(wxInitDialogEvent& event)
{
    BeginSearchAPNeighbors();
}

void ViewAPNeighborsDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    Close();
}

#if defined(__UNIX__)
wxString ViewAPNeighborsDlg::ParseIPAddFile()
{
    ifstream in;
	string sPath = "/tmp/ip.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[MAX_HOST_NAME_LEN];

    wxString wxIP;
    int iLine = 1;
    while( in.getline(cFileBuf, sizeof(cFileBuf)) )
    {
        if ( 2 == iLine )
        {
            wxIP = wxString::FromUTF8(cFileBuf);
            if ( !wxIP.Contains(_T("failed to find")) )
            {
                wxIP.Trim(true);
                wxIP.Trim(false);
                wxIP = wxIP.Mid(wxIP.find_first_of(wxIP), wxIP.find(_T(" ")));
                in.close();
                return wxIP;
            }
            else
            {
                in.close();
                return _T("");
            }
        }
        iLine++;
    }
    return _T("");
}
#endif

void ViewAPNeighborsDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
    if ( !BeginSearchAPNeighbors() )
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), wxEmptyString, wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }
}

void ViewAPNeighborsDlg::OnButtonOKClick(wxCommandEvent& event)
{
    Close();
}

bool ViewAPNeighborsDlg::BeginSearchAPNeighbors()
{
    m_btnOk->Enable(false);
    m_btnRefresh->Enable(false);
    m_btnCancel->Enable(false);

    m_apNeighborsInfo = NULL;
    m_listNeighbors->DeleteAllItems();

    bool bRet = true;
    if( !m_pScanThread )
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }
    m_pScanThread = new ScanThread(this, m_iSearchCount);
    if ( bRet = (m_pScanThread->Create() == wxTHREAD_NO_ERROR) )
    {
        m_pGaugeDialog->SetProcessLabel(_("Searching for network neighbors..."));
        m_pGaugeDialog->Move(377, 270);
        m_pGaugeDialog->Show(true);
        m_pScanThread->Run();
        m_isSearching = true;
    }
    return bRet;
}

ViewAPNeighborsDlg::ScanThread::ScanThread(ViewAPNeighborsDlg* pViewAPNeighborsDlg, int searchIndex)
        : wxThread(), m_iSearchIndex(searchIndex)
{
    m_pViewAPNeighborsDlg = pViewAPNeighborsDlg;
}

ViewAPNeighborsDlg::ScanThread::~ScanThread()
{
}

void* ViewAPNeighborsDlg::ScanThread::Entry()
{
    AP_NEIGHBORS_INFO *ap_NeighborsInfo;
    int iCount = 0;
    ::wxMilliSleep(1000);

#if defined(__WXMSW__)
    wxString strTemp;
    struct hostent *host;
	struct in_addr *ptr;	// To retrieve the IP Address

    DWORD dwScope = RESOURCE_CONTEXT;
	NETRESOURCE *NetResource = NULL;
	HANDLE hEnum;
	WNetOpenEnum( dwScope, NULL, NULL, NULL, &hEnum );

	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,1),&wsaData);

	if ( hEnum )
	{
		DWORD Count = 0xFFFFFFFF;
		DWORD BufferSize = 2048;
		LPVOID Buffer = new char[2048];
		WNetEnumResource( hEnum, &Count, Buffer, &BufferSize );

		NetResource = (NETRESOURCE*)Buffer;

		ap_NeighborsInfo = new AP_NEIGHBORS_INFO[BufferSize/sizeof(NETRESOURCE)];

		for ( size_t i = 0; i < BufferSize/sizeof(NETRESOURCE); i++, NetResource++ )
		{
			if ( NetResource->dwUsage == RESOURCEUSAGE_CONTAINER && NetResource->dwType == RESOURCETYPE_ANY )
			{
				if ( NetResource->lpRemoteName )
				{
				    wcscpy(ap_NeighborsInfo[iCount].HostName, NetResource->lpRemoteName);

					for ( size_t j = 0; j < wcslen(ap_NeighborsInfo[iCount].HostName) - 2; j++ )
					{
					    ap_NeighborsInfo[iCount].HostName[j] = ap_NeighborsInfo[iCount].HostName[j + 2];
					}

					ap_NeighborsInfo[iCount].HostName[wcslen(ap_NeighborsInfo[iCount].HostName) - 2] = '\0';

					int iLength = wcstombs(NULL, ap_NeighborsInfo[iCount].HostName, 0);
                    char*  cBuffer  =  new  char[iLength+1];
                    wcstombs(cBuffer, ap_NeighborsInfo[iCount].HostName, iLength);
                    cBuffer[iLength] = 0;

					host = gethostbyname(cBuffer);

					if ( host != NULL )
					{
					    ptr = (struct in_addr *) host->h_addr_list[0];

                        int a = ptr->S_un.S_un_b.s_b1;  // Eg. 211.40.35.76 split up like this.
                        int b = ptr->S_un.S_un_b.s_b2;  //     40
                        int c = ptr->S_un.S_un_b.s_b3;  //     35
                        int d = ptr->S_un.S_un_b.s_b4;  //     76
                        ap_NeighborsInfo[iCount].IPAddress = wxString::Format(_T("%d.%d.%d.%d"),a,b,c,d);
					}

					iCount++;

					delete[] cBuffer;
				}
			}
		}
		delete Buffer;
		WNetCloseEnum( hEnum );
	}
	WSACleanup();

	m_pViewAPNeighborsDlg->UpdateApNeighborsInfo(ap_NeighborsInfo, iCount, m_iSearchIndex);
    delete[] ap_NeighborsInfo;
#endif
#if defined(__UNIX__)
	system("smbtree -N -S > /tmp/SmbtreeResult.txt");
    ifstream in;
	string sPath = "/tmp/SmbtreeResult.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[MAX_HOST_NAME_LEN];

    wxString wxIP;
    wxString wxHost;

    ap_NeighborsInfo = new AP_NEIGHBORS_INFO[100];

    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxHost = wxString::FromUTF8(cFileBuf);
        wxHost.Trim(true);
        wxHost.Trim(false);

        if ((int) wxHost.find(_T("\\\\")) >= 0)
        {
            if ((int) wxHost.find(_T(" ")) >= 0)
            {
                wxHost = wxHost.Mid(wxHost.find_first_of(wxHost), wxHost.find(_T(" ")));
            }

            wxHost = wxHost.Mid(wxHost.find(_T("\\")) + 2, wxHost.Len() - wxHost.find(_T("\\")) - 2);
            string s = ENMUtil::WxStringToString(wxHost);
            s = "nmblookup " + s + " > /tmp/ip.txt";
            system(s.c_str());
            wxIP = m_pViewAPNeighborsDlg->ParseIPAddFile();

            if ( wxIP != _T("NULL"))
            {
                ap_NeighborsInfo[iCount].IPAddress = wxIP;
            }
            const wxChar * temp = wxHost.c_str();
            wcscpy(ap_NeighborsInfo[iCount].HostName, temp);

            iCount++;
        }
    }
    in.close();

	m_pViewAPNeighborsDlg->UpdateApNeighborsInfo(ap_NeighborsInfo, iCount, m_iSearchIndex);
//    delete[] ap_NeighborsInfo;
#endif

	return NULL;
}

void ViewAPNeighborsDlg::ScanThread::OnExit()
{
}

void ViewAPNeighborsDlg::UpdateApNeighborsInfo(PAP_NEIGHBORS_INFO ap_NeighborsInfo, int iCount, int searchIndex)
{
    if ( searchIndex != m_iSearchCount )
        return;

    m_pGaugeDialog->Show(false);
    m_isSearching = false;
    if ( !this->IsShown() )
        return;

#if defined(__WXMSW__)
    if ( iCount > 0 )
    {
        wxString buf;
        for ( int i = 0; i < iCount; i++ )
        {
            buf.Printf(ap_NeighborsInfo[i].HostName);
            m_listNeighbors->InsertItem(i, buf);
            buf = ap_NeighborsInfo[i].IPAddress;
            //buf = _("192.168.1.1");
            m_listNeighbors->SetItem(i, 1, buf);
        }
    }
    else
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), wxEmptyString, wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }

    m_btnOk->Enable(true);
    m_btnRefresh->Enable(true);
    m_btnCancel->Enable(true);
#endif
#if defined(__UNIX__)
    m_pNeighborsInfo = ap_NeighborsInfo;
    m_count = iCount;
    ScanEvent event(ID_SCAN_OVER);
    event.index = searchIndex;
    ::wxPostEvent(this, event);
#endif
}

#if defined(__UNIX__)
void ViewAPNeighborsDlg::ScanOver(ScanEvent& event)
{
    if ( event.index != m_iSearchCount )
        return;

    m_pGaugeDialog->Show(false);
    if ( !this->IsShown() )
        return;

    if ( m_count > 0 )
    {
        wxString buf;
        for ( int i = 0; i < m_count; i++ )
        {
            buf.Printf(m_pNeighborsInfo[i].HostName);
            m_listNeighbors->InsertItem(i, buf);
            buf = m_pNeighborsInfo[i].IPAddress;
            //buf = _("192.168.1.1");
            m_listNeighbors->SetItem(i, 1, buf);
        }
    }
    else
    {
        wxMessageDialog dlg(this, _("Could not find any neighbors!"), wxEmptyString, wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
    }

    m_btnOk->Enable(true);
    m_btnRefresh->Enable(true);
    m_btnCancel->Enable(true);
    m_listNeighbors->SetFocus();
}
#endif
