/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "Profile.h"

bool operator == (const NetworkSecuritySet_t& s1, const NetworkSecuritySet_t& s2)
{
    bool result = true;
    result &= s1.sForbidShareFileAndPrint.Cmp(s2.sForbidShareFileAndPrint) == 0;
    result &= s1.sForbidShareInternet.Cmp(s2.sForbidShareInternet) == 0;
    result &= s1.sStartWindowFirewall.Cmp(s2.sStartWindowFirewall) == 0;
    return result;
}

bool operator == (const IPDNSSet_t& s1, const IPDNSSet_t& s2)
{
    bool result = true;
    result &= s1.IPvalue.Cmp(s2.IPvalue) == 0;
    result &= s1.SubnetAddress.Cmp(s2.SubnetAddress) == 0;
    result &= s1.NetGateway.Cmp(s2.NetGateway) == 0;
    result &= s1.DNSvalue.Cmp(s2.DNSvalue) == 0;
    return result;
}

bool operator == (const ProxySet_t& s1, const ProxySet_t& s2)
{
    bool result = true;
    result &= s1.Proxy.Cmp(s2.Proxy) == 0;
    result &= s1.Port.Cmp(s2.Port) == 0;
    return result;
}

bool operator == (const WEPSecurity_t& s1, const WEPSecurity_t& s2)
{
    bool result = true;
    result &= s1.value.Cmp(s2.value) == 0;
    result &= s1.keyIndex.Cmp(s2.keyIndex) == 0;
    return result;
}

bool operator == (const WPASecurity_t& s1, const WPASecurity_t& s2)
{
    bool result = true;
    result &= s1.value.Cmp(s2.value) == 0;
    return result;
}

bool operator == (const GenernalSettings_t& s1, const GenernalSettings_t& s2)
{
    bool result = true;
    result &= s1.ConnecType.Cmp(s2.ConnecType) == 0;
    return result;
}

bool operator == (const WirelessSettings_t& s1, const WirelessSettings_t& s2)
{
    bool result = true;
    result &= s1.SSID.Cmp(s2.SSID) == 0;
    result &= s1.WirelessType.Cmp(s2.WirelessType) == 0;
    result &= s1.WlanSecurity.Cmp(s2.WlanSecurity) == 0;
    result &= s1.stWPASecurity == s2.stWPASecurity;
    result &= s1.stWEPSecurity == s2.stWEPSecurity;
    return result;
}

bool operator == (const OtherSettings_t& s1, const OtherSettings_t& s2)
{
    bool result = true;
    result &= s1.NetworkSecurity.Cmp(s2.NetworkSecurity) == 0;
    result &= s1.AutoRunAppFlag.Cmp(s2.AutoRunAppFlag) == 0;
    result &= s1.AutoRunApp == s2.AutoRunApp;
    result &= s1.IPDNSFlag.Cmp(s2.IPDNSFlag) == 0;
    result &= s1.IsHomepage.Cmp(s2.IsHomepage) == 0;
    result &= s1.Homepage.Cmp(s2.Homepage) == 0;
    result &= s1.ProxyFlag.Cmp(s2.ProxyFlag) == 0;
    result &= s1.stNetSecurity == s2.stNetSecurity;
    result &= s1.stIPDNSSet == s2.stIPDNSSet;
    result &= s1.stProxySet == s2.stProxySet;
    return result;
}

bool operator == (const ProfileList_t& pf1, const ProfileList_t& pf2)
{
    bool result = true;
    result &= pf1.sProfileName.Cmp(pf2.sProfileName) == 0;
    result &= pf1.sPermission.Cmp(pf2.sPermission) == 0;
    result &= pf1.sPriority.Cmp(pf2.sPriority) == 0;
    result &= pf1.sProfileIcon.Cmp(pf2.sProfileIcon) == 0;
    result &= pf1.sShow.Cmp(pf2.sShow) == 0;
    result &= pf1.stGenernalSet == pf2.stGenernalSet;
    result &= pf1.stWirelessSet == pf2.stWirelessSet;
    result &= pf1.stOtherSet == pf2.stOtherSet;
    return result;
}

bool operator != (const ProfileList_t& pf1, const ProfileList_t& pf2)
{
    return !(pf1 == pf2);
}
