/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "NetSecrityDlg.h"
#include "ENMApp.h"

#include <wx/intl.h>
#include <wx/string.h>
#if defined(__WXMSW__)
#include "ENMUtil.h"
#endif

const long NetSecrityDlg::ID_CBINTERNET = wxNewId();
const long NetSecrityDlg::ID_BTNOK = wxNewId();
const long NetSecrityDlg::ID_BTNCANCEL = wxNewId();
#if defined(__WXMSW__)
const long NetSecrityDlg::ID_CBFILE = wxNewId();
const long NetSecrityDlg::ID_CBFIREWALL = wxNewId();
#endif

BEGIN_EVENT_TABLE(NetSecrityDlg,wxDialog)
    EVT_BUTTON(ID_BTNOK, NetSecrityDlg::Onm_btnOKClick)
    EVT_BUTTON(ID_BTNCANCEL, NetSecrityDlg::Onm_btnCancelClick)
    EVT_INIT_DIALOG(NetSecrityDlg::OnInit)
#if defined(__WXMSW__)
	EVT_CHECKBOX(ID_CBFILE, NetSecrityDlg::OnCheckboxFileClicked)
	EVT_CHECKBOX(ID_CBFIREWALL, NetSecrityDlg::OnCheckboxFirewallClicked)
#endif
END_EVENT_TABLE()

NetSecrityDlg::NetSecrityDlg(wxWindow* parent, wxWindowID id)
        : wxDialog(parent, id, _("Network Security"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE)
{
#if defined(__WXMSW__)
	SetClientSize(wxSize(340,137));
	Move(wxDefaultPosition);
	m_cbFile = new wxCheckBox(this, ID_CBFILE, _("Forbid sharing files and printer"), wxPoint(10,10), wxSize(320,25));
	m_cbFile->SetValue(false);

	m_cbInternet = new wxCheckBox(this, ID_CBINTERNET, _("Forbid sharing Internet connection"), wxPoint(10,40), wxSize(320,25));
	m_cbInternet->SetValue(false);

	m_cbFirewall = new wxCheckBox(this, ID_CBFIREWALL, _("Startup Windows firewall"), wxPoint(10,70), wxSize(320,25));
	m_cbFirewall->SetValue(false);
	m_btnOK = new wxButton(this, ID_BTNOK, _("OK"), wxPoint(150,100), wxSize(85,27));
	m_btnCancel = new wxButton(this, ID_BTNCANCEL, _("Cancel"), wxPoint(245,100), wxSize(85,27));
#endif
#if defined(__UNIX__)
    int width = 400;
    int height = 95;
    int margin = 10;
    SetClientSize(wxSize(width, height));
	Move(wxDefaultPosition);
	m_cbInternet = new wxCheckBox(this, ID_CBINTERNET, _("Forbid sharing Internet connection"), wxPoint(margin, margin), wxSize(width - 2 * margin, 25), wxALIGN_CENTER_VERTICAL);
	m_cbInternet->SetValue(false);

	wxSize buttonSize(80, 30);
	int x = width - (buttonSize.GetWidth() + margin) * 2;
	int y = height - buttonSize.GetHeight() - margin;
	m_btnCancel = new wxButton(this, ID_BTNCANCEL, _("Cancel"), wxPoint(x, y), buttonSize);
	x += buttonSize.GetWidth() + margin;
	m_btnOK = new wxButton(this, ID_BTNOK, _("OK"), wxPoint(x, y), buttonSize);
#endif
    m_btnOK->SetDefault();
}

NetSecrityDlg::~NetSecrityDlg()
{
}

NetworkSecuritySet_t NetSecrityDlg::GetNetworkSecuritySetting() const
{
    return m_security;
}

void NetSecrityDlg::SetNetworkSecuritySetting(const NetworkSecuritySet_t& set)
{
    m_security = set;
}


void NetSecrityDlg::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_cbInternet->SetFocus();
}

void NetSecrityDlg::Onm_btnOKClick(wxCommandEvent& event)
{
    EndModal(wxID_OK);
}

void NetSecrityDlg::Onm_btnCancelClick(wxCommandEvent& event)
{
    EndModal(wxID_CANCEL);
}

#if defined(__WXMSW__)
void NetSecrityDlg::OnCheckboxFileClicked(wxCommandEvent& event)
{
    if ( m_cbFile->IsChecked() )
    {
        m_cbFirewall->SetValue(true);
    }
}

void NetSecrityDlg::OnCheckboxFirewallClicked(wxCommandEvent& event)
{
    if ( !m_cbFirewall->IsChecked() )
    {
        m_cbFile->SetValue(false);
    }
}
#endif
