/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "FileTar.h"

const long FileTar::SIGNATURE = 0x4B4350CCL;

FileTar::FileTar()
{
    //ctor
    for (int i = 0; i < _MAX_PATH; i++)
    {
        FilePath[i] = -1;
    }
}

FileTar::~FileTar()
{
    //dtor
    for ( int i=1; i <= m_TarHeader.GetCount(); i++ )
	{
	    if ( NULL != m_pTarIndex[i] )
        {
            delete m_pTarIndex[i];
            m_pTarIndex[i] = NULL;
        }
	}
}

bool FileTar::TarHeader::SetDescription(const wxString& strdesc)
{
    if (strdesc.Len() > 511)
	{
        return false;
	}
	for ( size_t n = 0; n <= strdesc.Len(); n++ )
	{
	    TarDescription[n] = strdesc[n];
	}
	return true;
}

wxString FileTar::TarHeader::GetDescription()
{
	wxString wxDescription;

    for (int i = 0; i < _MAX_PATH; i++)
    {
        if (TarDescription[i] == 0) break;
        wxChar ss = TarDescription[i];
        wxDescription.Append(ss);

    }
	return wxDescription;
}

int FileTar::TarHeader::GetCount()
{
	return FileCount;
}

int FileTar::TarHeader::IncrementCount()
{
	if (FileCount < TAR_MAX_FILES)
		return ++FileCount;
	else
		return 0;
}

FileTar::TarHeader::TarHeader()
{
	FileCount = 0;
	for (int i = 0; i < 512; i++)
	{
	    TarDescription[i] = -1;
	}
}


void FileTar::SetFilePath(const wxString& path)
{
    for ( size_t n = 0; n <= path.Len(); n++ )
	{
	    FilePath[n] = path[n];
	}
}

int FileTar::AddFile(const wxString& fname, const wxString& desc)
{
    wxString fullpath;

    for (int i = 0; i < _MAX_PATH; i++)
    {
        if (FilePath[i] == 0) break;
        wxChar ss = FilePath[i];
        fullpath.Append(ss);

    }

    fullpath.Append(fname);

	long size;
	/*get the filesize*/
	wxFile myFile(fullpath);
	if (!myFile.IsOpened())
	{
	    return 1;
    }

	size = (long)myFile.Length();

	/*update filecount*/
	if(m_TarHeader.IncrementCount()==0)
	{
		myFile.Close();
		return 1;
	}
	/*save the file attribute*/
	TarIndex *pTarIndex = new TarIndex;
	for ( size_t n = 0; n <= fname.Len(); n++ )
	{
	    pTarIndex->FileName[n] = fname[n];
	}
	for ( size_t n = 0; n <= desc.Len(); n++ )
	{
	    pTarIndex->Description[n] = desc[n];
	}
	pTarIndex->Size = size;

	m_pTarIndex[m_TarHeader.GetCount()] = pTarIndex;
    myFile.Close();


	return 0;
}

int FileTar::CreateTar(const wxString& TarFName, const wxString& TarPath)
{
	wxString tarfullpath;
	if (TarPath.IsEmpty())
	{
	    for (int i = 0; i < _MAX_PATH; i++)
        {
            if (FilePath[i] == 0) break;
            wxChar ss = FilePath[i];
            tarfullpath.Append(ss);

        }
	    //tarfullpath.Append((wxChar)FilePath);
    }
    else
    {
        tarfullpath = TarPath;
    }

	tarfullpath += TarFName;

	int ret;
	int i;

    wxFile outFile(tarfullpath, wxFile::write );
    if (!outFile.IsOpened())
	{
	    return 1;
    }

	/*write the tarfile header*/
	outFile.Write(&SIGNATURE, sizeof(long));
    ret = outFile.Write(&m_TarHeader, sizeof(TarHeader));
	int ssize = m_TarHeader.GetCount()*sizeof (TarIndex) + sizeof(TarHeader) + sizeof(long);

	for (i = 1; i <= m_TarHeader.GetCount(); i++)
	{
		m_pTarIndex[i]->Start=ssize;

        ret = outFile.Write(m_pTarIndex[i], sizeof(TarIndex));
		ssize += m_pTarIndex[i]->Size;
	}


	/*write every file content to tarfile*/
	for (i = 1; i <= m_TarHeader.GetCount(); i++)
	{
	    wxString filetoadd;
	    for ( int j = 0; j < _MAX_PATH; j++)
        {
            if (FilePath[j] == 0) break;
            wxChar ss = FilePath[j];
            filetoadd.Append(ss);

        }
	    //filetoadd.Append((wxChar)FilePath);
	    for (int j = 0; j < _MAX_FNAME; j++)
        {
            if (m_pTarIndex[i]->FileName[j] == 0) break;
            wxChar ss = m_pTarIndex[i]->FileName[j];
            filetoadd.Append(ss);

        }
	    //filetoadd.Append((wxChar)m_pTarIndex[i]->FileName);

        wxFile inFile(filetoadd);
        if (!inFile.IsOpened())
        {
            return 1;
        }
        /*copy file*/
        size_t size = m_pTarIndex[i]->Size;
        while (size > 0)
        {
            NNChar buffer[NBUFFSIZE];
            long toread = size > sizeof(buffer) ? sizeof(buffer) : size;
            inFile.Read(buffer,toread);
            outFile.Write(buffer, toread);
            size -= toread;
        }

        inFile.Close();

	}
    outFile.Close();
	return 0;
}

wxString FileTar::GetHeaderDescription()
{
	return m_TarHeader.GetDescription();
}

bool FileTar::SetHeaderDescription(const wxString& strdesc)
{
	return m_TarHeader.SetDescription(strdesc);
}

int FileTar::GetTarInfo(const wxString& TarFile, TarHeader *pTarHeader)
{
    wxFile inFile(TarFile);
    if ( !inFile.IsOpened() )
	{
	    return 1;
    }

	// read signature
	long lTemp;
	inFile.Read(&lTemp, sizeof(lTemp));
	if ( lTemp != SIGNATURE )
	{
		inFile.Close();
		return 1;
	}

	memset(pTarHeader, 0, sizeof(TarHeader));
	inFile.Read(pTarHeader, sizeof(TarHeader));
    inFile.Close();
	return 0;
}

int FileTar::GetFileInfo(const wxString& TarFile, TarIndex *pTarIndex, int index)
{
    wxFile inFile(TarFile);
    if (!inFile.IsOpened())
	{
	    return 1;
    }
	long lTemp;
	inFile.Read(&lTemp, sizeof(long));

    TarHeader tmpTarHeader;
    size_t toread = inFile.Read(&tmpTarHeader, sizeof(TarHeader));
    if (toread < sizeof(TarHeader))
    {
        return 1;
    }

	for (int i = 1; i <= tmpTarHeader.GetCount(); i++)
	{
        inFile.Read(pTarIndex, sizeof(TarIndex));
		if(i==index)
			break;
	}

	inFile.Close();
	return 0;

}

int FileTar::UnTar(const wxString& TarFile, int index, const wxString& fpath,
                    const long fstart, const long fsize)
{
    wxFile inFile(TarFile);
    if (!inFile.IsOpened())
	{
	    return 1;
    }

    wxFile outFile;
    outFile.Create(fpath, true);
    if (!outFile.Open(fpath, wxFile::write))
	{
	    return 1;
    }

	/*seek the starpos of file to read the content of file[index]*/
	inFile.Seek(fstart);
	/*copy file*/
	long rem = fsize;
	NNChar buff[NBUFFSIZE];
	while (rem > NBUFFSIZE)
	{
		inFile.Read(buff, NBUFFSIZE);
        outFile.Write(buff, NBUFFSIZE);
		rem -= NBUFFSIZE;
	}

	if (rem > 0)
	{
	    inFile.Read(buff, rem);
	    outFile.Write(buff, rem);
	}
    inFile.Close();
    outFile.Close();
	return 0;
}

int FileTar::UnTar(const wxString& TarFile, const wxString& dpath)
{
	TarHeader th;
	if (GetTarInfo(TarFile,&th))
	{
	    return 1;
	}

	TarIndex ti;
	wxString fpath;
	/*untar every file in tarfile*/
	for (int i = 1; i <= th.GetCount(); i++)
	{
		if (GetFileInfo(TarFile,&ti,i))
		{
		    return 1;
		}

		fpath = dpath;
		for (int j = 0; j < _MAX_FNAME; j++)
		{
            if (ti.FileName[j] == 0) break;
            wxChar ss = ti.FileName[j];
		    fpath.Append(ss);
        }

		if (1 == UnTar(TarFile, i, fpath, ti.Start, ti.Size))
		{
//		    continue;
		    return 1;
		}

	}

	return 0;
}
