/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_POPUP_MENU_H
#define _ENM_POPUP_MENU_H

#include <wx/menu.h>

class ENMPopupMenu : public wxMenu
{
    public:
        ENMPopupMenu();
        virtual ~ENMPopupMenu();

    private:
        const int id;
        wxBitmap m_bmpCheck;
        wxBitmap m_bmpEmpty;

        wxMenuItem* m_pmiHelp;
        wxMenuItem* m_pmiManage;
        wxMenuItem* m_pmiScan;
        wxMenuItem* m_pmiProfile;

        static const int ID_MENU_ITEM_HELP;
        static const int ID_MENU_ITEM_MANAGE;
        static const int ID_MENU_ITEM_SCAN;
        static const int ID_MENU_ITEM_PROFILE;
        static const int ID_MENU_ITEM_PROFILE_MIN;
        static const int MENU_ITEM_PROFILE_MARGIN_WIDTH;
        static const int MENU_ITEM_MARGIN_WIDTH;

        static const wxBitmap BITMAP_MENU_ITEM_HELP;
        static const wxBitmap BITMAP_MENU_ITEM_MANAGE;
        static const wxBitmap BITMAP_MENU_ITEM_SCAN;
        static const wxBitmap BITMAP_MENU_ITEM_PROFILE;

        void InitMenu();
        void LoadProfileMenuItems();

        void OnMenuItemHelpClicked(wxCommandEvent& event);
        void OnMenuItemManageClicked(wxCommandEvent& event);
        void OnMenuItemScanClicked(wxCommandEvent& event);
        void OnMenuItemProfileClicked(wxCommandEvent& event);

};

#endif // _ENM_POPUP_MENU_H
