/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMPopupMenu.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "ENMApp.h"
#include "DataCenter.h"
#include "ProfileManagementControl.h"
#include "ENMUtil.h"
#include "PolicyManager.h"

#if defined(__WXMSW__)
static wxString logFile(_T("C:\\ENMPopupMenu.log"));
#else
static wxString logFile(_T("/tmp/ENMPopupMenu.log"));
#endif

const int ENMPopupMenu::ID_MENU_ITEM_HELP       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_MANAGE     = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_SCAN       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE    = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE_MIN = ENMPopupMenu::ID_MENU_ITEM_PROFILE + 1;
const int ENMPopupMenu::MENU_ITEM_PROFILE_MARGIN_WIDTH  = 24;
const int ENMPopupMenu::MENU_ITEM_MARGIN_WIDTH  = 32;

ENMPopupMenu::ENMPopupMenu() : wxMenu(), id(::wxNewId())
{
    m_bmpCheck.LoadFile(::wxGetApp().strImagePath + _T("tick.png"), wxBITMAP_TYPE_PNG);
    m_bmpEmpty.LoadFile(::wxGetApp().strImagePath + _T("empty.png"), wxBITMAP_TYPE_PNG);

    InitMenu();
}

ENMPopupMenu::~ENMPopupMenu()
{
}

void ENMPopupMenu::InitMenu()
{
    LoadProfileMenuItems();

    this->AppendSeparator();

    m_pmiScan = new wxMenuItem(this, ID_MENU_ITEM_SCAN, _("Scan for Networks"));
    m_pmiScan->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("icon_scan.png"))));
#if defined(__WXMSW__)
    m_pmiScan->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_SCAN, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemScanClicked);
    this->Append(m_pmiScan);
    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    m_pmiScan->Enable(networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT);

    m_pmiManage = new wxMenuItem(this, ID_MENU_ITEM_MANAGE, _("Manage Network"));
    m_pmiManage->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("icon_manage.png"))));
#if defined(__WXMSW__)
    m_pmiManage->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_MANAGE, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemManageClicked);
    this->Append(m_pmiManage);

    this->AppendSeparator();

    m_pmiHelp = new wxMenuItem(this, ID_MENU_ITEM_HELP, _("Help..."));
    m_pmiHelp->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("icon_help.png"))));
#if defined(__WXMSW__)
    m_pmiHelp->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_HELP, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemHelpClicked);
    this->Append(m_pmiHelp);
}

void ENMPopupMenu::LoadProfileMenuItems()
{
    ENMUtil::Log(logFile, _T("Enter ENMPopupMenu::LoadProfileMenuItems"));
    m_pmiProfile = new wxMenuItem(this, ID_MENU_ITEM_PROFILE, _("Connect to Profile"));
    m_pmiProfile->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("icon_pro.png"))));
#if defined(__WXMSW__)
    m_pmiProfile->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    ENMUtil::Log(logFile, _T("\t Menu \"Connect to Profile\" created successfully."));

    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
    wxString _cpName = cp.sProfileName;
    ENMUtil::Log(logFile, _T("\t Get current profile: ") + _cpName);
    vector<ProfileList_t> profileVector;
    bool hasSubMenu = false;
    if ( pController->GetUserProfiles(profileVector, ENMUtil::IsAdministrator(), true) && profileVector.size() > 0 )
    {
//        wxString log = wxString::Format(wxT("ENMPopupMenu::LoadProfileMenuItems\n\tLoad %d profiles."), profileVector.size());
//        ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), log);
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow == _T("1") )
                hasSubMenu = true;
        }
    }
    if ( hasSubMenu )
    {
        wxMenu* profileSubMenu = new wxMenu();
        wxMenu* pEventSource = this;
#if defined(__UNIX__)
        pEventSource = profileSubMenu;
#endif
        ENMUtil::Log(logFile, wxString::Format(_T("\t Get %d profiles"), profileVector.size()));
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow != _T("1") )
                continue;

            wxString profileName = profile.sProfileName;
            profileName.Replace(_T("&"), _T("&&"));
            int id = ID_MENU_ITEM_PROFILE_MIN + i;
            wxMenuItem* pItem = new wxMenuItem(profileSubMenu, id, profileName, _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
            pItem->SetMarginWidth(MENU_ITEM_PROFILE_MARGIN_WIDTH);
#endif
            ENMUtil::Log(logFile, _T("\t Create menu item ") + profileName);
            if ( profile.sProfileName == cp.sProfileName && profile.sPermission == cp.sPermission )
                pItem->SetBitmap(m_bmpCheck);
            else
                pItem->SetBitmap(m_bmpEmpty);
            pEventSource->Connect(id, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemProfileClicked);
            profileSubMenu->Append(pItem);
            ENMUtil::Log(logFile, _T("\t Append menu item ") + profileName);
        }
        ENMUtil::Log(logFile, _T("\t Append menu item \"Connect to Profile\""));
        m_pmiProfile->SetSubMenu(profileSubMenu);
//        m_pmiProfile = this->AppendSubMenu(profileSubMenu, _("Connect to Profile"));
    }
    this->Append(m_pmiProfile);
    if ( !hasSubMenu )
    {
        ENMUtil::Log(logFile, _T("\t No profile"));
        m_pmiProfile->Enable(false);
    }
    ENMUtil::Log(logFile, _T("Return ENMPopupMenu::LoadProfileMenuItems\n"));
}

void ENMPopupMenu::OnMenuItemHelpClicked(wxCommandEvent& event)
{
    ENMUtil::ShowContextHelp(NULL, _T("Main"));
}

void ENMPopupMenu::OnMenuItemManageClicked(wxCommandEvent& event)
{
    NetworkManagerDlg* networkManagerDlg = DataCenter::GetInstance()->GetNetworkManagerDlgHandle();
    if ( NULL == networkManagerDlg )
    {
        return;
    }
//    networkManagerDlg->SetNetworkProfile();
    networkManagerDlg->Iconize(false);
    networkManagerDlg->Show();
    networkManagerDlg->Raise();
}

void ENMPopupMenu::OnMenuItemScanClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids scanning for wireless networks."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( scanNetworkDlg->IsShown() )
    {
        scanNetworkDlg->CloseDialog(wxID_CANCEL);
    }
    scanNetworkDlg->SetDialogMode(true);
    scanNetworkDlg->Iconize(false);
    scanNetworkDlg->Show();
    scanNetworkDlg->Raise();
}

void ENMPopupMenu::OnMenuItemProfileClicked(wxCommandEvent& event)
{
    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( scanNetworkDlg->IsShown() )
    {
        return;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    int id = event.GetId();
    wxMenu* pMenu = static_cast<wxMenu*>(event.GetEventObject());
    wxMenuItem* pItem = pMenu->FindItem(id);
    wxString profileName = pItem->GetItemLabel();
    ProfileList_t* pProfile;
    pProfile = DataCenter::GetInstance()->GetProfileController()->GetProfile(id - ID_MENU_ITEM_PROFILE_MIN);
    if ( pProfile == NULL )
        return;
    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->ShowApplyingProcessDialog(profileName, true);
    DataCenter::GetInstance()->GetProfileController()->ApplyProfile(*pProfile);
}
