/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef DATACENTERLINUX_H
#define DATACENTERLINUX_H

#include "DataCenter.h"
#include "WlanScanner.h"
#include <wx/textfile.h>
class WirelessScanner;
void CALLBACK LanChangeCallBack(BOOL* LanChanged);
void CALLBACK WlanChangeCallBack(BOOL* WlanChanged);
void CALLBACK DisableAdapterCallBack(BOOL* DisableAdapter);
class DataCenterLinux : public DataCenter
{
public:
    DataCenterLinux();
    ~DataCenterLinux();
    void InitData();
    bool EnableNetworkAdapter(ADAPTER_TYPE adapterType,bool bEnable);
    NETWORK_MODE GetCurrentNetworkMode();
    const AccessPointList& GetAPList();
    const APStatus* GetAPStatusFromList(size_t iIndex);
    WlanResult BeginSearchAP();
    void UpdateCurrentAP(const  WlanSsid* pSsid, bool connected);
    WlanResult ConnectWlanNetwork(const APStatus& apStatus, wxString key, int keyIdx = 0, bool applyProfile = false);
    bool IsWirelessConnected();
    APStatus* GetCurrentAPStatus() { return m_pAPStatus ; }
    bool CloseWlanConnection(bool ifScanDlg = false) ;
    void StartGlobalTimer();
    void StopGlobalTimer();
    wxArrayString GetNetworkAdapterName(ADAPTER_TYPE adapterType);
    wxString GetUsingAdapterName(ADAPTER_TYPE adapterType);
    bool IsWiredInterfaceConnected();
    WlanScanner* GetScanner();
    wxString GetConnectTypeHLAN();
	bool IsInterfaceEnabled(ADAPTER_TYPE adapterType);
	void SwitchAdapterParameter(ADAPTER_TYPE adapterTypeDown, ADAPTER_TYPE adapterTypeUp, wxEvtHandler* handler = NULL);
	void GetCurAPParameter();
	void SetShowBalloonFlag(bool isShown);
    void SetAutoWirelessFlag(bool m_isAutoWireless);
private:
    void ReadNetworkStatus();
    void DestroyData();
    void CreateNetTools();

    void OnReadNetworkStatusTimer(wxTimerEvent& event);
    void OnScanTimer(wxTimerEvent& event);
    void OnAllocatorTimer(wxTimerEvent& event);
    void OnWpaTimer(wxTimerEvent& event);
    void OnSusPendTimer(wxTimerEvent& event);
    void OnSwitchUserTimer(wxTimerEvent& event);
    void OnStartTimerAfterResume(wxTimerEvent& event);
    void SetCurrentNetworkMode(NETWORK_INFO& networkInfo);

    bool ShutdownInterface(ADAPTER_TYPE adapterType);
    bool DisableAllAdapters();
    bool EnableConnection(wxString wszName, bool bEnable);
    bool ParseWpaFile();
//    wxString GetIPAddressHLAN();
//    wxString GetConnectTypeHLAN();
    bool StartupInterface(ADAPTER_TYPE adapterType);
    void SearchAP(ScanEvent& event);

    string StartupInterface(const wxArrayString& interfaceList);
    bool ShutdownInterface(const wxArrayString& interfaceList);
    UI_NETWORK_STATUS_INFO GetWirelessedUIInfo(APStatus& apStatus);
    UI_NETWORK_STATUS_INFO GetWiredUIInfo( NETWORK_WIRED_STATUS_INFO& wiredStatus);

    int OpenSockets();
    void GetNetInfo();
//    bool IfWiredUp();
//    bool IfWiredLink();
//    bool IfWirelessUp();
//    bool IfWirelessLink();
    bool IfUp(ADAPTER_TYPE adapterType);
    bool IfLink(ADAPTER_TYPE adapterType, string adapterName = "");

    bool IfConnect();
    void SetSsid(APStatus& apStatus);
    wxArrayString GetInterface(int i);

    string GetIPAddressHLAN(const string adapterName, const string userPath);
    string GetConnectTypeHLAN(const string adapterName, const string userPath);

    wxArrayString m_asWiredInterface;
    wxArrayString m_asWirelessInterface;
    string m_UsingWiredAdpterName;
    string m_UsingWirelessAdpterName;
    wxString m_BitRate;
    int times;

    bool m_LanIsEnable;
    bool m_WlanIsEnable;

//    wxTextFile outputFile(_T("/tmp/syspend.out"));
//    wxTextFile tf(_T("/var/log/pm-suspend.log"));
//    wxTextFile outputFile;
    wxString m_resumeTime;
    wxString m_suspendTime;
    wxString m_prepareSuspendTime;
    wxString m_activeUser;
    bool m_switchUser;
    bool m_postEvent;

private:
    static const long ID_TIMER_READNETWORKSTATUS;
    static const long ID_TIMER_SCAN;
    static const long ID_TIMER_ALLOCATE;
    static const long ID_TIMER_WPA;
    static const long ID_TIMER_SUSPEND;
    static const long ID_TIMER_SWITCHUSER;
    static const long ID_TIMER_STARTTIMERAFTERRESUME;

    static const long ID_TIMER_WAITFORRESUME;
    wxTimer m_WaitForResume;
    void OnWaitForResume(wxTimerEvent& event);
    int m_iWaitForResume;

    friend void CALLBACK LanChangeCallBack(BOOL* LanChanged);
    friend void CALLBACK WlanChangeCallBack(BOOL* WlanChanged);
    friend void CALLBACK DisableAdapterCallBack(BOOL* DisableAdapter);

    WirelessScanner* m_pLinuxWlanScanner;
    WlanSsid* m_pSsid;
    NETWORK_WIRED_STATUS_INFO* m_pCurrentWiredStatus;
    APStatus* m_pAPStatus;
    NETWORK_INFO* m_pNetworkInfo;
    wxTimer m_NetStatusTimer,m_ScanTimer, m_AlllcatorTimer, m_WpaTimer, m_SuspendTimer, m_SwitchTimer, m_StartTimerAfterResume;
    int m_killDhclientCount;
    NETWORK_MODE m_CurrentNetworkMode,m_LastNetworkMode;
    AccessPointList m_apList;
    bool m_isApplyProfile;
    ENM_ConnectAP m_connectInfo;
    class SwitchAdapterThread : public wxThread
    {
        public:
            typedef struct _SwitchAdapter
            {
                ADAPTER_TYPE adapterTypeDown;
                ADAPTER_TYPE adapterTypeUp;
                wxEvtHandler* handler;
            } SwitchAdapter, *PSwitchAdapter;

            SwitchAdapterThread(DataCenterLinux* pDataCenterLinux);
            virtual ~SwitchAdapterThread();
            virtual void* Entry();
            virtual void OnExit();
            vector<SwitchAdapter> m_vParameter;
            DataCenterLinux* m_DataCenterLinux;

            bool m_continueFlag;
    };
    SwitchAdapterThread* m_pSwitchAdapterThread;

    class GetCurAPThread : public wxThread
    {
        public:
            GetCurAPThread(DataCenterLinux* pDataCenterLinux);
            virtual ~GetCurAPThread();
            virtual void* Entry();
            virtual void OnExit();
            vector<int> m_vGetAP;
            DataCenterLinux* m_DataCenterLinuxForGetAP;

            bool m_getFlag;
    };

    GetCurAPThread* m_pGetCurAPThread;

    class ConnectAPThread : public wxThread
    {
        public:
            ConnectAPThread(DataCenterLinux* pDataCenterLinux);
            virtual ~ConnectAPThread();
            virtual void* Entry();
            virtual void OnExit();
            DataCenterLinux* m_DataCenterLinuxForConAP;

    };

    class ScanThread : public wxThread
    {
        public:
            ScanThread(DataCenterLinux* pDataCenterLinux);
            virtual ~ScanThread();
            virtual void* Entry();
            virtual void OnExit();
            DataCenterLinux* m_DataCenterLinuxForScanAP;
    };
    ScanThread* m_pScanThread;

    bool m_isShowWiredLANDlg;
    bool m_isShowWirelessLANDlg;
    bool m_isShowWirelessOnOffDlg;
    int m_VerifyWiredConnected;
    bool m_isAutoWireless;
    bool m_isNetworkDlgTurnWireless;
    DECLARE_EVENT_TABLE()

};

#endif // DATACENTERLINUX_H
