/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _DATA_CENTER_H
#define _DATA_CENTER_H

#include <wx/event.h>
#include "WlanScanner.h"

#include "net.h"

class ScanNetworkDlg;
class ShareMyInternetDlg;
class UseOtherInternetDlg;
class NetworkManagerDlg;
class ProfileManagerDlg;
class ProfileManagementControl;
class PolicyManager;

class DataCenter : public wxEvtHandler
{
public:
    //destructor
    virtual ~DataCenter();
    //get instance of data center
    static DataCenter* GetInstance();
    //initialize data
    virtual void InitData();
    //reload school policy
    virtual void ReloadSchoolPolicy();
    //get scannetworkdlg handle
    virtual ScanNetworkDlg* GetScanNetworkDlgHandle() { return m_pScanNetworkDlg; }
    //get networkmanagerdlg handle
    virtual NetworkManagerDlg* GetNetworkManagerDlgHandle(){ return m_pNetworkManagerDlg; }
    //get profilemanagerdlg handle
    virtual ProfileManagerDlg* GetProfileManagerDlgHandle(){ return m_pProfileManagerDlg; }
    //get profile controller
    virtual ProfileManagementControl* GetProfileController() { return m_pProfileController; }
    //get policy manager
    virtual PolicyManager* GetPolicyManager() { return m_pPolicyManager; }
    //lock session
    virtual void SessionLock();
    //unlock session
    virtual void SessionUnlock(bool disconnect);
    //enable network adapter
    virtual bool EnableNetworkAdapter(ADAPTER_TYPE adapterType, bool bEnable) = 0;
    //get current network mode
    virtual NETWORK_MODE GetCurrentNetworkMode() = 0;
    //get AP list
    virtual const AccessPointList& GetAPList() = 0;
    //get AP status from list
    virtual const APStatus* GetAPStatusFromList(size_t iIndex) = 0;
    //begin search AP
    virtual WlanResult BeginSearchAP() = 0 ;
    //update current AP
    virtual void UpdateCurrentAP(const WlanSsid* pSsid, bool connected) = 0;
    //connect AP
    virtual WlanResult ConnectWlanNetwork(const APStatus& apStatus, wxString key, int keyIdx = 0, bool applyProfile = false) = 0;
    //judging whether wireless connect or not
    virtual bool IsWirelessConnected() = 0;
    //get AP status
    virtual APStatus* GetCurrentAPStatus() = 0 ;
    //start global timer
    virtual void StartGlobalTimer() = 0;
    //stop global timer
    virtual void StopGlobalTimer() = 0;
    //close connection with AP
    virtual bool CloseWlanConnection(bool ifScanDlg = false) = 0;
    //get adapter name
    virtual wxArrayString GetNetworkAdapterName(ADAPTER_TYPE adapterType) = 0;
    //get adapter name which is in use
    virtual wxString GetUsingAdapterName(ADAPTER_TYPE adapterType) = 0;
    //judging whether wired connect or not
    virtual bool IsWiredInterfaceConnected() = 0;
    //get scanner
    virtual WlanScanner* GetScanner() = 0;
    //get connect type
    virtual wxString GetConnectTypeHLAN() = 0;
    //checking whether interface enabled or not
    virtual bool IsInterfaceEnabled(ADAPTER_TYPE adapterType) = 0;
    //switch adapter
    virtual void SwitchAdapterParameter(ADAPTER_TYPE adapterTypeDown, ADAPTER_TYPE adapterTypeUp, wxEvtHandler* handler = NULL) = 0;
    //set flag in order to decide whether show balloon or not
    virtual void SetShowBalloonFlag(bool isShown) = 0;
    //set auto wireless flag
    virtual void SetAutoWirelessFlag(bool isAutoWireless) = 0;

protected:
    DataCenter();
    virtual void DestroyData();
    virtual void CreateWnd();

protected:
    static DataCenter* m_pDataCenter;
    NetworkManagerDlg* m_pNetworkManagerDlg;
    ProfileManagerDlg* m_pProfileManagerDlg;
    ScanNetworkDlg* m_pScanNetworkDlg;
    ProfileManagementControl* m_pProfileController;
    PolicyManager* m_pPolicyManager;
    bool m_isSessionLocked;

    DECLARE_EVENT_TABLE()
};

#endif // _DATA_CENTER_H
