/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _CUSTOM_STATIC_TEXT_H
#define _CUSTOM_STATIC_TEXT_H

#include <wx/stattext.h>

#if defined(__WXMSW__)

#include <wx/colour.h>

class CustomStaticText : public wxStaticText
{
    DECLARE_DYNAMIC_CLASS(CustomStaticText)

public:
    CustomStaticText();

    CustomStaticText(wxWindow *parent,
            wxWindowID id,
            const wxString& label,
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = 0,
            const wxString& name = wxStaticTextNameStr);

	virtual ~CustomStaticText();

	bool Create(wxWindow* parent,
            wxWindowID id,
            const wxString& label,
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = 0,
            const wxString& name= wxStaticTextNameStr);

	virtual bool HasTransparentBackground() { return true; };
	virtual void OnPaint(wxPaintEvent& event);
    virtual bool SetForegroundColour(const wxColour& colour);
    virtual void SetLabel(const wxString& label);
    virtual void SetSize(const wxSize& size);

protected:
    wxSize m_size;
	wxColour m_textColor;
    void SetTextColor(const wxColour& textColor);

	DECLARE_EVENT_TABLE()
};

#else

typedef wxStaticText CustomStaticText;

#endif

#endif // _CUSTOM_STATIC_TEXT_H
