/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef WXBITMAPDIALOG_H
#define WXBITMAPDIALOG_H

#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/frame.h>
#include <wx/dc.h>
#include <wx/dcclient.h>

class wxBitmapDialog : public wxDialog
{
public:
    //constructor
    wxBitmapDialog(wxBitmap bitmap, wxWindow* parent, wxWindowID id, const wxString& title);
    //constructor
    wxBitmapDialog(const wxBitmap& bitmap, wxWindow* parent, const wxString& title);
    //destructor
    virtual ~wxBitmapDialog();

protected:
    wxBitmap m_bitmap;

private:
    //initialize data
    void Init();

    bool m_hasShape;
    wxPoint  m_diff;
    //set window shape
    void SetWindowShape();
    //called when mouse left key down
    void OnMouseLeftDown(wxMouseEvent& event);
    //called when mouse left key up
    void OnMouseLeftUp(wxMouseEvent& event);
    //called when move mouse
    void OnMouseMove(wxMouseEvent& event);
    //erase background
    void OnEraseBackground(wxEraseEvent& event);
    //size
    void OnSize(wxSizeEvent& event);
    //paint
    void OnPaint(wxPaintEvent& event);
    //create window
    void OnWindowCreate(wxWindowCreateEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // WXBITMAPDIALOG_H
