/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef WIN32
#include <unistd.h>
#include <grp.h>
#endif

#include "ReqMgmt.h"
#include <string.h>

#include "vkbd/VKbdPlugin.h"
#include "tablet/TabletPlugin.h"
#include "accel/AccelPlugin.h"
#include "pm/PMPlugin.h"
#include "PMApi.h"
//#include "debug_new.h"

extern void WINAPI DebugString(const char* format, ...);
extern int DCS_SignalResponse(DCS_Response* pResponse);

ReqMgmt* ReqMgmt::m_pInstance=NULL;

ReqMgmt* ReqMgmt::Instance()
{
	if (m_pInstance == NULL)
		m_pInstance = new ReqMgmt();
	return m_pInstance;
}

ReqMgmt::ReqMgmt()
{
	m_reqNum=0;
	for(int i=0;i<10;i++)
		for (int j=0;j<100;j++)
			m_callbackTbl[i][j]=NULL;
	//memset(m_callbackTbl, NULL, sizeof(m_callbackTbl));
//    m_callbackTbl.clear();
#ifdef WIN32	
	m_hMutex = NULL;
		// create the mutex object
	m_hMutex = CreateMutex(NULL, FALSE, NULL);
#endif
}
ReqMgmt::~ReqMgmt()
{
	Unlock();
#ifdef WIN32
	m_hMutex = NULL;
#endif
	for(int i=0;i<10;i++)
		for (int j=0;j<100;j++)
			m_callbackTbl[i][j]=NULL;
	if (m_pInstance != NULL)
        m_pInstance = NULL;
  //  m_callbackTbl.clear();
	
}

DCS_UserID ReqMgmt::GetUserID()
{
#ifdef WIN32
	DWORD size=1024;
	LPTSTR	lpcwszStr = (LPTSTR)new TCHAR[size];
	GetUserName(lpcwszStr,&size); 
	DWORD dwNum = WideCharToMultiByte(CP_OEMCP,NULL,lpcwszStr,-1,NULL,0,NULL,FALSE);
	char *psText;
	psText = new char[dwNum];
	if(psText)
	{
		WideCharToMultiByte (CP_OEMCP,NULL,lpcwszStr,-1,psText,dwNum,NULL,FALSE);
		//delete []psText;
	}

	DebugString("user name is: %s and size is: %ld", psText, dwNum);
	delete[] lpcwszStr;
	return psText;
#else
	return getuid();
#endif
}

DCS_ProcID ReqMgmt::GetProcessID()
{
#ifdef WIN32
	DWORD pid= GetCurrentProcessId();
	//	printf("PID = %d",pid);
	return pid;
#else
	return getpid();
#endif
}

/** generate unregister event request, and send out to DCS*/
DCS_Return_Code ReqMgmt::GenUnregisterEventReq(int moduleID, int eventID)
{
	Event_Request eventReq;	
	DCS_DataHeader header;
	DCS_Request request;
	DCS_Return_Code ret = DCS_SUCCESS;
	ConnMgmt *pConnMgmt = ConnMgmt::Instance(); 

	header.msgID = m_reqNum++;
	header.msgType = DCS_UNREGISTER_EVENT_REQUEST;
	header.userID = GetUserID();
#ifdef WIN32
	header.userIdLen = (int)strlen(header.userID) + 1;
#endif
	header.dataLen = sizeof(eventReq);

	eventReq.procId = GetProcessID();
	eventReq.moduleId = moduleID;
	eventReq.eventId = eventID;

	request.header = header;
	request.request.evt = eventReq;

	UnregisterEvent(moduleID, eventID);

	if (pConnMgmt->Send(&request))
		ret = DCS_FAIL_OPERATION;
	return ret;
}


/** generate event request, and send out to DCS*/
DCS_Return_Code ReqMgmt::GenEventReq(int moduleID, int eventID, DCS_Callback callback)
{
	Event_Request eventReq;	
	DCS_DataHeader header;
	DCS_Request request;
	DCS_Return_Code ret = DCS_SUCCESS;
	ConnMgmt *pConnMgmt = ConnMgmt::Instance(); 

	header.msgID = m_reqNum++;
	header.msgType = DCS_EVENT_REQUEST;
	header.userID = GetUserID();
#ifdef WIN32
	header.userIdLen = (int)strlen(header.userID) + 1;
#endif
	header.dataLen = sizeof(eventReq);

	eventReq.procId = GetProcessID();
	eventReq.moduleId = moduleID;
	eventReq.eventId = eventID;

	request.header = header;
	request.request.evt = eventReq;

		RegisterEvent(moduleID, eventID, callback);

	if (pConnMgmt->Send(&request))
		ret = DCS_FAIL_OPERATION;

#ifdef WIN32
	if (header.userID)	
		delete[] header.userID;
#endif 

	return ret;
}
DCS_Return_Code ReqMgmt::UnregisterEvent(int moduleID, int eventID)
{
	int effectEventID = eventID-100;
	if (effectEventID < 0 || effectEventID >= 100) return DCS_FAIL_OPERATION;
	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM) return DCS_FAIL_OPERATION;

 /*   Event_Mapping evtMap;

	evtMap.moduleID = moduleID;
	evtMap.eventID = effectEventID;

	CallbackMapping::iterator iter;
*/	Lock();
/*	iter = m_callbackTbl.find(evtMap);
	if(iter != m_callbackTbl.end())
        m_callbackTbl.erase(iter);
*/
	m_callbackTbl[moduleID][effectEventID] = NULL;
	Unlock();
    return DCS_SUCCESS;
}

/** add the event into the callback table or remove the event if it's unregister event*/
DCS_Return_Code ReqMgmt::RegisterEvent(int moduleID, int eventID, DCS_Callback callback)
{
	int effectEventID = eventID-100;
	if (effectEventID < 0 || effectEventID >= 100) return DCS_FAIL_OPERATION;
	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM) return DCS_FAIL_OPERATION;
	Lock();
	m_callbackTbl[moduleID][effectEventID] = callback;
	Unlock();
    
	/*Event_Mapping evtMap;

	evtMap.moduleID = moduleID;
	evtMap.eventID = eventID;

	CallbackMapping::iterator iter;
		if (eventID < DCS_UNREGISTER_EVENT_NUM_START)
		{
			Lock();
			m_callbackTbl[evtMap] = callback;
			Unlock();
		}
	*/return DCS_SUCCESS;
}

/** generate func request, and send out to DCS*/
DCS_Return_Code ReqMgmt::GenFuncReq(int moduleID, int funcID, int paramLen, PVOID params)
{
	Func_Request funcReq;	
	DCS_DataHeader header;
	DCS_Request request;
	DCS_Return_Code ret = DCS_SUCCESS;
	ConnMgmt *pConnMgmt = ConnMgmt::Instance(); 

	header.msgID = m_reqNum++;
	header.msgType = DCS_FUNCTION_REQUEST;
	header.userID = GetUserID();
#ifdef WIN32
	if (header.userID != NULL)
		header.userIdLen = (int)strlen(header.userID) + 1;
#endif
	header.dataLen = sizeof(funcReq);

	funcReq.procId = GetProcessID();
	funcReq.moduleId = moduleID;
	funcReq.funcId = funcID;
	funcReq.paramLen = paramLen;
	funcReq.params = params;
	//alloca(paramLen);
	//memcpy (funcReq.params, params, paramLen);

	request.header = header;
	request.request.func = funcReq;

	if (pConnMgmt->Send(&request))
		ret = DCS_FAIL_OPERATION;

#ifdef WIN32
	if (header.userID)	
		delete[] header.userID;
#endif 

	return ret;
}

/** receive the event happened response, check the callback table, and call the callback*/
DCS_Return_Code ReqMgmt::DispatchEvent(DCS_Response* pResponse)
{
	//assert is much better, because pResponse is not NULL at any time
	if (pResponse==NULL) return DCS_FAIL_OPERATION;
	if (pResponse->opID < 0 || pResponse->opID >= 1000) return DCS_FAIL_OPERATION;
	if (pResponse->moduleID < 0 || pResponse->moduleID >= MAX_MODULE_NUM) return DCS_FAIL_OPERATION;

	Lock();	
	
	DCS_Callback callbackfunc;
	DCS_Response tt = *pResponse;
	
	if (pResponse->opID >= 100)
	{
		callbackfunc = m_callbackTbl[pResponse->moduleID][pResponse->opID-100];
		Unlock();
		if (callbackfunc != NULL && tt.returnCode == DCS_SUCCESS)
		{
			callbackfunc(tt.data);
			if (tt.dataLen>0)
			{	
				delete[] tt.data;
				tt.data = NULL;
			}
			return DCS_SUCCESS;		
		}
	}
	//no callback function is defined, write one log, save the response, signal response DCS_SignalResponse
			Unlock();
			DebugString("module: %d, operation: %d, return code: %d", tt.moduleID, tt.opID, tt.returnCode);
		if (tt.opID >= 100)
		{
			if (tt.moduleID == DCS_POWER_MANAGER && (tt.opID == PM_CPU_SPEED_CHANGED || tt.opID == PM_LAN_SPEED_CHANGED || tt.opID == PM_APPLY_SCHEME))
				DCS_SignalResponse(&tt);
		}
		else
			DCS_SignalResponse(&tt);
	if (tt.dataLen>0)
	{
		delete[] tt.data;
		tt.data = NULL;
	}
				
	return DCS_SUCCESS;
}
#ifdef _WIN32

int ReqMgmt::Lock()
{
    WaitForSingleObject(m_hMutex, INFINITE);
	return 0;
}

int ReqMgmt::Unlock()
{
	// ͷŻ
    ReleaseMutex(m_hMutex);

	return 0;
}

#else
static pthread_mutex_t callbackTblMutex= PTHREAD_MUTEX_INITIALIZER;

int ReqMgmt::Lock()
{   
	pthread_mutex_lock(&callbackTblMutex);
	return 0;
}

int ReqMgmt::Unlock()
{
	// release the mutex object
	pthread_mutex_unlock(&callbackTblMutex);

	return 0;
}

#endif
