/****************************************************************************

Copyright (c) 2008 Intel Corporation.  All rights reserved. 

 

DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 

****************************************************************************/


/**
 * 
 * @file TabletHelper.cpp
 *
 * @version 0.1
 * @date 2008/07/17
 */
#include <assert.h>
#include "TabletHelper.h"
#include <string.h>
#include <stdio.h>

#ifndef _WIN32
#include "tablet.h"
#include <syslog.h>
#endif
/** const values */

const char * const TabletHelper::MODULE_NAME = "Tablet Sensor";
DCS_Tablet_Sensor_Data currentMode=DCS_CLAMSHELL_MODE;
BOOL firstCall=TRUE;

#ifdef WIN32

const wchar_t * const TabletHelper::EVENT_NAME = L"TabletEvent";
const wchar_t * const TabletHelper::DEVICE_PATH = L"\\\\.\\TBLT0000";

#define IOCTL_REGISTER_EVENT \
   CTL_CODE( FILE_DEVICE_ACPI, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_UNREGISTER_EVENT \
   CTL_CODE( FILE_DEVICE_ACPI, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_DBG_SIGNAL_EVENT \
   CTL_CODE( FILE_DEVICE_ACPI, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS )


DWORD WINAPI TabletEventHandler(LPVOID lpParameter)
{
	HANDLE handles[2] = {TabletHelper::GetInstance().m_hTabletEvent,
		TabletHelper::GetInstance().m_hExitEvent};

	while (WAIT_OBJECT_0 == 
		WaitForMultipleObjects(2, handles, FALSE, INFINITE)) 
	//while(TRUE)
	{
	//	WaitForSingleObject(TabletHelper::GetInstance().m_hTabletEvent, INFINITE);
		/** TabletEvent was set by driver. Reset it for next notification */
		ResetEvent(TabletHelper::GetInstance().m_hTabletEvent);

		/** get and call DCS to dispatch tablet data */
		DCS_Tablet_Sensor_Data data;
		if (!TabletHelper::GetInstance().GetTabletData(data)) {
			return DCS_FAIL_OPERATION;
		}

		assert(NULL != TabletHelper::GetInstance().m_pFuncs);
		TabletHelper::GetInstance().m_pFuncs->dispatchEvent(DCS_TABLET_SENSOR,
			TABLET_MODE_CHANGED, &data, sizeof(DCS_Tablet_Sensor_Data));
	}

	return DCS_SUCCESS;
}

int TabletHelper::Initialize(DCS_Funcs *pDispatcher)
{
	if (m_hTabletEvent || m_hExitEvent || m_hThread || m_hDevice) {
		return DCS_FAIL_OPERATION;
	}

	m_hTabletEvent = CreateEvent(NULL, FALSE, FALSE, EVENT_NAME); //CreateEvent(NULL, TRUE, FALSE, EVENT_NAME);
	if (NULL == m_hTabletEvent) {
		return DCS_FAIL_OPERATION;
	}

	m_hExitEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (NULL == m_hExitEvent) {
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}

	m_hDevice = CreateFile(DEVICE_PATH, GENERIC_READ | GENERIC_WRITE,
		0, NULL, OPEN_EXISTING, 0, NULL);
	if (INVALID_HANDLE_VALUE == m_hDevice) {
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}

	if (!StartTablet()) {
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}

	m_hThread = CreateThread(NULL, 0, TabletEventHandler, NULL, 0, NULL);
	if (NULL == m_hThread) {
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}

	m_pFuncs = pDispatcher;
	return DCS_SUCCESS;
}

void TabletHelper::CloseHandles()
{
	if (m_hTabletEvent) {
		CloseHandle(m_hTabletEvent);
		m_hTabletEvent = NULL;
	}

	if (m_hExitEvent) {
		CloseHandle(m_hExitEvent);
		m_hExitEvent = NULL;
	}

	if (m_hThread) {
		CloseHandle(m_hThread);
		m_hThread = NULL;
	}

	if (m_hDevice) {
		CloseHandle(m_hDevice);
		m_hThread = NULL;
	}
}

int TabletHelper::Cleanup()
{
	if (!StopTablet()) {
		return DCS_FAIL_OPERATION;
	}

	if (!SetEvent(m_hExitEvent)) {
		return DCS_FAIL_OPERATION;
	}

	CloseHandles();
	
	return DCS_SUCCESS;
}

BOOL TabletHelper::StartTablet()
{
	ULONG  ulLength;

	if (!DeviceIoControl(m_hDevice, IOCTL_REGISTER_EVENT, &m_hTabletEvent, sizeof(m_hTabletEvent), NULL, 0, &ulLength, NULL))
	{
	printf("Error %d in IOCTL_REGISTER_EVENT call\n", GetLastError());
	CloseHandle(m_hTabletEvent);
	CloseHandle(m_hDevice);
	return FALSE;
	}

	return TRUE;
}

BOOL TabletHelper::StopTablet()
{
	ULONG  ulLength;

//	if (!(DeviceIoControl(m_hDevice, IOCTL_UNREGISTER_EVENT, NULL, 0, NULL, 0,
//		&ulLength, NULL))) {
//		return FALSE;
//	}

	return TRUE;
}

BOOL TabletHelper::GetTabletData(DCS_Tablet_Sensor_Data &data)
{
    DWORD   dwBack = 0;
    DWORD   dwOutput = 0;

	
	if (!DeviceIoControl(m_hDevice, IOCTL_DBG_SIGNAL_EVENT, NULL, 0, &dwOutput, sizeof(DWORD), &dwBack, NULL))
    {
        printf("Error %d in IOCTL_DBG_SIGNAL_EVENT call\n", GetLastError());
        return FALSE;
    }
    else
    {
        if(dwOutput==1)
		{
			data = DCS_CLAMSHELL_MODE;
			printf("Clamshell mode\n");
		}
        else
        {
			data = DCS_TABLET_MODE;
			printf("Tablet mode\n");
		}
    }
	currentMode = data;

	if (firstCall)
		firstCall=FALSE;
	return TRUE;
}

#else

const char * const TabletHelper::DEVICE_PATH = "/proc/acpi/tablet";


void *TabletEventHandler(void *arg)
{
	DCS_Tablet_Sensor_Data data;
	
	while (TabletHelper::GetInstance().GetTabletData(data)) {
		assert(NULL != TabletHelper::GetInstance().m_pFuncs);
		TabletHelper::GetInstance().m_pFuncs->dispatchEvent(DCS_TABLET_SENSOR,
			TABLET_MODE_CHANGED, &data, sizeof(DCS_Tablet_Sensor_Data));

	}

	return NULL;
}

int TabletHelper::Initialize(DCS_Funcs *pDispatcher)
{
	m_Device = open(DEVICE_PATH, O_RDONLY, S_IRUSR);
	if (-1 == m_Device) {	
		return DCS_FAIL_OPERATION;
	}

	if (pthread_create(&m_Thread, NULL, TabletEventHandler, NULL)) {
		return DCS_FAIL_OPERATION;
	}

	m_pFuncs = pDispatcher;
	return DCS_SUCCESS;
}

int TabletHelper::Cleanup()
{
	if (-1 != m_Device) {
		close(m_Device);
		m_Device = -1;
	}
	
	if (0 != m_Thread) {	
		if (pthread_join(m_Thread, NULL)) {
			m_Thread = 0;
			return DCS_FAIL_OPERATION;
		}
		m_Thread = 0;
	}

	return DCS_SUCCESS;
}

BOOL TabletHelper::StartTablet()
{
/*	if (-1 == ioctl(m_Device, IOCTL_REGISTER_EVENT)) {
		return FALSE;
	}

*/	return TRUE;
}

BOOL TabletHelper::StopTablet()
{
/*	if (-1 == ioctl(m_Device, IOCTL_UNREGISTER_EVENT)) {
		return FALSE;
	}
*/
	return TRUE;
}

BOOL TabletHelper::GetTabletData(DCS_Tablet_Sensor_Data &data)
{
	int mode=0;
	int size = sizeof(int);
	
	read(m_Device, &mode, size);
	//if (mode ==0 || mode ==1)//effective mode
		data = (DCS_Tablet_Sensor_Data) mode;
	/*else 
		return FALSE;*/
	printf("mode: %d\n", mode);
	currentMode = data;

	if (firstCall)
		firstCall=FALSE;
	return TRUE;
}

#endif /** WIN32 */

DCS_Return_Code TabletHelper::HandleRequest(DCS_RequestData *pRequest)
{ // no func request is needed
	if (pRequest == NULL) return DCS_FAIL_OPERATION;
	DCS_Tablet_Sensor_Data data=currentMode;

	if (firstCall)//no tablet mode is gotten yet
	
	{
#ifdef _WIN32
		GetTabletData(data);	
#else
		firstCall = FALSE;
		syslog(LOG_USER , "first call of get tablet data %d",data);
		if (-1 == ioctl (m_Device, DBG_SIGNAL_EVENT_CMD, &data))
			return DCS_FAIL_OPERATION;		
		syslog(LOG_USER , "get tablet data %d", data);
	
#endif

	}
	memcpy(pRequest->pReturnData , &data, sizeof (DCS_Tablet_Sensor_Data));
	pRequest->pReturnDataLen = sizeof (DCS_Tablet_Sensor_Data);
	return DCS_SUCCESS;
}
