/****************************************************************************

 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PMDriver.h

Description:

    This file defines some interface for operating Power Management driver.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMDRIVER_H
#define PMDRIVER_H

#include <fcntl.h>
#define ACPI_MAX_STRING 80
#define DEVICE "/dev/ipml_pm"

#ifdef __cplusplus
extern "C" {
#endif

void get_path(int fd, char *path, int *entries, int level, char *pRetPath);

int get_brightness(int fd, char* path);
int set_brightness(int fd, char* path, int value);
int get_wireless(int fd, char* path);
int set_wireless(int fd, char* path, int value);
int get_landevice(int fd, char* path);
int set_landevice(int fd, char* path, int value);

#ifdef __cplusplus
}
#endif /** __cplusplus */

#endif
