/****************************************************************************

 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PMBatteryMgmt.h

Description:

    This file defines some interface to get battery infomation through acpi.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PM_LIB_H_INCLUDED
#define PM_LIB_H_INCLUDED

#include <stdio.h>
#include <syslog.h>
#include <stdint.h>
#include <errno.h>
#include <dirent.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <unistd.h>
#include <time.h>

const int MAX_FILE_PATH_LENGTH = 512;
const int MAX_LINE_LENGTH = 1024;


const int MAX_BAT_COUNT = 4;

const int MAX_BAT_STR_LEN = 100;

const int ACPI_UNAVAI = -10;
const int MODULE_UNAVIA = -11;
const int DEVICE_UNAVIA = -12;
const int PMUNKOWN = -1;



#define ACPI_BAT_DIR  "/proc/acpi/battery"
#define ACPI_BAT_INFO  "/proc/acpi/battery/info"
#define ACPI_BAT_STATE "/proc/acpi/battery/state"
#define ACPI_ACADAPTER_DIR "/proc/acpi/ac_adapter"
#define ACPI_DIR "/proc/acpi"


enum CHARG_STATE
    {
        CHARG_UNKNOWN = 0,
        CHARG_CHARGING,
        CHARG_DISCHARGING,
        CHARG_CHARG_DISCHARG
    };

enum BAT_PRESENT
    {
        PRESENT_YES = 0,
        PRESENT_NO
    };

enum BAT_CAPACITY_STATE
    {
        BAT_OK,
        BAT_CRIT,
        BAT_LOW,
        BAT_WARNING
    };

enum BAT_CAPACITY
    {
        WATT_H = 0,
        AMP
    };

enum BAT_TECH
    {
        NON_RECHARGEABLE = 0,
        RECHARGEABLE
    };

enum AC_STATE
    {
        AC_UNKNOWN,
        AC_ON,
        AC_OFF
    };

enum EISACPI
    {
        NOT_SUP=-1,
        APM_S,
        ACPI_S
    };


typedef struct Capacity_Snapshot_S
{
    int remCapacity;
    time_t measurePoint;
} Capacity_Snapshot;

typedef struct Battery_General_S{
	int remPerc;
	int remMins;
	int chargingState;
	int remChargingMins;
} Battery_General;

typedef struct Battery_Detailed_S{
	int present;
	int designVoltage;
	int designCapacityWarning;
	int designCapacityLow;
	int designCapacity;
	int fullCapacity;
	int capGran1;
	int capGran2;
    int batteryTechnology;
	int capacityState;
	int chargingState;
	int presentRate;
	int remainingCapacity;
	int presentVoltage;

	char modelNumber[MAX_BAT_STR_LEN + 1];
	char serialNumber[MAX_BAT_STR_LEN + 1];
	char batteryType[MAX_BAT_STR_LEN + 1];
	char OEMInfo[MAX_BAT_STR_LEN + 1];


} Battery_Detailed;


int GetBatteriesInformation(Battery_General *bat);
int GetBatteryInfoByDetail(const int no, Battery_Detailed *batdetail);
int GetACAdapterStatus(void);
int GetDir(const int number, char *file_dest, const size_t file_size, const char *dir);
int CheckACPIAVAI(void);
int GetDevicesNum(const char* dir_name);
int GetValueByColon(FILE *bat_file, char *value, const size_t value_size,
                        char *key,  const size_t key_size);
int CheckACPIDirExit(const char* dir);
int GetBatteryInfoofGeneral(Battery_General *bg);


#endif // PM_LIB_H_INCLUDED
