/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <time.h>

#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>              /* for convenience */
#include <stdlib.h>             /* for convenience */
#include <stddef.h>             /* for offsetof */
#include <string.h>             /* for convenience */
//#include <unistd.h>             /* for convenience */
#include <signal.h>             /* for SIG_ERR */
//#include <sys/socket.h>
//#include "stdafx.h"

#include "FnKeyApi.h"
#include "ConnMgmt.h"
#include "ReqMgmt.h"
#include "AccelApi.h"
#include "DCSApi.h"
#include"TabletApi.h"
#include "PolicyApi.h"
#include "PMApi.h"
#ifndef _WIN32
#define Sleep sleep
#endif

const int file_name_length = 128;
const int max_string_length = 200;

const char* cstr_accel_log_file = "accel_log.txt";
const char* cstr_sysori_log_file = "rotation_log.txt";
const char* cstr_tablet_log_file = "tablet_log.txt";
const char* cstr_fnkey_log_file = "fnkey_log.txt";
const char* cstr_pm_lcd_log_file = "pm_lcd_log.txt";
const char* cstr_pm_wlan_log_file = "pm_wlan_log.txt";
//const char* cstr_sp_log_file = "sp_log.txt";

bool threads_over_flag = false;

bool Write_Log(const char* file_name, char* log_str);
void Parse_Dcs_Return_Code(const char* function_name, DCS_Return_Code DRC);

/* Thread-Function: 
 * read the status of the accelerator
 */
DWORD WINAPI Accelerator_Reader(LPVOID pParam)
{
	char gravity;
	char str_buf[max_string_length], file_name[file_name_length];
	DCS_Return_Code ret;
	DCS_Accel_Data data;

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_accel_reader.txt", dwCurThreadId);

	while(1)
	{
		printf("Accelerator_Reader ing ....\n");
		strcpy(str_buf, "initial a null string.");
		ret=DCS_GetAccelForGravity(&gravity);
		Parse_Dcs_Return_Code("DCS_GetAccelForGravity", ret);
		printf(" Gravity:%d\n", gravity);

		ret=DCS_GetAccelData(&data);
		Parse_Dcs_Return_Code("DCS_GetAccelData", ret);
		printf(" AccelData: X=%d, Y=%d, Z=%d\n", data.AccelX,  data.AccelY,  data.AccelZ);

		sprintf(str_buf, "# Gravity = %d, AccelData: X=%d, Y=%d, Z=%d", gravity, data.AccelX,  data.AccelY,  data.AccelZ);
		Write_Log(file_name, str_buf);
		
		if(threads_over_flag)
			break;

		Sleep(1000);
	}

	return 0;
}

DWORD WINAPI Autorotation_Switcher(LPVOID pParam)
{
	DCS_Return_Code ret;
	char str_log[max_string_length], file_name[file_name_length];
	BOOL enable;

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_Autorotation_Switcher.txt", dwCurThreadId);
	Write_Log(file_name, "DAR means Desktop Auto Rotation.");

	while(1)
	{
		strcpy(str_log, "initial a null string.");
	//if(use_enable==1)
	//{
		ret=DCS_EnableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_EnableDesktopAutoRotation", ret);

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		Parse_Dcs_Return_Code("DCS_GetDesktopAutoRotationStatus", ret);
	
		sprintf(str_log, "After Enable DAR, autorotation status: %d", enable);
		Write_Log(file_name, "str_log");
		Sleep(20);
	//}

	//if(use_disable==1)
	//{
		ret=DCS_DisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_DisableDesktopAutoRotation", ret);

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		Parse_Dcs_Return_Code("DCS_GetDesktopAutoRotationStatus", ret);
		
		sprintf(str_log, "After Disable DAR, autorotation status: %d",enable);
		Write_Log(file_name, str_log);
	//}

	//if(use_undisable1==1)
	//{
		ret=DCS_EnableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_EnableDesktopAutoRotation", ret);

		ret=DCS_DisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_DisableDesktopAutoRotation", ret);

		ret=DCS_DisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_DisableDesktopAutoRotation", ret);

		ret=DCS_UnDisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_UnDisableDesktopAutoRotation", ret);

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		Parse_Dcs_Return_Code("DCS_GetDesktopAutoRotationStatus", ret);
		
		sprintf(str_log, "After en, dis, dis, Undisable1 DAR, autorotation status: %d",enable);
		Write_Log(file_name, str_log);
		Sleep(20);
	//}

	//if(use_undisable2==1)
	//{
		ret=DCS_DisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_DisableDesktopAutoRotation", ret);

		ret=DCS_DisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_DisableDesktopAutoRotation", ret);

		ret=DCS_UnDisableDesktopAutoRotation();
		Parse_Dcs_Return_Code("DCS_UnDisableDesktopAutoRotation", ret);

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		Parse_Dcs_Return_Code("DCS_GetDesktopAutoRotationStatus", ret);

		sprintf(str_log, "After dis, dis, Undisable2 DAR, autorotation status: %d",enable);
		Write_Log(file_name, str_log);
	//}
		if(threads_over_flag)
			break;
		Sleep(20);
	}
	return 0;
}


DWORD WINAPI TabletMode_Reader(LPVOID pParam)
{
	DCS_Return_Code ret;
	/*char str_log[100];*/
	char file_name[file_name_length];
	DCS_Tablet_Sensor_Data tabdata;
	
	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_TabletMode_Reader.txt", dwCurThreadId);

	while(1)
	{
		ret = DCS_GetTabletSensorMode(&tabdata);
		Parse_Dcs_Return_Code("DCS_GetTabletSensorMode", ret);
		if(tabdata == DCS_TABLET_MODE)
		{
			//sprintf(str_log, "", tabdata
			Write_Log(file_name, "The PC is under DCS_TABLET_MODE now.");
		}
		else
		{
			Write_Log(file_name, "The PC is under DCS_SHELL_MODE now.");
		}
		if(threads_over_flag)
			break;
		Sleep(1000);
	}
	return 0;
}

DWORD WINAPI LCD_Brightness_Switcher(LPVOID pParam)
{

	DCS_Return_Code ret;
	char str_log[max_string_length];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_LCD_Brightness_Switcher.txt", dwCurThreadId);

	int lcdlight;
	int i=0;
	int bright;

	//int rand_num;
	time_t time_cur;
	time(&time_cur);
	srand(time_cur & 0x00000000FFFFFFFF);

	ret = DCS_GetLCDMaxBrightness(&bright);
	Parse_Dcs_Return_Code("DCS_GetLCDMaxBrightness", ret);
	sprintf(str_log, "# The Max LCD Brightness is %d.", bright);
	Write_Log(file_name, str_log);
	bright++;

	while(1)
	{		
		DCS_GetLCDBrightness(&lcdlight);
		i = rand()%bright;
		DCS_SetLCDBrightness(i);
		sprintf(str_log, "Previous brightness is %d, now set it to %d.", lcdlight, i);
		Write_Log(file_name, "");
		Sleep(1000);
		if(threads_over_flag)
			break;
		Sleep(1000);
	}
	return 0;
}

DWORD WINAPI CPU_Speed_Switcher(LPVOID pParam)
{
	DCS_CPUSpeed cpuspeed;
	DCS_Return_Code ret;
	char str_log[max_string_length];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_CPU_Speed_Switcher.txt", dwCurThreadId);
	
	int rand_num;
	time_t time_cur;
	time(&time_cur);
	srand(time_cur & 0x00000000FFFFFFFF);

	while(1)
	{
		rand_num = rand()%4;
		switch(rand_num)
		{
		case 0:
			DCS_SetCPUSpeed(DCS_CPUSPEED_LOWEST);
			DCS_GetCPUSpeed(&cpuspeed);
			sprintf(str_log, "set cpu on DCS_CPUSPEED_LOWEST(0), get %d.", cpuspeed);
			Write_Log(file_name, str_log);
			break;
		case 1:
			DCS_SetCPUSpeed(DCS_CPUSPEED_LOW);
			DCS_GetCPUSpeed(&cpuspeed);
			sprintf(str_log, "set cpu on DCS_CPUSPEED_LOW(1), get %d.", cpuspeed);
			Write_Log(file_name, str_log);
			break;
		case 2:
			DCS_SetCPUSpeed(DCS_CPUSPEED_ADAPTIVE);
			DCS_GetCPUSpeed(&cpuspeed);
			sprintf(str_log, "set cpu on DCS_CPUSPEED_ADAPTIVE(2), get %d.", cpuspeed);
			Write_Log(file_name, str_log);
			break;
		case 3:
			DCS_SetCPUSpeed(DCS_CPUSPEED_HIGHEST);
			DCS_GetCPUSpeed(&cpuspeed);
			sprintf(str_log, "set cpu on DCS_CPUSPEED_HIGHEST(3), get %d.", cpuspeed);
			Write_Log(file_name, str_log);
			break;
		default:
			Write_Log(file_name, "Unkown value of the cpu speed.");
		}
		if(threads_over_flag)
			break;
		Sleep(1000);		
	}

	return 0;
}

DWORD WINAPI Wireless_Switcher(LPVOID pParam)
{
	DCS_Return_Code ret;
	char str_log[max_string_length];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_Wireless_Switcher.txt", dwCurThreadId);

    BOOL enablewireless;
	int rand_num;
	time_t time_cur;
	time(&time_cur);
	srand(time_cur & 0x00000000FFFFFFFF);
	
	while(1)
	{
		rand_num = rand()%2;
		DCS_GetWirelessStatus(&enablewireless);
		DCS_SetWirelessStatus(rand_num);
		
		sprintf(str_log, "Previous wireless status is %d, now will set as %d.", enablewireless, rand_num);
		Write_Log(file_name, str_log);
		
		if(threads_over_flag)
			break;
		Sleep(1000);
	}

	return 0;
}

DWORD WINAPI Lan_Switcher(LPVOID pParam)
{
	DCS_Lan_Speed  lanspeed;
    BOOL enablelan;

	DCS_Return_Code ret;
	char str_log[max_string_length];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_Lan_Switcher.txt", dwCurThreadId);

	DCS_GetLANStatus(&enablelan);
    ret = DCS_SetLANStatus(1);
	Parse_Dcs_Return_Code("DCS_SetLANStatus", ret);
	Sleep(20);
    sprintf(str_log, "Previous Lan Status is %d, now will be set as 1.", enablelan); 
	Write_Log(file_name, str_log);

	int rand_num;
	time_t time_cur;
	time(&time_cur);
	srand(time_cur & 0x00000000FFFFFFFF);

	while(1)
	{
		rand_num = rand()%5;
		switch(rand_num)
		{
		case 0:
			DCS_SetLANSpeed(DCS_LAN_SPEED_10M_HALF_DUPLEX);
			sprintf(str_log, "set LAN SPEED as DCS_LAN_SPEED_10M_HALF_DUPLEX(0).\n");
			break;
		case 1:
			DCS_SetLANSpeed(DCS_LAN_SPEED_10M_FULL_DUPLEX);
			sprintf(str_log, "set LAN SPEED as DCS_LAN_SPEED_10M_FULL_DUPLEX(1).\n");
			break;
		case 2:
			DCS_SetLANSpeed(DCS_LAN_SPEED_100M_HALF_DUPLEX);
			sprintf(str_log, "set LAN SPEED as DCS_LAN_SPEED_100M_HALF_DUPLEX(2).\n");
			break;
		case 3:
			DCS_SetLANSpeed(DCS_LAN_SPEED_100M_FULL_DUPLEX);
			sprintf(str_log, "set LAN SPEED as DCS_LAN_SPEED_100M_FULL_DUPLEX(3).\n");
			break;
		case 4:
			DCS_SetLANSpeed(DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE);
			sprintf(str_log, "set LAN SPEED as DCS_LAN_SPEED_100M_FULL_DUPLEX(4).\n");
			break;
		default:
			break;
		}
		DCS_GetLANSpeed(&lanspeed);
		sprintf(str_log, "%s Get LAN SPEED: %d.", str_log, lanspeed);
		Write_Log(file_name, str_log);
		if(threads_over_flag)
			break;

		Sleep(1000);
	}

	return 0;
}

DWORD WINAPI DPST_Switcher(LPVOID pParam)
{
	DCS_DPST  dpstlevel;

	DCS_Return_Code ret;
	char str_log[max_string_length];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_DPST_Switcher.txt", dwCurThreadId);

	int rand_num;
	time_t time_cur;
	time(&time_cur);
	srand(time_cur & 0x00000000FFFFFFFF);
	
    while(1)
	{
		rand_num = rand()%4;
		switch(rand_num)
		{
		case 0:
			DCS_SetDPSTLevel(HIGHEST_POWER_SAVING);
			sprintf(str_log, "Set DPST Level as HIGHEST_POWER_SAVING(0).\n");
			break;
		case 1:
			DCS_SetDPSTLevel(MEDIUM_POWER_SAVING);
			sprintf(str_log, "Set DPST Level as MEDIUM_POWER_SAVING(1).\n");
			break;
		case 2:
			DCS_SetDPSTLevel(LOWER_POWER_SAVING);
			sprintf(str_log, "Set DPST Level as LOWER_POWER_SAVING(2).\n");
			break;
		case 3:
			DCS_SetDPSTLevel(DISABLED_POWER_SAVING);
			sprintf(str_log, "Set DPST Level as DISABLED_POWER_SAVING(3).\n");
			break;
		default:
			break;
		}
		DCS_GetDPSTLevel(&dpstlevel);
		sprintf(str_log, "%s Get DPST level is %d.", dpstlevel);

		if(threads_over_flag)
			break;
		Sleep(1000);
	}

	return 0;
}

DWORD WINAPI Battery_Status_Reader(LPVOID pParam)
{
	ULONG batCount;
	DCS_Battery_Info battery;
	DCS_Return_Code ret;

	char str_log[max_string_length];
	char str_buf[600];
	char file_name[file_name_length];

	DWORD dwCurThreadId = GetCurrentThreadId();
	sprintf(file_name, "%ld_Battery_Status_Reader.txt", dwCurThreadId);

	while(1)
	{
		//strcpy(str_log, "initial a null string.");
		strcpy(str_buf, "Initilise a null string.");

		ret=DCS_GetBatteryCount(&batCount);
		Parse_Dcs_Return_Code("DCS_GetBatteryCount", ret);

		battery.BatteryStatus=0;
		DCS_GetBatteryInfo( &battery, 0);
		Parse_Dcs_Return_Code("DCS_GetBatteryInfo", ret);


		sprintf(str_log, "# battary's Status :%d\n", battery.BatteryStatus);
		strcpy(str_buf, str_log);

		sprintf(str_log, "  battary's RemainPercent :%d\n", battery.RemainPercent);
		strcat(str_buf, str_log);

		sprintf(str_log, "  battary's RemainTime :%d\n", battery.RemainTime);
		strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's Capabilities :%d\n", battery.Capabilities);
		//strcat(str_buf, str_log);

		sprintf(str_log, "  battary's DesignedCapacity :%d\n", battery.DesignedCapacity);
	    strcat(str_buf, str_log);

		sprintf(str_log, "  battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);
		strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's Technology :%d\n", battery.Technology);
		//strcat(str_buf, str_log);

		sprintf(str_log, "  battary's Chemistry :%c\n", battery.Chemistry);
		strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's DefaultAlert1 :%d\n", battery.DefaultAlert1);
		//strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's DefaultAlert2 :%d\n", battery.DefaultAlert2);
		//strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's CriticalBias :%d\n", battery.CriticalBias);
		//strcat(str_buf, str_log);

		//sprintf(str_log, "  battary's CycleCount :%d\n", battery.CycleCount);
		//strcat(str_buf, str_log);

		sprintf(str_log, "  battary's Current :%d\n", battery.Current);
		strcat(str_buf, str_log);

		sprintf(str_log, "  battary's Voltage :%d\n", battery.Voltage);
		strcat(str_buf, str_log);

		sprintf(str_log, "  battary's Temperature :%d\n", battery.Temperature);
		strcat(str_buf, str_log);

		Write_Log(file_name, str_buf);

		if(threads_over_flag)
			break;
		Sleep(1000);

	}
	return 0;
}


/* CALLBACK Funtion:
 * Call back function for Accelerometer
 */
void CALLBACK  DCS_Accel_handler (PDCS_Accel_Data  pData)
{
	char str_accel_data[100];
	if (pData == NULL)
	{
		Write_Log(cstr_accel_log_file, "DCS_Accel_handler: pData == NULL ");
		return;
	}
	sprintf(str_accel_data, "accel data: (%d, %d, %d) ", pData->AccelX,pData->AccelY,pData->AccelZ);
	Write_Log(cstr_accel_log_file, str_accel_data);
	return;
}

void CALLBACK  DCS_SystemOrientation_handler (DCS_SystemOrientation *pData)
{	
	if(pData == NULL)
	{
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: pData == NULL ");
		return;
	}

	switch (*pData)
	{
	case DCS_SYSTEM_ORIENTATION_NORMAL:
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: DCS_SYSTEM_ORIENTATION_NORMAL");
		break;

	case DCS_SYSTEM_ORIENTATION_CW90:
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: DCS_SYSTEM_ORIENTATION_CW90");
		break;

	case DCS_SYSTEM_ORIENTATION_CW180:
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: DCS_SYSTEM_ORIENTATION_CW180");
		break;

	case DCS_SYSTEM_ORIENTATION_CW270:
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: DCS_SYSTEM_ORIENTATION_CW270");
		break;
    default:
		Write_Log(cstr_sysori_log_file, "DCS_SystemOrientation_handler: Unknown value");
		break;
	}
}

/* CALLBACK Funtion:
 * Call back function for fn-key
 */
void CALLBACK DCS_FnKey_handler (DCS_VKbd_Data *pData)
{
	if(pData == NULL)
	{
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: pData == NULL ");
		return;
	}
	
	switch (*pData)
	{
	case FN_WLAN_SWITCH:
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: FN_WLAN_SWITCH ");
		break;

	case FN_DISPLAY_SWITCH:
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: FN_DISPLAY_SWITCH ");
		break;

	case FN_BRIGHTNESS_DOWN:	
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: FN_BRIGHTNESS_DOWN ");
		break;

	case FN_BRIGHTNESS_UP:
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: FN_BRIGHTNESS_UP ");
		break;

	case BEZELBUTTON_SINGLE_CLICK:
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: BEZELBUTTON_SINGLE_CLICK ");
		break;

	case BEZELBUTTON_DOUBLE_CLICK:
		Write_Log(cstr_fnkey_log_file, "DCS_FnKey_handler: BEZELBUTTON_DOUBLE_CLICK ");
		break;

	default:
		Write_Log(cstr_accel_log_file, "DCS_FnKey_handler: Unknown value");
		break;
	  }
}


/* CALLBACK Funtion:
 * Call back function for Tablet Sensor
 */
void CALLBACK DCS_TabletSensor_handler (DCS_Tablet_Sensor_Data *pData)
{
    if (pData == NULL)
	{
		Write_Log(cstr_tablet_log_file, "DCS_TabletSensor_handler: pData == NULL ");
		return;
	}
    
	switch (*pData)
	{
	case DCS_CLAMSHELL_MODE:
		Write_Log(cstr_tablet_log_file, "DCS_TabletSensor_handler: DCS_CLAMSHELL_MODE");
		break;
		
	case DCS_TABLET_MODE:
		Write_Log(cstr_tablet_log_file, "DCS_TabletSensor_handler: DCS_TABLET_MODE");
		 break;
	
	default:
		Write_Log(cstr_accel_log_file, "DCS_TabletSensor_handler: Unknown value");
		break;
	}   
}


/* CALLBACK Funtion:
 * Call back function for Power Manager Related.
 */
void CALLBACK  DCS_LCDBrightness_handler(int* bright)
{
	char str_log[100];
    if (bright == NULL)
	{
		Write_Log(cstr_pm_lcd_log_file, "DCS_LCDBrightness_handler: bright == NULL ");
		return;
	}
	sprintf(str_log, "DCS_LCDBrightness_handler: bright = %d", *bright);
	Write_Log(cstr_pm_lcd_log_file, str_log);
}

void CALLBACK DCS_PM_LCDBrightness_handler(int *pData)
{
	char str_log[100];
    if (pData == NULL)
	{
		Write_Log(cstr_pm_lcd_log_file, "DCS_PM_LCDBrightness_handler: pData == NULL ");
		return;
	}
	sprintf(str_log, "DCS_PM_LCDBrightness_handler: pData = %d", *pData);
	Write_Log(cstr_pm_lcd_log_file, str_log);
}

void CALLBACK DCS_PM_WLan_handler (BOOL *pData)
{
    if (pData == NULL)
	{
		Write_Log(cstr_pm_wlan_log_file, "DCS_PM_WLan_handler: pData == NULL ");
		return;
	}
	if( *pData == 1)
	{
		Write_Log(cstr_pm_wlan_log_file, "DCS_PM_WLan_handler: Wlan is Working.");
	}
	else
	{
		Write_Log(cstr_pm_wlan_log_file, "DCS_PM_WLan_handler: Wlan is not Working.");
	}
}

/* Log Function
 * Log the data and time
 */
bool Write_Log(const char* file_name, char* log_str)
{
	FILE *fp_log=NULL;
	errno_t err;
	time_t ltime;
	char timebuf[26];
	char log[126];

	if(file_name == NULL || log_str == NULL)
	{
		printf("file_name == NULL || log_str == NULL\n");
		return false;
	}
	if( (fp_log = fopen(file_name, "a")) == NULL)
	{
		printf("can't open file %s to record: %s\n", file_name, log_str);
		return false;
	}
	
	time( &ltime );
	err = ctime_s(timebuf, 26, &ltime);
    if (err)
    {
       printf("ctime_s failed due to an invalid argument.");
       exit(1);
    }
	sprintf(log, "%s, time: %s\n", log_str, timebuf);
	fprintf(fp_log, log);
	fclose(fp_log);
	return true;
}

/* Function
 * Parse DCS return code 
 */
void Parse_Dcs_Return_Code(const char* function_name, DCS_Return_Code DRC)
{
	switch(DRC)
	{
	case 0:
		printf("%s: SUCCESS\n", function_name);
		break;
	case 1:
		printf("%s: Request is not supported\n", function_name);
		break;
	case 2:
		printf("%s: request is denied\n", function_name);
		break;
	case 3:
		printf("%s: request module does not exit\n", function_name);
		break;
	case 4:
		printf("%s: request event does not exit\n", function_name);
		break;
	case 5:
		printf("%s: request function does not exit\n", function_name);
		break;
	default:
		printf("%s: version mismatch\n", function_name);
		break;
	}	

}

void usage()
{
	printf("\n# Here is the usage of DCS_MultiThd_Test.exe tool:\n");
	printf("# DCS_MultiThd_Test.exe [option]\n");
	printf("# option can be each or a combination of below option:\n");
	printf("# -accel			Test Accelerator.\n");
	printf("# -autorotation			Test System auto-rotatioin.\n");
	printf("# -tablet			Test Tablet Status.\n");
	printf("# -fnkey			Test Function Key.\n");
	printf("# -pm				Test Power Management.\n");
	printf("# -time value			Test last for 'value' seconds. If this option doesn't been set, the process will run forever.\n\n");
}

/* main
 *
 */
int main(int argc, char *argv[])
{
	int i=0;

	int use_accel=0;
	int use_tablet=0;
	int use_fnkey=0;
	int use_policy=0;
	int use_pm=0;
	int use_enable=0;
    int use_disable=0;
    int use_undisable1=0;
	int use_undisable2=0;
	int use_autorotation = 0;

	int use_sp = 0;
	int use_rp = 0;

	int set_group=0;
    int set_moduleid=0;
	int set_opid=0;
    int set_action=0;

	int use_timer=0;
	int run_time=0;

	int enable=0;

	char c0;

	DWORD dwThId;
	HANDLE hThd;

	DCS_Return_Code ret = DCS_NOT_SUPPORTED;

	#ifdef WIN32
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		ret = DCS_NOT_SUPPORTED;
		return ret;
	}
	#endif	

	/* Command line parsing */
	if(argc == 1)
	{
		usage();
		return 0;
	}
	//usage();
	for (i=1; i< argc; i++) {
 
		if (strcmp("-accel", argv[i]) == 0 ) {
			use_accel = 1;
		}else if(strcmp("-autorotation", argv[i]) == 0){
			printf("use autorotation.\n");
			use_autorotation = 1;
		}
		else if (strcmp("-tablet", argv[i]) == 0) {
			printf("use tablet.\n");
			use_tablet = 1;
		} else if (strcmp("-fnkey", argv[i]) == 0 ) {
			printf("use fnkey.\n");
			use_fnkey = 1;
		}else if (strcmp("-pm", argv[i]) == 0) {
			printf("use pm.\n");
			use_pm = 1;
		}else if (strcmp("-time", argv[i]) == 0 && i < argc - 1 ) {
			use_timer=1;
			run_time = atoi(argv[i+1]);
			printf("use timer, %d seconds\n",run_time);
		}/*else if (strcmp("-enable", argv[i]) == 0) {
			use_enable = 1;
		} else if (strcmp("-disable", argv[i]) == 0) {
			use_disable = 1;
		} else if (strcmp("-undisable1", argv[i]) == 0) {
			use_undisable1 = 1;
		} else if (strcmp("-undisable2", argv[i]) == 0) {
			use_undisable2 = 1;
		} else if (strcmp("-sp", argv[i]) == 0) {
			use_sp = 1;
		}  else if (strcmp("-sp", argv[i]) == 0) {
			use_rp = 1;
		} else if (strcmp("-group", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_group = atoi(argv[i]);
			printf("set_group=%d\n",set_group);
		}else if (strcmp("-moduleid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_moduleid = atoi(argv[i]);
			printf("set_moduleid=%d\n",set_moduleid);
		}else if (strcmp("-opid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_opid = atoi(argv[i]);
			printf("set_opid=%d\n",set_opid);
		}else if (strcmp("-action", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_action = atoi(argv[i]);
			printf("set_action=%d\n",set_action);
		}else if (strcmp("-timer", argv[i]) == 0 && i < argc - 1 ) {
			use_timer=1;
		}*/
	}//for

	/* Initialize the DCS */
	ret = DCS_Initialize();
	if(ret==0)
	{
		printf("DCS_initialize SUCCESS\n");		
	}
	else	
	{	
		printf("DCS_initialize Fail\n"); 
		return ret; //parse ret	
	}
	

	/* For the Accelerometer Interface */
	if(use_accel == 1)
	{	
		/* Register CallBack */
		ret=DCS_RegisterAccelCallback( DCS_Accel_handler);
		Parse_Dcs_Return_Code("DCS_RegisterAccelCallback", ret);
		
		ret=DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
		Parse_Dcs_Return_Code("DCS_RegisterSystemOrientationCallback", ret);
		
		/* Reader thread */
		hThd = CreateThread(NULL, 0, Accelerator_Reader, 0, 0, &dwThId);
		if(hThd)
		{
			printf("Accelerometer Reader thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create Accelerometer Reader thread.\n");
		}

		/* Desktop Autorotation */
		if(use_autorotation == 1)
		{
			//ret=DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
			//Parse_Dcs_Return_Code("DCS_RegisterSystemOrientationCallback", ret);

			hThd = CreateThread(NULL, 0, Autorotation_Switcher, 0, 0, &dwThId);
			if(hThd)
			{
				printf("Autorotation Switcher thread %ld launched.\n", dwThId);
				CloseHandle(hThd);
			}
			else
			{
				printf("Can't create Autorotation Switcher thread.\n");
			}

		}
	}
	
	/* For the Tablet Sensor Interface */
	if(use_tablet == 1)
	{
		ret=DCS_RegisterTabletSensorCallback(DCS_TabletSensor_handler);
		Parse_Dcs_Return_Code("DCS_RegisterTabletSensorCallback", ret);
		
		hThd = CreateThread(NULL, 0, TabletMode_Reader, 0, 0, &dwThId);
		if(hThd)
		{
			printf("TabletMode Reader thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create TabletMode Reader thread.\n");
		}
	}

	/* For the Fn Key & Button Interface */
	if(use_fnkey == 1)
	{
		ret=DCS_RegisterFnKeyCallback(DCS_FnKey_handler );
		Parse_Dcs_Return_Code("DCS_RegisterFnKeyCallback", ret);
	}
	
	/* For the Power Management Interface */
	if(use_pm == 1)
	{
		ret=DCS_RegisterLCDBrightnessChangedCallback(DCS_PM_LCDBrightness_handler); 
		Parse_Dcs_Return_Code("DCS_RegisterLCDBrightnessChangedCallback", ret);

		ret=DCS_RegisterWLanChangedCallback(DCS_PM_WLan_handler);
		Parse_Dcs_Return_Code("DCS_RegisterWLanChangedCallback", ret);

		//
		hThd = CreateThread(NULL, 0, LCD_Brightness_Switcher, 0, 0, &dwThId);
		if(hThd)
		{
			printf("LCD Brightness Switcher thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create LCD Brightness Switcher thread.\n");
		}

		hThd = CreateThread(NULL, 0, CPU_Speed_Switcher, 0, 0, &dwThId);
		if(hThd)
		{
			printf("CPU Speed Switcher thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create CPU Speed Switcher thread.\n");
		}

		hThd = CreateThread(NULL, 0, Wireless_Switcher, 0, 0, &dwThId);
		if(hThd)
		{
			printf("Wireless Switcher thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create Wireless Switcher thread.\n");
		}

		hThd = CreateThread(NULL, 0, Lan_Switcher, 0, 0, &dwThId);
		if(hThd)
		{
			printf("Lan Switcher thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create Lan Switcher thread.\n");
		}

		hThd = CreateThread(NULL, 0, DPST_Switcher, 0, 0, &dwThId);
		if(hThd)
		{
			printf("DPST Switcher thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create DPST Switcher thread.\n");
		}

		hThd = CreateThread(NULL, 0, Battery_Status_Reader, 0, 0, &dwThId);
		if(hThd)
		{
			printf("Battery Status Reader thread %ld launched.\n", dwThId);
			CloseHandle(hThd);
		}
		else
		{
			printf("Can't create Battery Status Reader thread.\n");
		}

	}

	if(use_timer == 1)
	{
		while(run_time)
		{
			Sleep(1000);
			run_time--;
			printf("left time is %d\n", run_time);
		}
		threads_over_flag = true;
		printf("# Set threads_over_flag = true.\n");
		Sleep(5000);
	}
	else
	{
		while(1)
			Sleep(60000);
	}
	//threads_over_flag

	/* Uninitialize the DCS */
	if(use_accel==1)
	{
		ret=DCS_UnregisterAccelCallback();
		printf("DCS_UnregisterAccelCallback\n");
		Parse_Dcs_Return_Code("DCS_UnregisterAccelCallback", ret);

		ret=DCS_UnregisterSystemOrientationCallback();
		printf("DCS_UnregisterSystemOrientationCallback\n");
		Parse_Dcs_Return_Code("DCS_UnregisterSystemOrientationCallback", ret);
	}

	if(use_tablet==1)
	{
		ret=DCS_UnregisterTabletSensorCallback();
		printf("DCS_UnregisterTabletSensorCallback\n");
		Parse_Dcs_Return_Code("DCS_UnregisterTabletSensorCallback", ret);
	}

	if(use_fnkey==1)
	{
		ret=DCS_UnregisterFnKeyCallback();
		printf("DCS_UnDisableDesktopAutoRotation\n");
		Parse_Dcs_Return_Code("DCS_UnDisableDesktopAutoRotation", ret);
	}

	if(use_pm==1)
	{
		ret=DCS_UnregisterLCDBrightnessChangedCallback();
		printf("DCS_UnregisterLCDBrightnessChangedCallback\n");
		Parse_Dcs_Return_Code("DCS_UnregisterLCDBrightnessChangedCallback", ret);

		ret=DCS_UnregisterWLanChangedCallback();
		printf("DCS_UnregisterWLanChangedCallback\n");
		Parse_Dcs_Return_Code("DCS_UnregisterWLanChangedCallback", ret);
	}

	ret=DCS_Uninitialize();
    if(ret==0)
	{
		printf("DCS_Uninitialize SUCCESS\n"); 
		return 0;
	}
	else 	
	{	
		printf("DCS_Uninitialize Fail\n"); 
		return ret;
	}


}