#ifdef WIN32
#include <afxwin.h>
#endif
#include "FnKeyApi.h"
#include "AccelApi.h"
#include "DCSApi.h"
#include "PMApi.h"
#include "TabletApi.h"
#include <stdio.h>

void  fnkeyHandler(DCS_VKbd_Data *pData)
{
	if (pData == NULL) return;

	printf("key %c is pressed \n", *pData);
	
}

void CALLBACK tabletHandler(DCS_Tablet_Sensor_Data *pData)
{
	if (pData == NULL) return;
	
	printf("tablet data: %d \n", *pData);
	
}

void CALLBACK accelHandler(DCS_Accel_Data *pData)
{
	if (pData == NULL) return;
	
	printf("accel data: (%d, %d, %d) \n", pData->AccelX,pData->AccelY,pData->AccelZ);
	
}

void CALLBACK systemOrientationHandler (DCS_SystemOrientation *pData)
{
	if (pData == NULL) return;
	printf("SystemOrientation data: %d \n", *pData);
}

int main()
{
	int ret = 0;

#ifdef WIN32
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		ret = 1;
		return ret;
	}
#endif	
	ret = DCS_Initialize();
	if (ret) return ret;

	CHAR gravity;
	DCS_GetAccelForGravity(&gravity);
	printf(" gravity:%d\n", gravity);

	//DCS_RegisterFnKeyCallback(fnkeyHandler);

	DCS_RegisterTabletSensorCallback(tabletHandler);
	DCS_RegisterAccelCallback(accelHandler);

	DCS_RegisterSystemOrientationCallback(systemOrientationHandler);
//	DCS_UnregisterAccelCallback();

	//BOOL enabled = 0;
	//DCS_GetWirelessStatus(&enabled);
	//while (1) Sleep(10);
	DCS_Uninitialize();

	return 0;
}

