/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>              /* for convenience */
#include <stdlib.h>             /* for convenience */
#include <stddef.h>             /* for offsetof */
#include <string.h>             /* for convenience */
//#include <unistd.h>             /* for convenience */
#include <signal.h>             /* for SIG_ERR */
//#include <sys/socket.h>
//#include "stdafx.h"

#include "FnKeyApi.h"
#include "ConnMgmt.h"
#include "ReqMgmt.h"
#include "AccelApi.h"
#include "DCSApi.h"
#include"TabletApi.h"
#include "PolicyApi.h"
#include "ENMApi.h"
#include "ENMDef.h"
#include "PMApi.h"
#ifndef _WIN32
#define Sleep sleep
#endif

FILE* accel_log = NULL;

FILE* fnkey_log = NULL;

FILE* tablet_log = NULL;

FILE* pm_log = NULL;

FILE* policy_log = NULL;

/* Call back function for Accelerometer*/

void CALLBACK  DCS_Accel_handler (PDCS_Accel_Data  pData)

{
	if (pData == NULL) return;

	printf("accel data: (%d, %d, %d) \n", pData->AccelX,pData->AccelY,pData->AccelZ);

	fprintf(accel_log, "accel data: (%d, %d, %d)\n",pData->AccelX,pData->AccelY,pData->AccelZ);
	fflush(accel_log);
}


void CALLBACK  DCS_SystemOrientation_handler (DCS_SystemOrientation *pData)

{

	printf("SystemOrientation data: %d \n", *pData);
	fprintf(accel_log, "SystemOrientation data: %d \n",*pData);
	fflush(accel_log);

	switch (*pData)
	{
	case DCS_SYSTEM_ORIENTATION_NORMAL:
		printf(" DCS_SYSTEM_ORIENTATION_NORMAL\n");
		fprintf(accel_log, " DCS_SYSTEM_ORIENTATION_NORMAL\n");
		fflush(accel_log);
		break;

	case DCS_SYSTEM_ORIENTATION_CW90:
		printf(" DCS_SYSTEM_ORIENTATION_CW90\n");
		fprintf(accel_log, " DCS_SYSTEM_ORIENTATION_CW90\n");
		fflush(accel_log);
		break;

	case DCS_SYSTEM_ORIENTATION_CW180:
		printf(" DCS_SYSTEM_ORIENTATION_CW180\n");
		fprintf(accel_log, " DCS_SYSTEM_ORIENTATION_CW180\n");
		fflush(accel_log);
		break;

	case DCS_SYSTEM_ORIENTATION_CW270:
		printf(" DCS_SYSTEM_ORIENTATION_CW270\n");
		fprintf(accel_log, " DCS_SYSTEM_ORIENTATION_CW270\n");
		fflush(accel_log);
		break;
	default:
		printf("input system orientation data is %d \n", *pData);
		break;

	}
}



/* Call back function for Fn Key*/

void CALLBACK DCS_FnKey_handler (DCS_VKbd_Data *pData)
{
	int bright = 0;    

	printf("DCS_VKbd_Data data: %d \n", *pData);
	fprintf(fnkey_log , "DCS_VKbd_Data data: %d \n",*pData);
	fflush(fnkey_log );

	switch (*pData)	

	{	


	case FN_WLAN_SWITCH:	
		printf("FN_WLAN_SWITCH\n");
		fprintf(fnkey_log , "FN_WLAN_SWITCH\n");
		fflush(fnkey_log );
		break;

	case FN_DISPLAY_SWITCH:	
		printf("FN_DISPLAY_SWITCH\n");
		fprintf(fnkey_log , "FN_DISPLAY_SWITCH\n");
		fflush(fnkey_log );
		break;

	case FN_BRIGHTNESS_DOWN:	
		printf("FN_BRIGHTNESS_DOWN\n");
		fprintf(fnkey_log , "FN_BRIGHTNESS_DOWN\n");
		fflush(fnkey_log );
		DCS_GetLCDBrightness(&bright);
		printf("bright is %d \n", bright);	
		if (bright >=1 && bright <=8)	
			DCS_SetLCDBrightness(bright-1);

		break;

	case FN_BRIGHTNESS_UP:
		printf("FN_BRIGHTNESS_UP\n");
		fprintf(fnkey_log , "FN_BRIGHTNESS_UP\n");
		fflush(fnkey_log );
		DCS_GetLCDBrightness(&bright);
		printf("bright is %d \n", bright);	
		if (bright >=0 && bright <=7)	
			DCS_SetLCDBrightness(bright+1);

		break;


	case BEZELBUTTON_SINGLE_CLICK:	
		printf("BEZELBUTTON_SINGLE_CLICK\n");
		fprintf(fnkey_log , "BEZELBUTTON_SINGLE_CLICK\n");
		fflush(fnkey_log );
		break;

	case BEZELBUTTON_DOUBLE_CLICK:	
		printf("BEZELBUTTON_DOUBLE_CLICK\n");
		fprintf(fnkey_log , "BEZELBUTTON_DOUBLE_CLICK\n");
		fflush(fnkey_log );
		break;

	default:
		printf("input fn key data is %d \n", *pData);
		break;


	}  





}


/* Call back function for Tablet Sensor */

void CALLBACK DCS_TabletSensor_handler (DCS_Tablet_Sensor_Data *pData)
{
	if (pData == NULL) return;

	printf("tablet data: %d \n", *pData);
	fprintf(tablet_log , "tablet data: %d \n",*pData);
	fflush(tablet_log  );

	switch (*pData)
	{
	case DCS_CLAMSHELL_MODE:
		printf("DCS_CLAMSHELL_MODE\n");
		fprintf(tablet_log , "DCS_CLAMSHELL_MODE\n");
		fflush(tablet_log  );
		DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler );
		break;

	case DCS_TABLET_MODE:
		printf("DCS_TABLET_MODE\n");
		fprintf(tablet_log , "DCS_TABLET_MODE\n");
		fflush(tablet_log  );
		DCS_UnregisterSystemOrientationCallback();
		break;

	default:
		printf("input tablet data is %d \n", *pData);
		break;
	}

}

void CALLBACK  DCS_LCDBrightness_handler(int* bright)
{

	printf("DCS_LCDBrightness_handler is %d\n",*bright);
}

void CALLBACK DCS_PM_LCDBrightness_handler(int *pData)
{
	printf("DCS_PM_LCDBrightness_handler is %d\n",*pData);
}

void CALLBACK DCS_PM_WLan_handler (BOOL *pData)
{

	printf("DCS_PM_WLan_handler is %d\n",*pData);
}


void CALLBACK DCS_PM_Lan_handler (BOOL *pData)
{

	printf("DCS_PM_Lan_Callback is %d\n",*pData);
}


int main(int argc, char *argv[])
{
	//::ShellExecute(NULL, _T("open"), _T("cleanmgr.exe"), _T(""), _T(""), SW_SHOWNORMAL); 
	int ret = 0;

	int i=0;

	int use_accel=0;
	int use_tablet=0;
	int use_fnkey=0;
	int use_policy=0;
	int use_pm=0;
	int use_enable=0;
	int use_disable=0;
	int use_undisable1=0;
	int use_undisable2=0;

	int use_sp = 0;
	int use_rp = 0;
	int use_gp=0;
	int use_dp=0;

	int set_group=0;
	int set_moduleid=0;
	int set_opid=0;
	int set_action=0;

	int use_timer=0;

	int use_save=0;

	int enable=0;

	char c0;


	if(!accel_log)
	{ 

		accel_log=fopen("accel_log.txt", "w"); 

	}

	if(!fnkey_log)
	{ 

		fnkey_log=fopen("fnkey_log.txt", "w"); 

	}

	if(!tablet_log)
	{ 

		tablet_log=fopen("tablet_log.txt", "w"); 

	}

	if(!pm_log)
	{ 

		pm_log=fopen("pm_log.txt", "w"); 

	}

	if(!policy_log)
	{ 

		policy_log=fopen("policy_log.txt", "w"); 

	}


#ifdef WIN32
	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		ret = 1;
		return ret;
	}
#endif	

	/*****************************************************************************
	* Command line parsing
	****************************************************************************/



	for (i=1; i< argc; i++) {

		if (strcmp("-accel", argv[i]) == 0 ) {
			use_accel = 1;
		} else if (strcmp("-tablet", argv[i]) == 0) {
			use_tablet = 1;
		} else if (strcmp("-fnkey", argv[i]) == 0 ) {
			use_fnkey = 1;
		} else if (strcmp("-policy", argv[i]) == 0) {
			use_policy = 1;
		} else if (strcmp("-pm", argv[i]) == 0) {
			use_pm = 1;
		} else if (strcmp("-enable", argv[i]) == 0) {
			use_enable = 1;
		} else if (strcmp("-disable", argv[i]) == 0) {
			use_disable = 1;
		} else if (strcmp("-undisable1", argv[i]) == 0) {
			use_undisable1 = 1;
		} else if (strcmp("-undisable2", argv[i]) == 0) {
			use_undisable2 = 1;
		} else if (strcmp("-sp", argv[i]) == 0) {
			use_sp = 1;
		}  else if (strcmp("-rp", argv[i]) == 0) {
			use_rp = 1;
		} else if (strcmp("-gp", argv[i]) == 0  ) {
			use_gp=1;
		} else if (strcmp("-dp", argv[i]) == 0  ) {
			use_dp=1;
		}else if (strcmp("-group", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_group = atoi(argv[i]);
			printf("set_group=%d\n",set_group);
		}else if (strcmp("-moduleid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_moduleid = atoi(argv[i]);
			printf("set_moduleid=%d\n",set_moduleid);
		}else if (strcmp("-opid", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_opid = atoi(argv[i]);
			printf("set_opid=%d\n",set_opid);
		}else if (strcmp("-action", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_action = atoi(argv[i]);
			printf("set_action=%d\n",set_action);
		}else if (strcmp("-timer", argv[i]) == 0  ) {
			use_timer=1;
		}else if (strcmp("-save", argv[i]) == 0  ) {
			use_save=1;
		}

	}

	/*initialize the DCS*/
	ret = DCS_Initialize();

	if(ret==0)
	{
		printf("DCS_initialize SUCCESS\n"); 

		//		fprintf(debug_info, "DCS_initialize SUCCESS\n");
		//	    fflush(debug_info);


	}else 	
	{	

		printf("DCS_initialize Fail\n"); 

		//	fprintf(debug_info, "DCS_initialize Fail\n");
		//	fflush(debug_info);

		return ret;

	}
	/*	for (int zzz=0;zzz<10;zzz++){

	ret = DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
	printf("DCS_UpAdapter\n");
	if(ret==0)
	{
	printf("success\n");
	}
	if(ret==1)
	{
	printf("request is not supported\n");
	}
	if(ret==2)
	{
	printf("request is denied\n");
	}
	if(ret==3)
	{
	printf("request module does not exit\n");
	}
	if(ret==4)
	{
	printf("request event does not exit\n");
	}
	if(ret==5)
	{
	printf("request function does not exit\n");
	}
	if(ret==6)
	{
	printf("version mismatch\n");
	}
	ret = DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
	printf("DCS_DownAdapter\n");
	if(ret==0)
	{
	printf("success\n");
	}
	if(ret==1)
	{
	printf("request is not supported\n");
	}
	if(ret==2)
	{
	printf("request is denied\n");
	}
	if(ret==3)
	{
	printf("request module does not exit\n");
	}
	if(ret==4)
	{
	printf("request event does not exit\n");
	}
	if(ret==5)
	{
	printf("request function does not exit\n");
	}
	if(ret==6)
	{
	printf("version mismatch\n");
	}
	}
	*/	

	/*set default policy*/

	if(use_dp==1)
	{

		if(set_action==0)
		{
			ret=DCS_SetDefaultPolicy(DCS_POLICY_ALLOWED);

			printf("DCS_SetDefaultPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}
		}

		if(set_action==1)
		{
			ret=DCS_SetDefaultPolicy(DCS_POLICY_REJECTED);

			printf("DCS_SetDefaultPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}
		}
	}
	/*set one policy*/
	if(use_sp==1)
	{

		if((set_group==1)&&(set_action==0))
		{
			ret=DCS_SetPolicy( DCS_PARENT_GROUP, set_moduleid, set_opid, DCS_POLICY_ALLOWED);

			printf("DCS_SetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if((set_group==2)&&(set_action==0))
		{
			ret=DCS_SetPolicy( DCS_STUDENT_GROUP, set_moduleid, set_opid, DCS_POLICY_ALLOWED);

			printf("DCS_SetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if((set_group==1)&&(set_action==1))
		{
			ret=DCS_SetPolicy( DCS_PARENT_GROUP, set_moduleid, set_opid, DCS_POLICY_REJECTED);

			printf("DCS_SetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if((set_group==2)&&(set_action==1))
		{
			ret=DCS_SetPolicy( DCS_STUDENT_GROUP, set_moduleid, set_opid, DCS_POLICY_REJECTED);

			printf("DCS_SetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}


		}



		/*save policy*/

		/*      ret=DCS_SavePolicy();
		printf("DCS_SavePolicy\n");
		if(ret==0)
		{
		printf("success\n");
		}
		if(ret==1)
		{
		printf("request is not supported\n");
		}
		if(ret==2)
		{
		printf("request is denied\n");
		}
		if(ret==3)
		{
		printf("request module does not exit\n");
		}
		if(ret==4)
		{
		printf("request event does not exit\n");
		}
		if(ret==5)
		{
		printf("request function does not exit\n");
		}
		if(ret==6)
		{
		printf("version mismatch\n");
		}
		*/
	}

	/*remove one policy*/
	if(use_rp==1)
	{
		if(set_group==1)
		{
			ret=DCS_RemovePolicy(DCS_PARENT_GROUP, set_moduleid, set_opid);

			printf("DCS_RemovePolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if(set_group==2)
		{
			ret=DCS_RemovePolicy(DCS_STUDENT_GROUP, set_moduleid, set_opid);

			printf("DCS_RemovePolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		/*save policy*/

		/*      ret=DCS_SavePolicy();
		printf("DCS_SavePolicy\n");
		if(ret==0)
		{
		printf("success\n");
		}
		if(ret==1)
		{
		printf("request is not supported\n");
		}
		if(ret==2)
		{
		printf("request is denied\n");
		}
		if(ret==3)
		{
		printf("request module does not exit\n");
		}
		if(ret==4)
		{
		printf("request event does not exit\n");
		}
		if(ret==5)
		{
		printf("request function does not exit\n");
		}
		if(ret==6)
		{
		printf("version mismatch\n");
		}
		*/


	}



	/*Get policy*/

	DCS_Policy_Access ACCESS;

	if(use_gp==1)
	{
		if(set_group==1)
		{
			ret=DCS_GetPolicy(DCS_PARENT_GROUP, set_moduleid, set_opid, &ACCESS);

			printf(" DCS_GetPolicy value is :%d\n", ACCESS);

			printf("DCS_GetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if(set_group==2)
		{
			ret=DCS_GetPolicy(DCS_STUDENT_GROUP, set_moduleid, set_opid, &ACCESS);

			printf(" DCS_GetPolicy value is :%d\n", ACCESS);

			printf("DCS_GetPolicy\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}
	}


	/*save policy*/
	if(use_save==1)
	{
		ret=DCS_SavePolicy();
		printf("DCS_SavePolicy\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

	}

	/*
	******************************
	For the Accelerometer Interface
	******************************
	*/
	if (use_accel==1)
	{
		CHAR gravity;
		//	DCS_Response response;
		DCS_Accel_Data data;

		ret=DCS_RegisterAccelCallback( DCS_Accel_handler);
		printf("DCS_RegisterAccelCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}


		ret=DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
		printf("DCS_RegisterSystemOrientationCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}


		ret=DCS_GetAccelForGravity(&gravity);
		printf("DCS_GetAccelForGravity\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf(" gravity:%d\n", gravity);

		fprintf(accel_log, "gravity=%d\n",gravity);
		fflush(accel_log);

		printf("begin to DCS_GetAccelData\n");

		ret=DCS_GetAccelData(&data);
		printf("DCS_GetAccelData\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("X=%d, Y=%d, Z=%d\n", data.AccelX,  data.AccelY,  data.AccelZ);

		fprintf(accel_log, "X=%d,Y=%d,Z=%d\n",data.AccelX,  data.AccelY,  data.AccelZ);
		fflush(accel_log);

		DCS_SystemOrientation SystemOrientation_Data;

		ret=DCS_GetSystemOrientation(&SystemOrientation_Data);
		printf("DCS_GetSystemOrientation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("SystemOrientation data: %d \n", SystemOrientation_Data);
		fprintf(accel_log, "SystemOrientation data: %d \n",SystemOrientation_Data);
		fflush(accel_log);

	}



	if(use_enable==1)
	{
		ret=DCS_EnableDesktopAutoRotation();
		printf("DCS_EnableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		printf("DCS_GetDesktopAutoRotationStatus\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("autorotation status: %d\n",enable);

		fprintf(accel_log, "autorotation status: %d\n",enable);
		fflush(accel_log);
	}

	if(use_disable==1)
	{
		ret=DCS_DisableDesktopAutoRotation();
		printf("DCS_DisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		printf("DCS_GetDesktopAutoRotationStatus\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("autorotation status: %d\n",enable);

		fprintf(accel_log, "autorotation status: %d\n",enable);
		fflush(accel_log);
	}

	if(use_undisable1==1)
	{
		ret=DCS_EnableDesktopAutoRotation();
		printf("DCS_EnableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_DisableDesktopAutoRotation();
		printf("DCS_DisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_UnDisableDesktopAutoRotation();
		printf("DCS_UnDisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		printf("DCS_GetDesktopAutoRotationStatus\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("autorotation status: %d\n",enable);

		fprintf(accel_log, "autorotation status: %d\n",enable);
		fflush(accel_log);
	}

	if(use_undisable2==1)
	{
		ret=DCS_DisableDesktopAutoRotation();
		printf("DCS_DisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_DisableDesktopAutoRotation();
		printf("DCS_DisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_UnDisableDesktopAutoRotation();
		printf("DCS_UnDisableDesktopAutoRotation\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_GetDesktopAutoRotationStatus(&enable);
		printf("DCS_GetDesktopAutoRotationStatus\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("autorotation status: %d\n",enable);

		fprintf(accel_log, "autorotation status: %d\n",enable);
		fflush(accel_log);
	}

	/*
	******************************
	For the Tablet Sensor Interface
	******************************
	*/

	if(use_tablet==1)

	{

		ret=DCS_RegisterTabletSensorCallback(DCS_TabletSensor_handler);
		printf("DCS_RegisterTabletSensorCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		DCS_Tablet_Sensor_Data  Tablet_Sensor_Data;

		ret=DCS_GetTabletSensorMode(&Tablet_Sensor_Data);  

		printf("DCS_GetTabletSensorMode\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		printf("tablet data: %d \n",Tablet_Sensor_Data);
		fprintf(tablet_log , "tablet data: %d \n",Tablet_Sensor_Data);
		fflush(tablet_log);	

	}


	/*
	******************************
	For the Fn Key & Button Interface
	******************************
	*/
	if(use_fnkey==1)
	{

		ret=DCS_RegisterFnKeyCallback(DCS_FnKey_handler );
		printf("DCS_RegisterFnKeyCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_RegisterLCDBrightnessChangedCallback(DCS_PM_LCDBrightness_handler); 

	}



	/*
	******************************
	For the Policy Control Interface
	******************************
	*/

	if(use_policy==1)
	{


		int moduleid=0;

		int opid=0;

		int policyaccess=0;

		DCS_Policy_Access ACCESS;
		//ACCESS=DCS_POLICY_ALLOWED;

		/*
		//this is for policy control module
		moduleid=0;

		printf(" this is for policy control module \n");

		fprintf(policy_log, "# this is for policy control module \n"); 

		for(opid=0;opid<=3;opid++)

		{


		DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
		DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
		printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
		//fflush(plicy_log);
		// ACCESS=0;

		DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		//ACCESS=0;



		DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
		DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
		printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
		//ACCESS=0;

		DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		// ACCESS=0;


		DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
		DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);

		printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
		// ACCESS=0;

		DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		// ACCESS=0;



		DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
		DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
		printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
		fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

		// ACCESS=0;

		DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		//  ACCESS=0;



		DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
		DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
		printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
		fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
		//ACCESS=0;

		DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		// ACCESS=0;




		DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
		DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
		printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
		fprintf(policy_log, " STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
		//  ACCESS=0;

		DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
		DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
		printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
		fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

		fflush(policy_log);
		//     ACCESS=0;


		}

		*/
		//this is for tablet sensor module
		moduleid=1;
		printf(" this is for tablet sensor module \n");

		fprintf(policy_log, "# this is for tablet sensor module \n");

		for(opid=0;opid<1;opid++)

		{




			/*			 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);

			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			*/

			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;




			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;


			/*

			DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;

			*/

			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;




			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//     ACCESS=0;

			fflush(policy_log);

		}



		//this is for  ACCELEROMETER module
		moduleid=2;

		fprintf(policy_log, "# this is for  ACCELEROMETER module \n");

		for(opid=0;opid<=6;opid++)

		{


			/*			 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;
			*/


			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;




			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;



			/*			 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;
			*/


			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;




			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//     ACCESS=0;

			fflush(policy_log);





		}


		for(opid=100;opid<=101;opid++)

		{




			/*				 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;
			*/

			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			/*				 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS); 
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;
			*/

			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

			//  ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//     ACCESS=0;

			fflush(policy_log);


		}



		//this is for  power management module
		moduleid=3;
		printf("# this is for  power management module \n");
		fprintf(policy_log, "# this is for  power management module \n");

		for(opid=0;opid<=14;opid++)

		{

			/* 
			DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;
			*/			 
			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			/*				 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;
			*/			
			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//     ACCESS=0;
			fflush(policy_log);


		}


		for(opid=100;opid<=102;opid++)

		{


			/*				 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;
			*/				 
			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_ALLOWED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_ALLOWED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			/*				 DCS_SetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " ADMINISTRATOR and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;


			DCS_RemovePolicy(DCS_ADMINISTRATOR_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;
			*/			
			DCS_SetPolicy( DCS_PARENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " PARENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);

			//ACCESS=0;

			DCS_RemovePolicy(DCS_PARENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			// ACCESS=0;

			DCS_SetPolicy( DCS_STUDENT_GROUP, moduleid, opid, DCS_POLICY_REJECTED);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " STUDENT and set as POLICY_REJECTED and DCS_GetPolicy:%d\n", ACCESS);
			//  ACCESS=0;

			DCS_RemovePolicy(DCS_STUDENT_GROUP, moduleid, opid);
			DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
			printf(" RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);
			fprintf(policy_log, " RemovePolicy and DCS_GetPolicy:%d\n", ACCESS);

			//     ACCESS=0;
			fflush(policy_log);

		}




		//test the default policy
		printf("### begin to test default policy\n");
		fprintf(policy_log, "# begin to test default policy\n");



		for(policyaccess=0;policyaccess<=1;policyaccess++)

		{
			printf("policyaccess=%d\n",policyaccess);
			fprintf(policy_log, "policyaccess=%d\n",policyaccess);
			if (policyaccess==0)
			{
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_SET, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_GET, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_REMOVE, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_SET_DEFAULT, DCS_POLICY_ALLOWED);		  
				DCS_SetDefaultPolicy(DCS_POLICY_ALLOWED);
			}

			if (policyaccess==1)
			{
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_SET, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_GET, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_REMOVE, DCS_POLICY_ALLOWED);
				DCS_SetPolicy( DCS_STUDENT_GROUP, DCS_POLICY, POLICY_SET_DEFAULT, DCS_POLICY_ALLOWED);
				DCS_SetDefaultPolicy(DCS_POLICY_REJECTED);
			}

			//this is for policy control module
			moduleid=0;
			printf("# this is for policy control module \n");
			fprintf(policy_log, "# this is for policy control module \n");


			for(opid=0;opid<=3;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);

			}


			//this is for tablet sensor module
			moduleid=1;
			printf("# this is for tablet sensor module \n");
			fprintf(policy_log, "# this is for tablet sensor module \n");

			for(opid=0;opid<1;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);

				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);

			}



			//this is for  ACCELEROMETER module
			moduleid=2;

			printf("# this is for ACCELEROMETER module \n");
			fprintf(policy_log, "# this is for ACCELEROMETER module \n");

			for(opid=0;opid<=6;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);
			}


			for(opid=100;opid<=101;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);
			}



			//this is for  power management module
			moduleid=3;

			printf("# this is for power management module \n");
			fprintf(policy_log, "# this is for power management module \n");

			for(opid=0;opid<=14;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);
			}


			for(opid=100;opid<=102;opid++)

			{



				DCS_GetPolicy( DCS_ADMINISTRATOR_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;



				DCS_GetPolicy( DCS_PARENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;





				DCS_GetPolicy( DCS_STUDENT_GROUP, moduleid, opid, &ACCESS);
				printf(" DCS_GetPolicy:%d\n", ACCESS);
				fprintf(policy_log, " DCS_GetPolicy:%d\n", ACCESS);
				//ACCESS=0;

				fflush(policy_log);

			}






		}


	}


	/*
	******************************
	For the Power Management Interface
	******************************
	*/

	if(use_pm==1)
	{


		ret=DCS_RegisterLCDBrightnessChangedCallback(DCS_PM_LCDBrightness_handler); 

		printf("DCS_RegisterLCDBrightnessChangedCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		ret=DCS_RegisterWLanChangedCallback (DCS_PM_WLan_handler);

		printf("DCS_RegisterWLanChangedCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		// 2009-01-09 The following code added by Yunsong   
		// Test DCS_RegisterWLanChangedCallback()
		ret = DCS_RegisterLanChangedCallback(DCS_PM_Lan_handler);
		printf("DCS_RegisterLanChangedCallback\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}


		DCS_CPUSpeed cpuspeed;


		DCS_SetCPUSpeed(DCS_CPUSPEED_LOWEST);
		printf("*** Set CPU speed LOWEST, press any key to continue\n");
		scanf("%c",&c0);
		DCS_GetCPUSpeed(&cpuspeed);
		//printf("*** Get CPU speed, press any key to continue\n");
		//	 scanf("%c",&c0);
		printf(" CPU speed is set as LOWEST and get the CPUSpeed is:%d\n", cpuspeed);
		printf("\n");
		fprintf(pm_log , "CPU speed is set as LOWEST and get the CPUSpeed is:%d\n", cpuspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetCPUSpeed(DCS_CPUSPEED_LOW);
		printf("***Set CPU speed LOW, press any key to continue\n");
		scanf("%c",&c0);
		DCS_GetCPUSpeed(&cpuspeed);
		//printf("*** Get CPU speed, press any key to continue\n");
		//	 scanf("%c",&c0);

		printf(" CPU speed is set as LOW and get the CPUSpeed is:%d\n", cpuspeed);
		printf("\n");
		fprintf(pm_log , "CPU speed is set as LOW and get the CPUSpeed is:%d\n", cpuspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetCPUSpeed(DCS_CPUSPEED_ADAPTIVE);
		printf("*** Set CPU speed ADAPTIVE, press any key to continue\n");
		scanf("%c",&c0);

		if(0 == DCS_GetCPUSpeed(&cpuspeed))
			printf(" CPU speed is set as ADAPTIVE and get the CPUSpeed is: Adaptive\n");
		else
			printf(" CPU speed is set as ADAPTIVE and get the CPUSpeed is:%d\n", cpuspeed);
		printf("\n");
		fprintf(pm_log , "CPU speed is set as ADAPTIVE and get the CPUSpeed is:%d\n", cpuspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetCPUSpeed(DCS_CPUSPEED_HIGHEST);
		printf("*** Set CPU speed HIGHEST, press any key to continue\n");
		scanf("%c",&c0);
		DCS_GetCPUSpeed(&cpuspeed);
		printf(" CPU speed is set as HIGHEST and get the CPUSpeed is:%d\n", cpuspeed);
		printf("\n");
		fprintf(pm_log , "CPU speed is set as HIGHEST and get the CPUSpeed is:%d\n", cpuspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		int lcdlight;
		int i=0;
		int bright;

		DCS_GetLCDMaxBrightness(&bright);
		printf("bright=%d", bright);

		for(i=0;i<=bright&&i<=10;i++)
		{
			DCS_SetLCDBrightness(i);
			Sleep(10);

			DCS_GetLCDBrightness(&lcdlight);

			printf(" LCD is set as: %d, and get the LCD light as :%d\n", i, lcdlight);
			fprintf(pm_log , " LCD is set as: %d, and get the LCD light as :%d\n", i, lcdlight);
			fflush(pm_log );
		}

		printf("\n");

		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		BOOL enablewireless;
		i=0;

		for(i=0;i<=1;i++)
		{
			DCS_SetWirelessStatus(i);
			printf("*** Set WLAN %d, please wait 2 seconds, and press any key to continue\n", i);
			scanf("%c",&c0);

			DCS_GetWirelessStatus(&enablewireless);
			printf(" wireless is set as: %d and get the wireless status :%d\n", i, enablewireless);
			printf("\n");
			fprintf(pm_log , " wireless is set as: %d and get the wireless status :%d\n", i, enablewireless);
			fflush(pm_log );

			printf("*** press any key to continue\n");
			scanf("%c",&c0);
		}


		BOOL enablelan;
		i=0;

// 2009-01-13 Changed by Yunsong
// According to the new interface, LAN cannot be disabled.It is no use calling DCS_SetLANStatus() again.
		for(i=0;i<=0;i++)
		{
			//DCS_SetLANStatus(i);

			//printf("*** Set LAN %d,please wait 3 seconds, and press any key to continue\n", i);
			printf("Test DCS_SetLANStatus(), **** press any key to continue\n");
			scanf("%c",&c0);

			DCS_GetLANStatus(&enablelan);
			//printf("*** Get LAN status, press any key to continue\n");
			//scanf("%c",&c0);

			printf("\tLAN status is: %d\n", enablelan);
			printf("\n");
			fprintf(pm_log , "\tLAN status is: %d\n", i, enablelan);
			fflush(pm_log );

			printf("*** press any key to continue\n");
			scanf("%c",&c0);
		}

		DCS_Lan_Speed  lanspeed;

		DCS_SetLANSpeed(DCS_LAN_SPEED_10M_HALF_DUPLEX);
		printf("*** Set LAN speed 10M_HALF_DUPLEX, please wait 3 seconds, and press any key to continue\n");
		scanf("%c",&c0);

		DCS_GetLANSpeed(&lanspeed);
		//printf("*** Get LAN speed, press any key to continue\n");
		//scanf("%c",&c0);
		printf(" Lan speed is set as DCS_LAN_SPEED_10M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);
		printf("\n");
		fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_10M_HALF_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetLANSpeed(DCS_LAN_SPEED_10M_FULL_DUPLEX);
		printf("*** Set LAN speed 10M_FULL_DUPLEX, please wait 3 seconds, and press any key to continue\n");
		scanf("%c",&c0);

		DCS_GetLANSpeed(&lanspeed);
		//printf("*** Get LAN speed, press any key to continue\n");
		//scanf("%c",&c0);
		printf(" Lan speed is set as DCS_LAN_SPEED_10M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
		printf("\n");
		fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_10M_FULL_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetLANSpeed(DCS_LAN_SPEED_100M_HALF_DUPLEX);
		printf("*** Set LAN speed 100M_HALF_DUPLEX, please wait 3 seconds, and press any key to continue\n");
		scanf("%c",&c0);

		DCS_GetLANSpeed(&lanspeed);
		//printf("*** Get LAN speed, press any key to continue\n");
		//scanf("%c",&c0);
		printf(" Lan speed is set as DCS_LAN_SPEED_100M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);
		printf("\n");
		fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_100M_HALF_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetLANSpeed(DCS_LAN_SPEED_100M_FULL_DUPLEX);
		printf("*** Set LAN speed 100M_FULL_DUPLEX, please wait 3 seconds, and press any key to continue\n");
		scanf("%c",&c0);

		DCS_GetLANSpeed(&lanspeed);
		//printf("*** Get LAN speed, press any key to continue\n");
		//scanf("%c",&c0);
		printf(" Lan speed is set as DCS_LAN_SPEED_100M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
		printf("\n");
		fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_100M_FULL_DUPLEX and get the  Lan speed is:%d\n", lanspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		DCS_SetLANSpeed(DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE);
		printf("*** Set LAN Speed AUTO_NEGOTIATE, please wait 3 seconds, and press any key to continue\n");
		scanf("%c",&c0);

		DCS_GetLANSpeed(&lanspeed);
		//printf("*** Get LAN speed, press any key to continue\n");
		//scanf("%c",&c0);
		printf(" Lan speed is set as DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE and get the Lan speed is:%d\n", lanspeed);
		printf("\n");
		fprintf(pm_log , "Lan speed is set as DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE and get the  Lan speed is:%d\n", lanspeed);
		fflush(pm_log );


		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		//DCS_DPST  dpstlevel;

		//DCS_SetDPSTLevel(HIGHEST_POWER_SAVING);
		//printf("*** Set DPST level HIGHEST_POWER_SAVING, press any key to continue\n");
		// scanf("%c",&c0);

		//DCS_GetDPSTLevel(&dpstlevel);
		////printf("*** Get DPST level, press any key to continue\n");
		//// scanf("%c",&c0);
		//printf(" dpst level is set as HIGHEST_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		//printf("\n");
		//fprintf(pm_log , " dpst level is set as HIGHEST_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		//fflush(pm_log );


		//printf("*** press any key to continue\n");
		//scanf("%c",&c0);


		//DCS_SetDPSTLevel(MEDIUM_POWER_SAVING);
		//printf("*** Set DPST level MEDIUM_POWER_SAVING, press any key to continue\n");
		// scanf("%c",&c0);

		//DCS_GetDPSTLevel(&dpstlevel);
		////printf("*** Get DPST level, press any key to continue\n");
		//// scanf("%c",&c0);
		//printf(" dpst level is set as MEDIUM_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		//printf("\n");
		//fprintf(pm_log , " dpst level is set as MEDIUM_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		//fflush(pm_log );


		//printf("*** press any key to continue\n");
		//scanf("%c",&c0);


		//DCS_SetDPSTLevel(LOWER_POWER_SAVING);
		//printf("*** Set DPST level LOWER_POWER_SAVING, press any key to continue\n");
		// scanf("%c",&c0);

		//DCS_GetDPSTLevel(&dpstlevel);
		////printf("*** Get DPST level, press any key to continue\n");
		//// scanf("%c",&c0);
		//printf(" dpst level is set as LOWER_POWER_SAVING and get the dpst level  is:0x%x\n", dpstlevel);
		//printf("\n");
		//fprintf(pm_log , " dpst level is set as LOWER_POWER_SAVING and get the dpst level  is: 0x%x\n", dpstlevel);
		//fflush(pm_log );


		//printf("*** press any key to continue\n");
		//scanf("%c",&c0);


		//DCS_SetDPSTLevel(DISABLED_POWER_SAVING);
		//printf("*** Set DPST level DISABLED_POWER_SAVING, press any key to continue\n");
		// scanf("%c",&c0);

		//DCS_GetDPSTLevel(&dpstlevel);
		////printf("*** Get DPST level, press any key to continue\n");
		//// scanf("%c",&c0);
		//printf(" dpst level is set as DISABLED_POWER_SAVING and get the dpst level  is: 0x%x\n", dpstlevel);
		//printf("\n");
		//fprintf(pm_log , " dpst level is set as DISABLED_POWER_SAVING and get the dpst level is: 0x%x\n", dpstlevel);
		//fflush(pm_log );


		/*printf("*** press any key to continue\n");
		scanf("%c",&c0);*/


		ULONG batCount;
		ret=DCS_GetBatteryCount(&batCount);
		printf("*** press any key to continue\n");
		scanf("%c",&c0);

		printf("DCS_GetBatteryCount\n");
		if(ret==0)
		{
			printf("success\n");
		}
		if(ret==1)
		{
			printf("request is not supported\n");
		}
		if(ret==2)
		{
			printf("request is denied\n");
		}
		if(ret==3)
		{
			printf("request module does not exit\n");
		}
		if(ret==4)
		{
			printf("request event does not exit\n");
		}
		if(ret==5)
		{
			printf("request function does not exit\n");
		}
		if(ret==6)
		{
			printf("version mismatch\n");
		}

		DCS_Battery_Info battery;
		battery.BatteryStatus=0;

		DCS_GetBatteryInfo( &battery, 0);
		printf("*** press any key to continue\n");
		scanf("%c",&c0);


		printf("battary's Status :%d\n", battery.BatteryStatus);
		fprintf(pm_log , "battary's Status :%d\n", battery.BatteryStatus);
		fflush(pm_log );

		printf("battary's RemainPercent :%d\n", battery.RemainPercent);
		fprintf(pm_log , "battary's RemainPercent :%d\n", battery.RemainPercent);
		fflush(pm_log );

		printf("battary's RemainTime :%d\n", battery.RemainTime);
		fprintf(pm_log , "battary's RemainTime :%d\n", battery.RemainTime);
		fflush(pm_log );

		//   printf("battary's Capabilities :%d\n", battery.Capabilities);
		//fprintf(pm_log , "battary's Capabilities :%d\n", battery.Capabilities);
		//fflush(pm_log );

		printf("battary's DesignedCapacity :%d\n", battery.DesignedCapacity);
		fprintf(pm_log , "battary's DesignedCapacity :%d\n", battery.DesignedCapacity);
		fflush(pm_log );

		printf("battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);
		fprintf(pm_log , "battary's FullChargedCapacity :%d\n", battery.FullChargedCapacity);
		fflush(pm_log );

		//   printf("battary's Technology :%d\n", battery.Technology);
		//fprintf(pm_log , "battary's Technology :%d\n", battery.Technology);
		//fflush(pm_log );

		printf("battary's Chemistry :%s\n", battery.Chemistry);
		fprintf(pm_log , "battary's Chemistry :%s\n", battery.Chemistry);
		fflush(pm_log );

		//     printf("battary's DefaultAlert1 :%d\n", battery.DefaultAlert1);
		//  fprintf(pm_log , "battary's DefaultAlert1 :%d\n", battery.DefaultAlert1);
		// fflush(pm_log );

		//   printf("battary's DefaultAlert2 :%d\n", battery.DefaultAlert2);
		// fprintf(pm_log , "battary's DefaultAlert2 :%d\n", battery.DefaultAlert2);
		//fflush(pm_log );

		//     printf("battary's CriticalBias :%d\n", battery.CriticalBias);
		//fprintf(pm_log , "battary's CriticalBias :%d\n", battery.CriticalBias);
		//fflush(pm_log );

		//   printf("battary's CycleCount :%d\n", battery.CycleCount);
		// fprintf(pm_log , "battary's CycleCount :%d\n", battery.CycleCount);
		//fflush(pm_log );

		printf("battary's Current :%d\n", battery.Current);
		fprintf(pm_log , "battary's Current :%d\n", battery.Current);
		fflush(pm_log );

		printf("battary's Voltage :%d\n", battery.Voltage);
		fprintf(pm_log , "battary's Voltage :%d\n", battery.Voltage);
		fflush(pm_log );

		printf("battary's Temperature :%d\n", battery.Temperature);
		fprintf(pm_log , "battary's Temperature :%d\n", battery.Temperature);
		fflush(pm_log );



		// 2009-01-09 The following code added by Yunsong   
		// Test DCS_GetPowerStatus()
		printf("\n\nTest DCS_GetPowerStatus()     *** press any key to continue\n");
		scanf("%c",&c0);
		int iRet;
		DCS_Power_Status	bs;

		iRet = DCS_GetPowerStatus(&bs);
		if (0 == iRet)
		{
			printf("\tBattery Status: %d\n",bs.BatteryStatus);
			printf("\tRemain Percent: %d\n",bs.RemainPercent);
			printf("\tRemain Time: %d S\n",bs.RemainTime);
			fprintf(pm_log , "\tBattery Status: %d\n",bs.BatteryStatus);
			fprintf(pm_log , "\tRemain Percent: %d\n",bs.RemainPercent);
			fprintf(pm_log ,"\tRemain Time: %d S\n",bs.RemainTime);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetPowerStatus() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_GetPwrVariableOptCount()
		printf("\n\nTest DCS_GetPwrVariableOptCount()     *** press any key to continue\n");
		scanf("%c",&c0);
		int iVal;

		iRet = DCS_GetPwrVariableOptCount("CpuSpeed", &iVal);
		if(0 == iRet)
		{
			printf("\tCpuSpeed option number should be 4\n\tDCS_GetPwrVariableOptCount(\"CpuSpeed\") returned value is: %d\n", iVal);
			fprintf(pm_log, "\tCpuSpeed option number should be 4\n\tDCS_GetPwrVariableOptCount() returned value is : %d\n", iVal);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetPwrVariableOptCount() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_GetPwrVariableOptValue()
		printf("\n\nTest DCS_GetPwrVariableOptValue()     *** press any key to continue\n");
		scanf("%c",&c0);
		iRet = DCS_GetPwrVariableOptValue("CpuSpeed",1, &iVal);
		if(0 == iRet)
		{
			printf("\tThe value for CpuSpeed option 1 should be 75 %%\n\tDCS_GetPwrVariableOptValue(\"CpuSpeed\", 1) returned value is: %d%%\n", iVal);
			fprintf(pm_log, "\tThe value for CpuSpeed option 1 should be 75%\n\tDCS_GetPwrVariableOptValue(\"CpuSpeed\", 1) returned value is: %d %%\n", iVal);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetPwrVariableOptCount() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_GetUserID()
		printf("\n\nTest DCS_GetUserID()     *** press any key to continue\n");
		scanf("%c",&c0);
		char sTemp[256*4];

		iRet = DCS_GetUserID(sTemp, sizeof(sTemp));
		if(0 == iRet)
		{
			printf("\tUser ID: %s\n", sTemp);
			fprintf(pm_log, "\tUser ID: %s\n", sTemp);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetUserID() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_PutIntIntoCfg()
#define PUBLIC_CONFIG		1
#define PRIVATE_CONFIG		0
		printf("\n\nTest DCS_PutIntIntoCfg()     *** press any key to continue\n");
		scanf("%c",&c0);
		iRet = DCS_PutIntIntoCfg(PUBLIC_CONFIG,"TestCfg.ini","TestSection","testInt",10);
		if(0 == iRet)
		{
			printf("\tPut testInt=10 into TestSection of TestCfg.ini\n");
			fprintf(pm_log, "\tPut testInt=10 into TestSection of TestCfg.ini\n");
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_PutIntIntoCfg() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_GetIntFromCfg()
		printf("\nTest DCS_GetIntFromCfg()     *** press any key to continue\n");
		scanf("%c",&c0);
		iRet = DCS_GetIntFromCfg(PUBLIC_CONFIG,"TestCfg.ini","TestSection","testInt",0,&iVal);
		if(0 == iRet)
		{
			printf("\tGet testInt from TestSection of TestCfg.ini: %d\n", iVal);
			fprintf(pm_log, "\tGet testInt from TestSection of TestCfg.ini: %d\n", iVal);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetIntFromCfg() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_PutStringIntoCfg()
		printf("\n\nTest DCS_PutStringIntoCfg()     *** press any key to continue\n");
		scanf("%c",&c0);
		iRet = DCS_PutStringIntoCfg(PUBLIC_CONFIG,"TestCfg.ini","TestSection","testString","Kudos");
		if(0 == iRet)
		{
			printf("\tPut testString=Kudos into TestSection of TestCfg.ini\n");
			fprintf(pm_log, "\tPut testString=Kudos into TestSection of TestCfg.ini\n");
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_PutStringIntoCfg() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);


		// Test DCS_GetStringFromCfg()
		printf("\nTest DCS_GetStringFromCfg()     *** press any key to continue\n");
		scanf("%c",&c0);
		iRet = DCS_GetStringFromCfg(PUBLIC_CONFIG,"TestCfg.ini","TestSection","testString",sTemp,sizeof(sTemp));
		if(0 == iRet)
		{
			printf("\tGet testString from TestSection of TestCfg.ini is: %s\n\n\n", sTemp);
			fprintf(pm_log, "\tGet testString from TestSection of TestCfg.ini is: %s\n\n\n", sTemp);
		}
		else
		{
			fprintf(pm_log,"!!!Test DCS_GetStringFromCfg() failed with error code: %d\n",iRet);
		}
		fflush(pm_log);

	}


	/*uninitialize the DCS*/

	int count=0;
	int timer=0;

	if((use_accel==1)||(use_tablet==1)||(use_fnkey==1))
	{
		if(use_timer==0)
		{
			while(1);
		}else{
			for(timer=0;timer<=50000;timer++)
			{
				count=0;
			}
		}


		if(use_accel==1)
		{

			ret=DCS_UnregisterAccelCallback();
			printf("DCS_UnregisterAccelCallback\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}



			ret=DCS_UnregisterSystemOrientationCallback();
			printf("DCS_UnregisterSystemOrientationCallback\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if(use_tablet==1)
		{

			ret=DCS_UnregisterTabletSensorCallback();
			printf("DCS_UnregisterTabletSensorCallback\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}
		}


		if(use_fnkey==1)
		{
			ret=DCS_UnregisterFnKeyCallback();
			printf("DCS_UnDisableDesktopAutoRotation\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

		}

		if(use_pm==1)
		{

			ret=DCS_UnregisterLCDBrightnessChangedCallback();
			printf("DCS_UnregisterLCDBrightnessChangedCallback\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}

			ret=DCS_UnregisterWLanChangedCallback();
			printf("DCS_UnregisterWLanChangedCallback\n");
			if(ret==0)
			{
				printf("success\n");
			}
			if(ret==1)
			{
				printf("request is not supported\n");
			}
			if(ret==2)
			{
				printf("request is denied\n");
			}
			if(ret==3)
			{
				printf("request module does not exit\n");
			}
			if(ret==4)
			{
				printf("request event does not exit\n");
			}
			if(ret==5)
			{
				printf("request function does not exit\n");
			}
			if(ret==6)
			{
				printf("version mismatch\n");
			}
		}

	}

	ret=DCS_Uninitialize();

	if(ret==0)
	{
		printf("DCS_Uninitialize SUCCESS\n"); 

		return 0;
	}else 	
	{	

		printf("DCS_Uninitialize Fail\n"); 

		return ret;

	}

	fclose(accel_log);
	fclose(fnkey_log);
	fclose(tablet_log);
	fclose(pm_log);
	fclose(policy_log);




}

