/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "FnKeyApi.h"
#include "ReqMgmt.h"
#include "VKbdPlugin.h"

extern int DCS_Lock();
extern int DCS_Unlock();
extern DCS_Return_Code DCS_DispatchEvent();

static int GetModuleID()
{
	return DCS_VIRTUAL_KEY;
}

DCS_Return_Code DCS_RegisterFnKeyCallback(DCS_FnKey_Callback pCallback)
{
    DCS_Lock();
	DCS_Return_Code ret = DCS_SUCCESS;
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), VKBD_KEY_EVENT, (DCS_Callback)pCallback);
    if (ret)   {  DCS_Unlock(); return ret;}
	DCS_DispatchEvent();
    DCS_Unlock();
	return DCS_SUCCESS;	
}
DCS_Return_Code DCS_UnregisterFnKeyCallback()
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenUnregisterEventReq(GetModuleID(),VKBD_KEY_EVENT);
//	DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),FNKEY_UNREGISTER_CALLBACK, NULL);
    DCS_Unlock();
    return ret;
}
