/*
 * Easy Network API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "ENMApi.h"
#include "ENMPlugin.h"
#include "ReqMgmt.h"
#include "ConnMgmt.h"

extern int DCS_WaitResponse(DCS_Response* pResponse, int, int);
extern DCS_Return_Code DCS_DispatchEvent();
extern int DCS_Lock();
extern int DCS_Unlock();
extern void WINAPI DebugString(char* format, ...);


static int GetModuleID()
{
	return DCS_EASY_NETWORK_MANAGER;
}

DCS_Return_Code DCS_InitUserInfo(ENM_InitUserInfo initUserInfo)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_INIT_USER_INFO, sizeof(ENM_InitUserInfo),&initUserInfo);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_INIT_USER_INFO);

    DCS_Unlock();

  	return response.returnCode;
}

DCS_Return_Code DCS_AllocateDhIP()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_ALLOCATE_DH_IP, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_ALLOCATE_DH_IP);

    DCS_Unlock();

  	return response.returnCode;
}

DCS_Return_Code DCS_CloseWlanConnection()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_CLOSE_WLAN_CONNECTION, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_CLOSE_WLAN_CONNECTION);

    DCS_Unlock();

    return ret;
}

DCS_Return_Code DCS_SearchAdapter()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_SEARCH_ADAPTER, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_SEARCH_ADAPTER);

    DCS_Unlock();

    return ret;
}

DCS_Return_Code DCS_UpAdapter(ENM_ADAPTER_TYPE adapterType)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_UP_ADAPTER,sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_UP_ADAPTER);

    DCS_Unlock();

    return ret;
}

DCS_Return_Code DCS_DownAdapter(ENM_ADAPTER_TYPE adapterType)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_DOWN_ADAPTER,sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_DOWN_ADAPTER);

    DCS_Unlock();

    return ret;
}

DCS_Return_Code DCS_IsExistUpAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsUp)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_IS_EXIST_UP_ADAPTER,sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_IS_EXIST_UP_ADAPTER);

	if (response.data != NULL)
		*pOutIsUp = *((BOOL* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}
    return ret;
}

DCS_Return_Code DCS_IsExistConnectAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsConnect)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_IS_EXIST_CONNECT_ADAPTER,sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_IS_EXIST_CONNECT_ADAPTER);

	if (response.data != NULL)
		*pOutIsConnect = *((BOOL* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return ret;
}

DCS_Return_Code DCS_ConnectAP(ENM_ConnectAP connectAP)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_CONNECT_AP, sizeof(ENM_ConnectAP),&connectAP);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_CONNECT_AP);

    DCS_Unlock();

  	return response.returnCode;

}

DCS_Return_Code DCS_GetAPList(AccessPointList* pOutAPList)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_AP_LIST, sizeof(AccessPointList),pOutAPList);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_AP_LIST);

	if (response.data != NULL)
		*pOutAPList = *((AccessPointList* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetCurrentAP(APStatus* pOutCurrentAP)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_CURRENT_AP, sizeof(APStatus),pOutCurrentAP);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_CURRENT_AP);

	if (response.data != NULL)
		*pOutCurrentAP = *((APStatus* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;

}

DCS_Return_Code DCS_GetIPAddressHLAN(ENM_String* pOutIpAddress)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_IP_ADDRESS_HLAN, sizeof(ENM_String) , pOutIpAddress);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_IP_ADDRESS_HLAN);

	if (response.data != NULL)
		*pOutIpAddress = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_GetIPAddressLAN(ENM_String* pOutIpAddress)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_IP_ADDRESS_LAN, sizeof(ENM_String) , pOutIpAddress);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_IP_ADDRESS_LAN);

	if (response.data != NULL)
		*pOutIpAddress = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_GetConnectTypeHLAN(ENM_String* pOutConnectType)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_CONNECT_TYPE_HLAN, sizeof(ENM_String),pOutConnectType);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_CONNECT_TYPE_HLAN);

	if (response.data != NULL)
		*pOutConnectType = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_GetConnectTypeLAN(ENM_String* pOutConnectType)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_CONNECT_TYPE_LAN, sizeof(ENM_String),pOutConnectType);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_CONNECT_TYPE_LAN);

	if (response.data != NULL)
		*pOutConnectType = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_Enable8021xAuthentication(bool isEnable)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_ENABLE_8021X_AUTHENTICATION, sizeof(bool), &isEnable);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_ENABLE_8021X_AUTHENTICATION);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_EnableInternetSharing(bool isEnable)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_ENABLE_INTERNET_SHARING, sizeof(bool), &isEnable);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_ENABLE_INTERNET_SHARING);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_OverwriteHomePage(ENM_String* pStrHomePage)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_OVERWRITE_HOMEPAGE, sizeof(ENM_String) , pStrHomePage);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_OVERWRITE_HOMEPAGE);

	if (response.data != NULL)
		*pStrHomePage = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_OverwriteDefaultBrowserHomePage(ENM_String* pStrHomePage)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_OVERWRITE_DEFAULT_BROWSER_HOMEPAGE, sizeof(ENM_String) , pStrHomePage);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_OVERWRITE_DEFAULT_BROWSER_HOMEPAGE);

	if (response.data != NULL)
		*pStrHomePage = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_OverwriteProxy(ENM_ProxyInfo* pProxyInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_OVERWRITE_PROXY, sizeof(ENM_ProxyInfo), pProxyInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_OVERWRITE_PROXY);

	if (response.data != NULL)
		*pProxyInfo = *((ENM_ProxyInfo* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetNeighborsInfo(ENM_NEIGHBORS_INFO* pNeighborsInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_NEIGHBORS_INFO, sizeof(ENM_NEIGHBORS_INFO), pNeighborsInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_NEIGHBORS_INFO);

	if (response.data != NULL)
		*pNeighborsInfo = *((ENM_NEIGHBORS_INFO* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetNeighborInfo(ENM_NEIGHBORS_INFO* pNeighborsInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_GET_NEIGHBOR_INFO, sizeof(ENM_NEIGHBORS_INFO), pNeighborsInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_GET_NEIGHBOR_INFO);

	if (response.data != NULL)
		*pNeighborsInfo = *((ENM_NEIGHBORS_INFO* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_SetIPAddress(ENM_AddressInfo* pAddressInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_CHANGE_ADDRESS, sizeof(ENM_AddressInfo), pAddressInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_CHANGE_ADDRESS);

	if (response.data != NULL)
		*pAddressInfo = *((ENM_AddressInfo* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_EnableFileAndPrint(bool isEnable)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_ENABLE_FILE_AND_PRINTER_SHARE, sizeof(bool), &isEnable);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_ENABLE_FILE_AND_PRINTER_SHARE);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_EnableWindowsFirewall(bool isEnable)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_ENABLE_WINDOWS_FIREWALL, sizeof(bool), &isEnable);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), ENM_ENABLE_WINDOWS_FIREWALL);

	DCS_Unlock();

    return response.returnCode;
}



DCS_Return_Code DCS_IsExistAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsExist)
{
  DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_IS_EXIST_ADAPTER,sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_IS_EXIST_ADAPTER);

	if (response.data != NULL)
		*pOutIsExist = *((BOOL* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}
    return ret;
}


DCS_Return_Code DCS_ExecuteMeshCommand(ENM_String* pStrCommand)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_EXCUTE_COMMAND, sizeof(ENM_String) , pStrCommand);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_EXCUTE_COMMAND);

	if (response.data != NULL)
		*pStrCommand = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_TurnOnMesh(bool bTurnOn)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_TURNON_MESH, sizeof(bool), &bTurnOn);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), NN_TURNON_MESH);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_SetMeshSecurityInfo(MESH_SECURITY_INFO* pMeshSecurityInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_SECURITY_INFO, sizeof(MESH_SECURITY_INFO), pMeshSecurityInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_SECURITY_INFO);

	if (response.data != NULL)
		*pMeshSecurityInfo = *((MESH_SECURITY_INFO* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_SetMeshID()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), NN_SET_MESH_ID, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_ID);

    DCS_Unlock();

  	return response.returnCode;
}

DCS_Return_Code DCS_SetMeshAutoLink(int nAutoLink)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_AUTOLINK, sizeof(int), &nAutoLink);
	
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_AUTOLINK);
	DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_AddMeshLink()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), NN_ADD_MESH_LINK, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_ADD_MESH_LINK);

    DCS_Unlock();

  	return response.returnCode;
}

DCS_Return_Code DCS_DelMeshLink()
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), NN_DEL_MESH_LINK, 0,NULL);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_DEL_MESH_LINK);

    DCS_Unlock();

  	return response.returnCode;
}

DCS_Return_Code DCS_SetMeshChannel(int nChannel)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_CHANNEL, sizeof(int), &nChannel);
	
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_CHANNEL);
	DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_SetMeshHostName(ENM_String* pStrHostName)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_HOSTNAME, sizeof(ENM_String) , pStrHostName);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_HOSTNAME);

	if (response.data != NULL)
		*pStrHostName = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_EnableMeshOnly(bool bEnableOnly)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_ENABLE_MESH_ONLY, sizeof(bool), &bEnableOnly);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), NN_ENABLE_MESH_ONLY);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_EnableMeshForwarding(bool bForwarding) 
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_ENABLE_MESH_FORWARDING, sizeof(bool), &bForwarding);

	DCS_DispatchEvent();

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_WaitResponse(&response,  GetModuleID(), NN_ENABLE_MESH_FORWARDING);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_SetMeshChannelBandWidth(int nBandWidth)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_CHANNEL_BAND_WIDTH, sizeof(int), &nBandWidth);
	
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_CHANNEL_BAND_WIDTH);
	DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_SetMeshChannelOFFSET(int nFlag)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	pReqMgmt->GenFuncReq(GetModuleID(),NN_SET_MESH_CHANNEL_OFFSET, sizeof(int), &nFlag);
	
	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_SET_MESH_CHANNEL_OFFSET);
	DCS_Unlock();
	return response.returnCode;
}
DCS_Return_Code DCS_GetMeshSecurityInfo(MESH_SECURITY_INFO* pMeshSecurityInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_SECURITY_INFO, sizeof(MESH_SECURITY_INFO), pMeshSecurityInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_SECURITY_INFO);

	if (response.data != NULL)
		*pMeshSecurityInfo = *((MESH_SECURITY_INFO* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshID(ENM_String* pStrMeshID)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_ID, sizeof(ENM_String) , pStrMeshID);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_ID);

	if (response.data != NULL)
		*pStrMeshID = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_GetMeshAutoLink(int* nAutoLink)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_AUTOLINK, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_AUTOLINK);

	if (response.data != NULL)
		*nAutoLink = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshLinkStatus(int* nLinkStatus)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_LINKSTATUS, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_LINKSTATUS);

	if (response.data != NULL)
		*nLinkStatus = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_ListAllNeighborMPs(MESH_NEIGHBOR_INFO* pMeshNeighborInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_LIST_ALL_NEIGHBOR_MPS, sizeof(MESH_NEIGHBOR_INFO), pMeshNeighborInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_LIST_ALL_NEIGHBOR_MPS);

	if (response.data != NULL)
		*pMeshNeighborInfo = *((MESH_NEIGHBOR_INFO* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshRouteList(RT_MESH_ROUTE_TABLE* pRtMeshRouteTable)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_ROUTE_LIST, sizeof(RT_MESH_ROUTE_TABLE), pRtMeshRouteTable);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_ROUTE_LIST);

	if (response.data != NULL)
		*pRtMeshRouteTable = *((RT_MESH_ROUTE_TABLE* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshChannel(int* nChannel)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_CHANNEL, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_CHANNEL);

	if (response.data != NULL)
		*nChannel = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshOnlyMode(int* nEnableOnly)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_ONLY_MODE, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_ONLY_MODE);

	if (response.data != NULL)
		*nEnableOnly = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshDeviceName(ENM_String* pStrMeshDeviceName)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_DEVICE_NAME, sizeof(ENM_String) , pStrMeshDeviceName);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_DEVICE_NAME);

	if (response.data != NULL)
		*pStrMeshDeviceName = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_GetMeshChannelBandWidth(int* nBandWidth)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_CHANNEL_BAND_WIDTH, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_CHANNEL_BAND_WIDTH);

	if (response.data != NULL)
		*nBandWidth = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_GetMeshChannelOffset(int* nFlag)
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();	
	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_CHANNEL_OFFSET, 0, NULL);

	DCS_Response response;
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_CHANNEL_OFFSET);

	if (response.data != NULL)
		*nFlag = *((int* )response.data);
    DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

/* Registers the callback function to be notified  when the classmate PC changes the disabled status of LAN. */
DCSAPI DCS_Return_Code DCS_RegisterLanDisabledCallback (DCS_ENM_Disable_Lan_Callback pCallback)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), ENM_LAN_DISABLED, (DCS_Callback)pCallback);
    if (ret)   {  DCS_Unlock(); return ret;}
	DCS_DispatchEvent();
    DCS_Unlock();
	return DCS_SUCCESS;		
}

/* Unregisters the callback function for LAN status changed notifications. */
DCSAPI DCS_Return_Code DCS_UnregisterLanDisabledCallback()
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),ENM_LAN_DISABLED, NULL);	
    DCS_Unlock();
    return ret;
}

/* Registers the callback function to be notified  when the classmate PC changes the disabled status of WLAN. */
DCSAPI DCS_Return_Code DCS_RegisterWLanDisabledCallback (DCS_ENM_Disable_Wlan_Callback pCallback)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	ret = pReqMgmt->GenEventReq(GetModuleID(), ENM_WLAN_DISABLED, (DCS_Callback)pCallback);
    if (ret)   {  DCS_Unlock(); return ret;}
	DCS_DispatchEvent();
    DCS_Unlock();
	return DCS_SUCCESS;		
}

/* Unregisters the callback function for WLAN status changed notifications. */
DCSAPI DCS_Return_Code DCS_UnregisterWLanDisabledCallback()
{
    DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Return_Code ret =  pReqMgmt->GenEventReq(GetModuleID(),ENM_WLAN_DISABLED, NULL);	
    DCS_Unlock();
    return ret;
}

DCS_Return_Code DCS_DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), ENM_DISPATCH_DISABLE_EVENT, sizeof(ENM_ADAPTER_TYPE),&adapterType);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_DISPATCH_DISABLE_EVENT);

    DCS_Unlock();

    return ret;
}

/**/
DCS_Return_Code DCS_GetMeshHostName(ENM_String* pStrMeshHostName)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_MESH_HOST_NAME, sizeof(ENM_String) , pStrMeshHostName);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_MESH_HOST_NAME);

	if (response.data != NULL)
		*pStrMeshHostName = *((ENM_String* )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_EnableMeshServer(ENM_String* ifname)
{
    DCS_Lock();

	DCS_Return_Code ret = DCS_SUCCESS;

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	ret = pReqMgmt->GenFuncReq(GetModuleID(), NN_ENABLE_MESH_SERVER, sizeof(ENM_String) , ifname);

    if (ret){    DCS_Unlock(); return ret;}

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_ENABLE_MESH_SERVER);

    DCS_Unlock();

    return ret;
}

DCS_Return_Code DCS_EnableMeshClient(PMESH_GATEWAY_INFO pMeshGatewayInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_ENABLE_MESH_CLIENT, sizeof(MESH_GATEWAY_INFO) , pMeshGatewayInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_ENABLE_MESH_CLIENT);

	DCS_Unlock();

    return response.returnCode;
}

DCS_Return_Code DCS_GetMeshGatewayInfo(PMESH_GATEWAY_INFO pMeshGatewayInfo)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),NN_GET_GATEWAY_INFO, sizeof(MESH_GATEWAY_INFO) , pMeshGatewayInfo);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

    DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), NN_GET_GATEWAY_INFO);

	if (response.data != NULL)
		*pMeshGatewayInfo = *((PMESH_GATEWAY_INFO )response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

    return response.returnCode;
}

DCS_Return_Code DCS_ImportSchoolSettings(ENM_StringW* pFileName)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(),ENM_IMPORT_SCHOOL_SETTINGS, sizeof(ENM_StringW), pFileName);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response,  GetModuleID(), ENM_IMPORT_SCHOOL_SETTINGS);

	if (response.data != NULL)
		*pFileName= *((ENM_StringW*)response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}

DCS_Return_Code DCS_DeleteProfile(ENM_StringW* pFileName)
{
    DCS_Lock();

	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	pReqMgmt->GenFuncReq(GetModuleID(), NN_DELETE_PROFILE, sizeof(ENM_StringW), pFileName);

	DCS_Response response;

	memset(&response, 0, sizeof(response));

	DCS_DispatchEvent();

	DCS_WaitResponse(&response, GetModuleID(), NN_DELETE_PROFILE);

	if (response.data != NULL)
		*pFileName= *((ENM_StringW*)response.data);

	DCS_Unlock();

	if (response.data != NULL)
	{
		delete[]response.data;
		response.data = NULL;
	}

	return response.returnCode;
}