/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifndef VKD_HELPER_H
#define VKD_HELPER_H

#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>


#include <set>
#include "../../../../inc/DCSCommon.h"
#include "../../../../inc/plugins/DcsPlugin.h"
#include "../../../../inc/plugins/vkbd/VKbdDef.h"
#include "../../../../inc/plugins/vkbd/VKbdPlugin.h"

/**
 * @class VkdHelper
 * @brief VkdHelper provides help on operating Vkd driver.
 *
 * It is implemented as a singleton.
 */

//#define VKD_TEST

//typedef int __u32;

class VkdHelper
{
public:
	static VkdHelper &GetInstance()
	{
		static VkdHelper helper;
		return helper;
	};

	/** public functions which really implement DCS Plugin interfface. */
	int Initialize(DCS_Funcs *pDispatcher);
	DCS_Return_Code HandleRequest(DCS_RequestData *pRequest);
	int Cleanup();

public:

	VkdHelper(void)
		: m_Thread(0), m_Device(-1)
	{
		m_Backlight_Count = 0;
	};

	~VkdHelper(void)
	{
	};

	/** declare copy constructor and equal operator to prevent
	 *  copied instance
	 */
	VkdHelper(const VkdHelper &);
	VkdHelper &operator =(const VkdHelper &);

	/* Vkd related functions */
	BOOL ProcFnkeyMsg(int oprt);
	BOOL DispatchEventToDCS(DCS_VKbd_Data data);

//	void TestFun();
//	void TestSiglrmHandler(int sig);

//	void SetTimer(int interval, int value);
//	void BzbnSiglrmHandler(int sig);
//	void BacklightSiglrmHandler(int sig);

	void SetBzbnPressed();
	void SetBzbnReleased();
	void SetBacklightDownPressed(void);
	void SetBacklightDownReleased(void);
	void SetBacklightUpPressed(void);
	void SetBacklightUpReleased(void);

	/* Vkd related variables */
	int m_Bzbn_Signal;
	int m_Backlight_Signal;
	int m_Backlight_Count;

	/** pointer to DCS dispatch function */
	DCS_Funcs *m_pFuncs;

	/** const values */
	static const char * const MODULE_NAME; /** Vkd chip module name */

	/** Linux working thread function */
	friend void *VkdEventHandler(void *arg);	

	static const char * const DEVICE_PATH; /** path to open driver */

	pthread_t m_Thread;
	int m_Device;
	  /* set to record the user IDs    */
        std::set<int> m_ClientIdSet;

public:
	void TestFun();
#ifndef VKD_TEST
	void SetTimer(int interval, int value);
#endif
//	void TestSiglrmHandler(int sig);
//	void BzbnSiglrmHandler(int sig);
//	void BacklightSiglrmHandler(int sig);

};
#endif /** VKD_HELPER_H */

