/****************************************************************************

Copyright (c) Intel Corporation (2008).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:          PowerSchemeMgmt.h

Description:

    This file defines class PowerSchemeMgmt.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef POWERSCHEMEMGMT_H_INCLUDED
#define POWERSCHEMEMGMT_H_INCLUDED

#include "inc/DCSCommon.h"
#include "xmlparser/tinyxml.h"

#include <cstdlib>
#include <string>
#include <iostream>
#include <map>
#include <vector>
using namespace std;
#include <pwd.h>
#include <stdio.h>

const string SCHEMEFILE("/.ipm/PowerScheme_pmsch.xml");
const string DEFAULTSCHEMEFILE("/etc/ipower-management/config-file-bak/PowerScheme_pmsch.xml");

const string SCHEMES("schemes");
const string SCHEME("scheme");
const string NAME("name");
const string SCHEMEID("schemeid");
const string DEFAULT("isdefault");
const string DESC("desc");
const string SCHEME_ACTIVE("active");
const string ACVALUE("acvalue");
const string DCVALUE("dcvalue");
const string VALUE("value");

const int BUFFER_SIZE = 256;
const int SETTING_MAX_NUM = 6;
//const string SCHEME_SETTINGS[SETTING_MAX_NUM] = {
//            "LCDBrightness", "LANSpeed", "CloseLCD", "Standby", "LANStatus", "WLANStatus"};

const int DEFAULT_SCHEMEID[3] = {807111933, 269187357, 807111934};
const int NONDEFAULT = 0;

class PowerSchemeMgmt{

public:
    PowerSchemeMgmt(string userHomeDir);
    ~PowerSchemeMgmt();

    DCS_Return_Code GetActiveSchemeId(int &schemeId);
    DCS_Return_Code DeletePowerScheme(int schemeId);
    DCS_Return_Code SetActivePowerScheme(int schemeId);
    DCS_Return_Code AddPowerScheme(char *pName, char *pDesc, int copyFrom, int schemeId);

    //Sets a variable value in a power scheme.
    DCS_Return_Code SetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int value);

    //Gets the value of the variable.
    DCS_Return_Code GetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue);

    DCS_Return_Code GetPowerSchemeNameDesc(int schemeId, string &pSchemeName, string &pSchemeDesc);

    DCS_Return_Code InitSchemeFilePath();

private:
    DCS_Return_Code GetDefaultSchemeInfo(int schemeId, map<string, int> &acMapping, map<string, int> &dcMapping);

private:
    string m_SchemeFilePath;
};


#endif // POWERSCHEMEMGMT_H_INCLUDED
