/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_POLICYCONTROL_DEF_H
#define DCS_POLICYCONTROL_DEF_H

/** Definition of the user groups. */
typedef enum DCS_UserGroup_E {
	DCS_ADMINISTRATOR_GROUP,
	DCS_PARENT_GROUP,
	DCS_STUDENT_GROUP
}DCS_UserGroup;

/** Definition of the policies. */
typedef enum DCS_Policy_Access_E {
	DCS_POLICY_ALLOWED,
	DCS_POLICY_REJECTED
}DCS_Policy_Access;

/** the operation provided by Policy Control module */
typedef enum DCS_Policy_Operation_E{
	POLICY_SET,
	POLICY_GET,
	POLICY_REMOVE,
	POLICY_SET_DEFAULT,
	POLICY_SAVE
}DCS_Policy_Operation;

/** Definition of the DCS policy data infomation */
typedef struct DCS_Policy_Data_S{
	int moduleId;
	DCS_UserGroup userGroup;
	int opId;
	DCS_Policy_Access access;
}DCS_Policy_Data;

#endif /* DCS_POLICYCONTROL_DEF_H */
